/*
 * Decompiled with CFR 0.152.
 */
package com.fmaillet.orthocotation;

import com.fmaillet.orthocotation.CustomRenderer4;
import com.fmaillet.orthocotation.OrthoCotation;
import com.fmaillet.orthocotation.Panel_TVPS4;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChartTVPS4 {
    static JFreeChart chart;
    ChartPanel panel;
    CategoryPlot plot;
    Color currentColor;
    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    BarRenderer barRenderer;
    final IntervalMarker target;

    public BarChartTVPS4() {
        Color lightBlue;
        chart = ChartFactory.createBarChart("TVPS-4 scores & percentiles", "Subtests", "Scaled Scores", this.dataset, PlotOrientation.VERTICAL, true, true, false);
        this.panel = new ChartPanel(chart);
        chart.removeLegend();
        chart.setTitle(new TextTitle("TVPS-4 scores & percentiles", new Font(chart.getTitle().getFont().getFontName(), 1, 17)));
        JPopupMenu popup = this.panel.getPopupMenu();
        popup.remove(0);
        popup.remove(0);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        JMenuItem j = (JMenuItem)popup.getComponent(1);
        j.setText("Enregistrer");
        this.plot = (CategoryPlot)chart.getPlot();
        this.plot.getRangeAxis().setAutoRange(false);
        this.plot.getRangeAxis().setRange(0.0, 20.0);
        this.plot.getRangeAxis().setUpperMargin(this.plot.getRangeAxis().getUpperMargin() * 2.0);
        this.plot.setBackgroundPaint(ChartColor.white);
        this.plot.setRangeGridlinesVisible(true);
        this.plot.setRangeGridlinePaint(ChartColor.GRAY);
        this.currentColor = lightBlue = new Color(51, 153, 255, 155);
        this.barRenderer = new CustomRenderer4(OrthoCotation.panelTVPS4, this.currentColor);
        this.plot.setRenderer(this.barRenderer);
        this.plot.setForegroundAlpha(0.95f);
        this.barRenderer.setDrawBarOutline(false);
        this.barRenderer.setDefaultItemLabelGenerator(new StandardCategoryItemLabelGenerator(){

            @Override
            public String generateLabel(CategoryDataset dataset, int row, int column) {
                if (Panel_TVPS4.tvpsPctlValues[Panel_TVPS4.transposeColumn[column]] < 1) {
                    return "<1er p.";
                }
                if (Panel_TVPS4.tvpsPctlValues[Panel_TVPS4.transposeColumn[column]] == 1) {
                    return "1er p.";
                }
                if (Panel_TVPS4.tvpsPctlValues[Panel_TVPS4.transposeColumn[column]] < 100) {
                    return String.valueOf(Panel_TVPS4.tvpsPctlValues[Panel_TVPS4.transposeColumn[column]]) + "\u00e8 p.";
                }
                return ">99\u00e8 p.";
            }
        });
        this.barRenderer.setSeriesItemLabelFont(0, new Font("Arial", 2, 10));
        this.barRenderer.setDefaultItemLabelsVisible(true);
        ItemLabelPosition position = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER);
        this.barRenderer.setDefaultPositiveItemLabelPosition(position);
        this.barRenderer.setDrawBarOutline(false);
        this.barRenderer.setItemMargin(0.2);
        this.barRenderer.setMaximumBarWidth(0.08);
        this.barRenderer.setShadowVisible(false);
        this.target = new IntervalMarker(7.0, 13.0);
        this.target.setLabelFont(new Font("SansSerif", 2, 11));
        this.target.setLabelAnchor(RectangleAnchor.LEFT);
        this.target.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
        this.target.setPaint(new Color(222, 222, 255, 128));
    }

    public JPanel addBarPanel() {
        this.panel.setMouseZoomable(false);
        return this.panel;
    }

    public void updateVisibleScores() {
        if (Panel_TVPS4.jScoresUnit.getSelectedIndex() == 0) {
            this.plot.getRangeAxis().setRange(0.0, 20.0);
            this.plot.getRangeAxis().setUpperMargin(this.plot.getRangeAxis().getUpperMargin() * 2.0);
            this.barRenderer.setSeriesVisible(1, false);
            this.barRenderer.setSeriesVisible(0, true);
            this.target.setStartValue(7.0);
            this.target.setEndValue(13.0);
            this.plot.getRangeAxis().setLabel("Scaled scores");
        } else {
            this.plot.getRangeAxis().setRange(40.0, 150.0);
            this.plot.getRangeAxis().setUpperMargin(this.plot.getRangeAxis().getUpperMargin() * 2.0);
            this.barRenderer.setSeriesVisible(1, true);
            this.barRenderer.setSeriesVisible(0, false);
            this.target.setStartValue(85.0);
            this.target.setEndValue(115.0);
            this.plot.getRangeAxis().setLabel("Standard scores");
        }
    }

    public void updateGraph() {
        this.dataset.clear();
        if (OrthoCotation.user.nom == null) {
            this.panel.setEnabled(false);
            return;
        }
        this.panel.setEnabled(true);
        int count = 0;
        if (Panel_TVPS4.tvpsChkValues[0]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[0], (Comparable)((Object)"Scaled"), (Comparable)((Object)"DIS"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[0] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"DIS"));
            ++count;
        }
        if (Panel_TVPS4.tvpsChkValues[1]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[1], (Comparable)((Object)"Scaled"), (Comparable)((Object)"MEM"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[1] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"MEM"));
            ++count;
        }
        if (Panel_TVPS4.tvpsChkValues[2]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[2], (Comparable)((Object)"Scaled"), (Comparable)((Object)"SPA"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[2] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"SPA"));
            ++count;
        }
        if (Panel_TVPS4.tvpsChkValues[3]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[3], (Comparable)((Object)"Scaled"), (Comparable)((Object)"CON"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[3] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"CON"));
            ++count;
        }
        if (Panel_TVPS4.tvpsChkValues[4]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[4], (Comparable)((Object)"Scaled"), (Comparable)((Object)"SEQ"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[4] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"SEQ"));
            ++count;
        }
        if (Panel_TVPS4.tvpsChkValues[5]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[5], (Comparable)((Object)"Scaled"), (Comparable)((Object)"FGR"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[5] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"FGR"));
            ++count;
        }
        if (Panel_TVPS4.tvpsChkValues[6]) {
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[6], (Comparable)((Object)"Scaled"), (Comparable)((Object)"CLO"));
            this.dataset.addValue(Panel_TVPS4.tvpsSclValues[6] * 5 + 50, (Comparable)((Object)"Standard"), (Comparable)((Object)"CLO"));
            ++count;
        }
        if (OrthoCotation.tvps4ChartPanel != null) {
            OrthoCotation.tvps4ChartPanel.setBounds(660 + (7 - count) * 30, 20, 500 - (7 - count) * 30, 300 - (7 - count) * 12);
        }
        this.updateVisibleScores();
        Panel_TVPS4.jChgeColor.setEnabled(true);
    }

    public void changeColor(Color c) {
        this.currentColor = c;
        CustomRenderer4.chgColor(c);
        this.updateGraph();
    }

    public void changeAspect(boolean titre, boolean subTitle, boolean rge) {
        if (titre) {
            chart.setTitle(new TextTitle("TVPS-4 scores & percentiles", new Font(chart.getTitle().getFont().getFontName(), 1, 17)));
        } else {
            chart.setTitle("");
        }
        if (subTitle) {
            this.plot.getDomainAxis().setLabel("Subtests");
        } else {
            this.plot.getDomainAxis().setLabel("");
        }
        if (rge) {
            if (this.plot.getRangeMarkers(Layer.BACKGROUND) == null) {
                this.plot.addRangeMarker(this.target, Layer.BACKGROUND);
            } else if (this.plot.getRangeMarkers(Layer.BACKGROUND).isEmpty()) {
                this.plot.addRangeMarker(this.target, Layer.BACKGROUND);
            }
        } else {
            this.plot.removeRangeMarker(this.target, Layer.BACKGROUND);
        }
    }
}

