/*
 * Decompiled with CFR 0.152.
 */
package com.fmaillet.orthocotation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooserButton
extends JButton {
    private Color current;
    private List<ColorChangedListener> listeners = new ArrayList<ColorChangedListener>();

    public ColorChooserButton(Color c) {
        this.setSelectedColor(c);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color newColor = JColorChooser.showDialog(null, "Choose a color", ColorChooserButton.this.current);
                ColorChooserButton.this.setSelectedColor(newColor);
            }
        });
    }

    public Color getSelectedColor() {
        return this.current;
    }

    public void setSelectedColor(Color newColor) {
        this.setSelectedColor(newColor, true);
    }

    public void setSelectedColor(Color newColor, boolean notify) {
        if (newColor == null) {
            return;
        }
        this.current = newColor;
        this.setIcon(ColorChooserButton.createIcon(this.current, 16, 16));
        this.repaint();
        if (notify) {
            for (ColorChangedListener l : this.listeners) {
                l.colorChanged(newColor);
            }
        }
    }

    public void addColorChangedListener(ColorChangedListener toAdd) {
        this.listeners.add(toAdd);
    }

    public static ImageIcon createIcon(Color main, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(main);
        graphics.fillRect(0, 0, width, height);
        graphics.setXORMode(Color.DARK_GRAY);
        graphics.drawRect(0, 0, width - 1, height - 1);
        image.flush();
        ImageIcon icon = new ImageIcon(image);
        return icon;
    }

    public static interface ColorChangedListener {
        public void colorChanged(Color var1);
    }
}

