/*
 * Decompiled with CFR 0.152.
 */
package com.fmaillet.orthocotation;

import com.fmaillet.orthocotation.OrthoCotation;
import com.fmaillet.orthocotation.UserInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class ConnectDialog
extends Dialog {
    Connection laConnection = null;
    Statement transmission;
    ResultSet leResultat;
    String nom;
    String prenom;
    String titre;
    String message;
    String version;
    String activite;
    String dateLimite;
    private JFormattedTextField jAdeli;
    private JFormattedTextField jCode;
    private JButton jConnexion;
    private JButton jFermer;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextArea jMessages;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private Label label1;
    private Label label2;

    public ConnectDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jAdeli.setText("");
        this.jCode.setText("");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.label1 = new Label();
        this.label2 = new Label();
        this.jConnexion = new JButton();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jMessages = new JTextArea();
        this.jFermer = new JButton();
        this.jAdeli = new JFormattedTextField();
        this.jCode = new JFormattedTextField();
        this.setAlwaysOnTop(true);
        this.setBackground(Color.cyan);
        this.setLocationRelativeTo(this.getOwner());
        this.setResizable(false);
        this.setTitle("orthoCotation : connexion au serveur...");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ConnectDialog.this.closeDialog(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ConnectDialog.this.formKeyPressed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 18));
        this.jLabel1.setText("Connexion au serveur :");
        this.label1.setFont(new Font("Dialog", 1, 12));
        this.label1.setText("Identifiant (Adeli) :");
        this.label2.setFont(new Font("Dialog", 1, 12));
        this.label2.setText("Votre code :");
        this.jConnexion.setFont(new Font("Tahoma", 1, 14));
        this.jConnexion.setText("Connexion");
        this.jConnexion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.jConnexionActionPerformed(evt);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/com/fmaillet/orthocotation/connect.png")));
        this.jMessages.setColumns(20);
        this.jMessages.setRows(5);
        this.jScrollPane1.setViewportView(this.jMessages);
        this.jFermer.setFont(new Font("Tahoma", 1, 14));
        this.jFermer.setText("Fermer");
        this.jFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectDialog.this.jFermerActionPerformed(evt);
            }
        });
        this.jAdeli.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.jAdeli.setToolTipText("Identifiant \u00e0 9 chiffres");
        this.jAdeli.setFocusLostBehavior(3);
        this.jAdeli.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ConnectDialog.this.jAdeliFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ConnectDialog.this.jAdeliFocusLost(evt);
            }
        });
        this.jCode.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.jCode.setToolTipText("Code secret \u00e0 5 chiffres");
        this.jCode.setFocusLostBehavior(3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jFermer, -2, 85, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 229, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.label1, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.label2, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jAdeli).addComponent(this.jConnexion, -1, 141, Short.MAX_VALUE).addComponent(this.jCode)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 48, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 121, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 141, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label1, -2, -1, -2).addComponent(this.jAdeli, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label2, -2, -1, -2).addComponent(this.jCode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConnexion, -2, 34, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFermer).addGap(18, 18, 18)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jConnexionActionPerformed(ActionEvent evt) {
        String adeli = this.jAdeli.getText().trim();
        if (adeli.length() != 9) {
            this.jMessages.append("-> Format Adeli incorrect (doit contenir 9 chiffres)\n");
            return;
        }
        String code = this.jCode.getText().trim();
        if (code.length() != 5) {
            this.jMessages.append("-> Format code incorrect (doit contenir 5 chiffres)\n");
            return;
        }
        this.jMessages.append("----- Connexion en cours :\n");
        if (this.connection(adeli, code)) {
            this.jConnexion.setEnabled(false);
        }
    }

    private void jAdeliFocusGained(FocusEvent evt) {
        this.jAdeli.setText(this.jAdeli.getText().trim());
    }

    private void jAdeliFocusLost(FocusEvent evt) {
        this.jAdeli.setText(this.jAdeli.getText().trim());
    }

    private void jFermerActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    public boolean connection(String a, String c) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Date dt = new Date();
        try {
            this.laConnection = DriverManager.getConnection("jdbc:mysql://fredericmaillet.fr/fmaillet_professionnels?useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC", "fmaillet_fredo", "mastercog");
        }
        catch (Exception e) {
            this.jMessages.append("-> Connection error : \n" + e.toString());
        }
        try {
            this.transmission = this.laConnection.createStatement(1003, 1008);
            this.leResultat = this.transmission.executeQuery("select * from Pro where ADELI = " + a);
            if (this.leResultat.next()) {
                Date d;
                SimpleDateFormat sdf;
                boolean ok = false;
                this.jMessages.append("-> Adeli ok dans la BdD\n");
                byte jeton = this.leResultat.getByte("JETON");
                if ((jeton & 1) != 0) {
                    this.jMessages.append("-> Utilisateur d\u00e9j\u00e0 connect\u00e9 !?\n");
                    String chk = this.leResultat.getString("MACADR2");
                    if (chk.equals(UserInfo.macaddress)) {
                        this.jMessages.append("-> Ordinateur reconnu : ok.\n");
                        ok = true;
                    } else {
                        this.jMessages.append("-> Ordinateurs diff\u00e9rents: connexion diff\u00e9r\u00e9e une heure...\n");
                        this.dateLimite = this.leResultat.getString("LASTCONNECTION");
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        d = sdf.parse(this.dateLimite);
                        long delay = (dt.getTime() - d.getTime()) / 3600000L;
                        if ((double)delay >= 1.0) {
                            ok = true;
                            this.jMessages.append("-> Ordinateurs diff\u00e9rents: connexion accept\u00e9e...\n");
                        }
                    }
                } else {
                    jeton = (byte)(jeton | 1);
                    this.leResultat.updateByte("JETON", jeton);
                    ok = true;
                }
                if (ok) {
                    this.leResultat.updateString("MACADR2", UserInfo.macaddress);
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String currentTime = sdf.format(dt);
                    this.leResultat.updateString("LASTCONNECTION", currentTime);
                    this.leResultat.updateRow();
                    this.dateLimite = this.leResultat.getString("LIMITE");
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    d = sdf.parse(this.dateLimite);
                    if (d.before(dt)) {
                        this.jMessages.append("-> Abonnement termin\u00e9 au " + this.dateLimite + " : connexion impossible.\n");
                        ok = false;
                    }
                }
                if (ok && c.equals(this.leResultat.getString("PWD"))) {
                    this.jMessages.append("-> Code ok dans la BdD\n-> R\u00e9cup\u00e9ration des donn\u00e9es...\n");
                    this.jMessages.append("-> P\u00e9riode d'essai ok jusqu'au " + this.dateLimite + "\n");
                    this.nom = this.leResultat.getString("NOM");
                    this.prenom = this.leResultat.getString("PRENOM");
                    this.titre = this.leResultat.getString("TITRE");
                    this.activite = this.leResultat.getString("ACTIVITE");
                    this.message = "";
                    this.message = this.leResultat.getString("MSG");
                    OrthoCotation.user.adr1 = this.leResultat.getString("ADR1");
                    OrthoCotation.user.adr2 = this.leResultat.getString("ADR2");
                    OrthoCotation.user.cp = this.leResultat.getString("CP");
                    OrthoCotation.user.ville = this.leResultat.getString("VILLE");
                    OrthoCotation.user.tel1 = this.leResultat.getString("TEL1");
                    OrthoCotation.user.tel2 = this.leResultat.getString("TEL2");
                    OrthoCotation.user.mail = this.leResultat.getString("MAIL");
                } else {
                    this.jMessages.append("-> Erreur : Connection refus\u00e9e...\n");
                }
            } else {
                this.jMessages.append("-> Erreur : Adeli absent de la BdD !\n");
            }
        }
        catch (Exception e) {
            this.jMessages.append("-> Pb connection (identification) : \n" + e.toString());
        }
        try {
            this.laConnection.close();
            this.transmission.close();
            this.leResultat.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (this.nom == null) {
            return false;
        }
        OrthoCotation.user.adeli = a;
        OrthoCotation.user.code = c;
        OrthoCotation.user.nom = this.nom;
        OrthoCotation.user.prenom = this.prenom;
        OrthoCotation.user.titre = this.titre;
        OrthoCotation.user.activite = this.activite;
        this.jMessages.append("-> Connexion ok : " + OrthoCotation.user.titre + " " + OrthoCotation.user.nom + " " + OrthoCotation.user.prenom + " (" + OrthoCotation.user.activite + ")\n");
        if (this.message.length() > 0) {
            this.jMessages.append("-> Message du serveur :\n\n" + this.message);
        } else {
            this.jMessages.append("-> Pas de message du serveur.\n");
        }
        OrthoCotation.connected();
        return true;
    }
}

