/*
 * Decompiled with CFR 0.152.
 */
package com.fmaillet.orthocotation;

import com.fmaillet.orthocotation.BaseDSValues;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MyPolarChart {
    public static JFreeChart chart;
    public static List<Title> subTitles;
    public static TextTitle title;
    static XYSeriesCollection dataset;
    static DefaultPolarItemRenderer renderer;
    Shape nullShape = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);
    ChartPanel panel;
    List ticks;

    public MyPolarChart() {
        XYDataset dataset = MyPolarChart.getXYDataset();
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setTickLabelsVisible(true);
        numberAxis.setTickMarksVisible(false);
        numberAxis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        numberAxis.setAxisLineVisible(false);
        numberAxis.setAutoRange(false);
        numberAxis.setRange(-5.0, 3.0);
        numberAxis.setVisible(true);
        renderer = new DefaultPolarItemRenderer();
        renderer.setFillComposite(AlphaComposite.getInstance(3, 0.25f));
        renderer.setShapesVisible(true);
        renderer.setSeriesPaint(0, Color.BLUE);
        renderer.setSeriesFilled(0, false);
        renderer.setSeriesFilled(1, true);
        renderer.setSeriesPaint(1, Color.RED);
        renderer.setSeriesStroke(1, new BasicStroke(0.0f));
        renderer.setSeriesPaint(2, Color.GREEN);
        renderer.setSeriesShape(1, this.nullShape);
        renderer.setSeriesShape(2, this.nullShape);
        this.ticks = new ArrayList();
        PolarPlot plot = new PolarPlot(dataset, numberAxis, renderer){

            @Override
            protected List refreshAngleTicks() {
                return MyPolarChart.this.ticks;
            }
        };
        plot.setAngleGridlinesVisible(true);
        plot.setRadiusMinorGridlinesVisible(false);
        plot.setBackgroundPaint(Color.white);
        plot.setAngleGridlinePaint(Color.black);
        plot.setRadiusGridlinePaint(Color.lightGray);
        plot.setOutlineVisible(false);
        title = new TextTitle("Ecarts \u00e0 la norme des principaux indicateurs orthoptiques", new Font("SansSerif", 1, 14));
        chart = new JFreeChart("Title", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        chart.setTitle(title);
        chart.setBackgroundPaint(Color.WHITE);
        chart.setBorderVisible(false);
        subTitles = new ArrayList<Title>();
        subTitles.add(new TextTitle("(exprim\u00e9 en d\u00e9viation standard, DS)"));
        chart.setSubtitles(subTitles);
        chart.removeLegend();
    }

    public void changeTransparency(int v) {
        float d = (float)v / 100.0f;
        renderer.setFillComposite(AlphaComposite.getInstance(3, d));
    }

    public void restoreTitles() {
        chart.setTitle(title);
        chart.removeLegend();
    }

    public JPanel addPolarPanel() {
        this.panel = new ChartPanel(chart);
        this.panel.setMouseZoomable(false);
        JPopupMenu popup = this.panel.getPopupMenu();
        popup.remove(0);
        popup.remove(0);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        popup.remove(2);
        JMenuItem j = (JMenuItem)popup.getComponent(1);
        j.setText("Enregistrer");
        return this.panel;
    }

    public int updateTicks() {
        this.ticks.clear();
        int n = (BaseDSValues.phorieL.selected ? 1 : 0) + (BaseDSValues.phorieP.selected ? 1 : 0) + (BaseDSValues.fusionDP.selected ? 1 : 0) + (BaseDSValues.fusionCP.selected ? 1 : 0) + (BaseDSValues.fusionCL.selected ? 1 : 0) + (BaseDSValues.fusionDL.selected ? 1 : 0) + (BaseDSValues.ppc.selected ? 1 : 0) + (BaseDSValues.ppa.selected ? 1 : 0) + (BaseDSValues.aca.selected ? 1 : 0) + (BaseDSValues.fdv.selected ? 1 : 0) + (BaseDSValues.fda.selected ? 1 : 0);
        if (n <= 0) {
            return 0;
        }
        n = 360 / n;
        int index = 0;
        if (BaseDSValues.phorieL.selected) {
            this.ticks.add(new NumberTick((Number)index, "Phorie(L)", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.phorieP.selected) {
            this.ticks.add(new NumberTick((Number)index, "Phorie(P)", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.fusionDP.selected) {
            this.ticks.add(new NumberTick((Number)index, "D'", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.fusionCP.selected) {
            this.ticks.add(new NumberTick((Number)index, "C'", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.fusionCL.selected) {
            this.ticks.add(new NumberTick((Number)index, "C", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.fusionDL.selected) {
            this.ticks.add(new NumberTick((Number)index, "D", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.ppc.selected) {
            this.ticks.add(new NumberTick((Number)index, "PPC", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.ppa.selected) {
            this.ticks.add(new NumberTick((Number)index, "PPA", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.aca.selected) {
            this.ticks.add(new NumberTick((Number)index, "AC/A", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.fdv.selected) {
            this.ticks.add(new NumberTick((Number)index, "FdV", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        if (BaseDSValues.fda.selected) {
            this.ticks.add(new NumberTick((Number)index, "FdA", TextAnchor.TOP_LEFT, TextAnchor.TOP_LEFT, 0.0));
            index += n;
        }
        return n;
    }

    public void updateDataset() {
        int i;
        int i2;
        dataset.removeAllSeries();
        XYSeries redRing = new XYSeries((Comparable)((Object)"redRing"), true);
        for (int i3 = 0; i3 <= 360; i3 += 5) {
            redRing.add((double)i3, -1.0);
        }
        XYSeries greenRing = new XYSeries((Comparable)((Object)"greenRing"), false);
        for (i2 = 0; i2 <= 360; i2 += 5) {
            greenRing.add((double)i2, 1.0);
        }
        for (i2 = 360; i2 >= 0; i2 -= 5) {
            greenRing.add((double)i2, -1.0);
        }
        XYSeries darkGreenRing = new XYSeries((Comparable)((Object)"darkGreenRing"), false);
        for (i = 0; i <= 360; i += 5) {
            darkGreenRing.add((double)i, 3.0);
        }
        for (i = 360; i >= 0; i -= 5) {
            darkGreenRing.add((double)i, 1.0);
        }
        float[] dash_array = new float[]{Float.MIN_VALUE, Float.MAX_VALUE};
        BasicStroke stroke = new BasicStroke(0.0f, 2, 1, 10.0f, dash_array, 0.0f);
        renderer.setFillComposite(AlphaComposite.getInstance(3, 0.3f));
        renderer.setShapesVisible(true);
        renderer.setSeriesFilled(2, true);
        renderer.setSeriesPaint(2, Color.RED);
        renderer.setSeriesStroke(2, stroke);
        renderer.setSeriesShape(2, this.nullShape);
        renderer.setSeriesFilled(1, true);
        renderer.setSeriesPaint(1, Color.GREEN);
        renderer.setSeriesStroke(1, stroke);
        renderer.setSeriesShape(1, this.nullShape);
        renderer.setSeriesFilled(0, true);
        renderer.setSeriesPaint(0, Color.GREEN.darker());
        renderer.setSeriesStroke(0, stroke);
        renderer.setSeriesShape(0, this.nullShape);
        renderer.setSeriesPaint(3, Color.BLUE);
        renderer.setSeriesFilled(3, false);
        XYSeries datas = new XYSeries((Comparable)((Object)"datas"));
        int index = 0;
        int n = this.updateTicks();
        if (n == 0) {
            return;
        }
        if (BaseDSValues.phorieL.selected) {
            datas.add((double)index, BaseDSValues.phorieL.ds);
            index += n;
        }
        if (BaseDSValues.phorieP.selected) {
            datas.add((double)index, BaseDSValues.phorieP.ds);
            index += n;
        }
        if (BaseDSValues.fusionDP.selected) {
            datas.add((double)index, BaseDSValues.fusionDP.ds);
            index += n;
        }
        if (BaseDSValues.fusionCP.selected) {
            datas.add((double)index, BaseDSValues.fusionCP.ds);
            index += n;
        }
        if (BaseDSValues.fusionCL.selected) {
            datas.add((double)index, BaseDSValues.fusionCL.ds);
            index += n;
        }
        if (BaseDSValues.fusionDL.selected) {
            datas.add((double)index, BaseDSValues.fusionDL.ds);
            index += n;
        }
        if (BaseDSValues.ppc.selected) {
            datas.add((double)index, BaseDSValues.ppc.ds);
            index += n;
        }
        if (BaseDSValues.ppa.selected) {
            datas.add((double)index, BaseDSValues.ppa.ds);
            index += n;
        }
        if (BaseDSValues.aca.selected) {
            datas.add((double)index, BaseDSValues.aca.ds);
            index += n;
        }
        if (BaseDSValues.fdv.selected) {
            datas.add((double)index, BaseDSValues.fdv.ds);
            index += n;
        }
        if (BaseDSValues.fda.selected) {
            datas.add((double)index, BaseDSValues.fda.ds);
            index += n;
        }
        dataset.addSeries(darkGreenRing);
        dataset.addSeries(greenRing);
        dataset.addSeries(redRing);
        dataset.addSeries(datas);
    }

    private static XYDataset getXYDataset() {
        dataset = new XYSeriesCollection();
        XYSeries series1 = new XYSeries((Comparable)((Object)"Series1"));
        series1.add(0.0, -1.0);
        series1.add(45.0, 1.0);
        series1.add(90.0, -1.3);
        series1.add(135.0, 0.0);
        series1.add(180.0, 0.5);
        series1.add(225.0, 1.3);
        series1.add(270.0, -0.2);
        series1.add(315.0, 0.1);
        XYSeries series2 = new XYSeries((Comparable)((Object)"series2"));
        for (int i = 0; i <= 360; i += 5) {
            series2.add((double)i, -1.5);
        }
        XYSeries series3 = new XYSeries((Comparable)((Object)"series3"));
        series3.add(0.0, 1.0);
        series3.add(45.0, 1.0);
        series3.add(90.0, 1.0);
        series3.add(135.0, 1.0);
        series3.add(180.0, 1.0);
        series3.add(225.0, 1.0);
        series3.add(270.0, 1.0);
        series3.add(315.0, 1.0);
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        dataset.addSeries(series3);
        return dataset;
    }
}

