/*
 * Decompiled with CFR 0.152.
 */
package com.fmaillet.orthocotation;

import com.fmaillet.orthocotation.AboutJDialog;
import com.fmaillet.orthocotation.BarChartTVPS3;
import com.fmaillet.orthocotation.BarChartTVPS4;
import com.fmaillet.orthocotation.BaseDSValues;
import com.fmaillet.orthocotation.ConnectDialog;
import com.fmaillet.orthocotation.Criterium_JDialog;
import com.fmaillet.orthocotation.DateLabelFormatter;
import com.fmaillet.orthocotation.MyPolarChart;
import com.fmaillet.orthocotation.Norms_JDialog;
import com.fmaillet.orthocotation.Panel_DEM;
import com.fmaillet.orthocotation.Panel_MEC;
import com.fmaillet.orthocotation.Panel_MVPT4;
import com.fmaillet.orthocotation.Panel_NEURO;
import com.fmaillet.orthocotation.Panel_Optic;
import com.fmaillet.orthocotation.Panel_TVPS3;
import com.fmaillet.orthocotation.Panel_TVPS4;
import com.fmaillet.orthocotation.Panel_VB;
import com.fmaillet.orthocotation.TVPS4Norms_JDialog;
import com.fmaillet.orthocotation.UserInfo;
import com.fmaillet.orthocotation.VB_JDialog;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;
import org.jfree.chart.ChartUtils;

public class OrthoCotation
extends JFrame
implements ActionListener,
WindowListener {
    public static boolean master = true;
    public static UserInfo user;
    static OrthoCotation fen;
    static JTabbedPane tabbedPane;
    static JPanel basePanel;
    public Image iconApp;
    public static BaseDSValues baseValues;
    static JDatePickerImpl dateBilan;
    static JDatePickerImpl dateBirth;
    static JLabel labelAge;
    static Panel_VB panelVB;
    static Panel_Optic panelOPTIC;
    static Panel_MEC panelMEC;
    static Panel_DEM panelDEM;
    static Panel_TVPS3 panelTVPS3;
    static Panel_TVPS4 panelTVPS4;
    static Panel_MVPT4 panelMVPT4;
    static Panel_NEURO panelNEURO;
    public static MyPolarChart polarChart;
    public static BarChartTVPS3 barChartTVPS3;
    public static BarChartTVPS4 barChartTVPS4;
    public static JPanel radioPanel;
    public static JPanel tvps3ChartPanel;
    public static JPanel tvps4ChartPanel;
    public static JRadioButton h;
    public static JRadioButton f;
    static JMenuBar barreMenus;
    static JMenu helpNormsMenu;
    static JMenuItem exitItem;
    static JMenuItem aboutItem;
    static JMenuItem helpVBItem;
    static JMenuItem helpNormsVBItem;
    static JMenuItem comMenu;
    static JMenuItem helpCriteriumItem;
    static JMenuItem redactionItem;
    static JMenuItem helpRedactionItem;
    static JMenuItem helpTvps4NormsItem;

    public OrthoCotation() {
        this.setTitle("orthoCotation (" + OrthoCotation.getSoftVersion() + ") - MODE DEMO (NON CONNECTE)");
        this.setDefaultCloseOperation(3);
        this.setLayout(null);
        this.setSize(1200, 700);
        ArrayList<Image> icons = new ArrayList<Image>();
        URL iconURL = this.getClass().getResource("iconOrg.png_256x256.png");
        icons.add(new ImageIcon(iconURL).getImage());
        iconURL = this.getClass().getResource("iconOrg.png_64x64.png");
        icons.add(new ImageIcon(iconURL).getImage());
        iconURL = this.getClass().getResource("iconOrg.png_128x128.png");
        icons.add(new ImageIcon(iconURL).getImage());
        iconURL = this.getClass().getResource("iconOrg.png_16x16.png");
        icons.add(new ImageIcon(iconURL).getImage());
        iconURL = this.getClass().getResource("iconOrg.png_48x48.png");
        icons.add(new ImageIcon(iconURL).getImage());
        iconURL = this.getClass().getResource("iconOrg.png_32x32.png");
        icons.add(new ImageIcon(iconURL).getImage());
        this.setIconImages(icons);
        this.getContentPane().setBackground(Color.CYAN);
        this.setLocationRelativeTo(null);
        barreMenus = new JMenuBar();
        this.setJMenuBar(barreMenus);
        barreMenus.setEnabled(false);
        JMenu fileMenu = new JMenu("Fichier");
        barreMenus.add(fileMenu);
        comMenu = new JMenuItem("Connexion au serveur");
        fileMenu.add(comMenu);
        comMenu.addActionListener(this);
        comMenu.setEnabled(false);
        comMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (OrthoCotation.user.nom != null) {
                    OrthoCotation.this.setTitle("orthoCotation (" + OrthoCotation.getSoftVersion() + ") - Connect\u00e9 au serveur : " + OrthoCotation.user.titre + " " + OrthoCotation.user.nom.toUpperCase() + " " + OrthoCotation.user.prenom);
                }
            }
        });
        this.setTitle("orthoCotation (" + OrthoCotation.getSoftVersion() + ") - " + OrthoCotation.user.titre + " " + OrthoCotation.user.nom.toUpperCase() + " " + OrthoCotation.user.prenom);
        JMenu helpMenu = new JMenu("Aide");
        barreMenus.add(helpMenu);
        helpVBItem = new JMenuItem("Vision binoculaire");
        helpVBItem.addActionListener(this);
        helpMenu.add(helpVBItem);
        helpNormsMenu = new JMenu("Normes utilis\u00e9es");
        helpMenu.add(helpNormsMenu);
        helpCriteriumItem = new JMenuItem("Crit\u00e8res VB");
        helpCriteriumItem.addActionListener(this);
        helpNormsMenu.add(helpCriteriumItem);
        helpNormsVBItem = new JMenuItem("Vision binoculaire");
        helpNormsVBItem.addActionListener(this);
        helpNormsMenu.add(helpNormsVBItem);
        helpNormsMenu.addSeparator();
        helpTvps4NormsItem = new JMenuItem("TVPS-4");
        helpTvps4NormsItem.addActionListener(this);
        helpNormsMenu.add(helpTvps4NormsItem);
        helpRedactionItem = new JMenuItem("R\u00e9daction");
        helpRedactionItem.setEnabled(false);
        helpMenu.addSeparator();
        helpMenu.add(helpRedactionItem);
        helpMenu.addSeparator();
        aboutItem = new JMenuItem("A Propos");
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        exitItem = new JMenuItem("Quitter");
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        this.addWindowListener(this);
        this.initDateLabels();
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    private static void addTabbedPanes(int w, int h) {
        tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Vision binoculaire", OrthoCotation.addTabPanel_VB());
        tabbedPane.addTab("Optique", OrthoCotation.addTabPanel_OPTIC());
        tabbedPane.addTab("DEM, NSUCO", OrthoCotation.addTabPanel_DEM());
        tabbedPane.addTab("TVPS-3", OrthoCotation.addTabPanel_TVPS3());
        tabbedPane.addTab("TVPS-4", OrthoCotation.addTabPanel_TVPS4());
        tabbedPane.addTab("MVPT-4", OrthoCotation.addTabPanel_MVPT4());
        tabbedPane.addTab("MEC", OrthoCotation.addTabPanel_MEC());
        if (master) {
            tabbedPane.addTab("Neuro", OrthoCotation.addTabPanel_NEURO());
        }
        tabbedPane.setForegroundAt(6, Color.RED);
    }

    private void initDateLabels() {
        JLabel lab1 = new JLabel("Date du bilan :");
        lab1.setBounds(10, 10, 150, 30);
        this.getContentPane().add(lab1);
        UtilDateModel modelBilan = new UtilDateModel();
        Properties p = new Properties();
        p.put("text.today", "Aujourd'hui");
        p.put("text.month", "Mois");
        p.put("text.year", "Ann\u00e9e");
        JDatePanelImpl datePanel = new JDatePanelImpl(modelBilan, p);
        dateBilan = new JDatePickerImpl(datePanel, new DateLabelFormatter());
        dateBilan.setBounds(100, 10, 130, 27);
        dateBilan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OrthoCotation.calculateAge();
            }
        });
        this.getContentPane().add(dateBilan);
        LocalDate now = LocalDate.now();
        modelBilan.setDate(now.getYear(), now.getMonthValue() - 1, now.getDayOfMonth());
        modelBilan.setSelected(true);
        JLabel lab2 = new JLabel("Date de naissance :");
        lab2.setBounds(250, 10, 150, 30);
        this.getContentPane().add(lab2);
        UtilDateModel modelBirth = new UtilDateModel();
        JDatePanelImpl dateB = new JDatePanelImpl(modelBirth, p);
        dateBirth = new JDatePickerImpl(dateB, new DateLabelFormatter());
        dateBirth.setBounds(375, 10, 130, 27);
        ((JTextField)dateBirth.getComponent(0)).setToolTipText("Format : jj/mm/aaaa");
        ((JButton)dateBirth.getComponent(1)).setToolTipText("Format : jj/mm/aaaa");
        dateBirth.setTextEditable(true);
        dateBirth.getJFormattedTextField().setFocusLostBehavior(1);
        dateBirth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OrthoCotation.calculateAge();
            }
        });
        dateBirth.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OrthoCotation.calculateAge();
            }
        });
        this.getContentPane().add(dateBirth);
        labelAge = new JLabel("[age ?]");
        labelAge.setBounds(535, 10, 200, 30);
        labelAge.setFont(new Font(labelAge.getName(), 0, 18));
        labelAge.setForeground(Color.BLUE);
        this.getContentPane().add(labelAge);
        ButtonGroup grp = new ButtonGroup();
        h = new JRadioButton("Gar\u00e7on");
        h.setSelected(false);
        f = new JRadioButton("Fille");
        f.setSelected(false);
        grp.add(h);
        grp.add(f);
        h.setBounds(750, 13, 90, 27);
        f.setBounds(850, 13, 90, 27);
        h.setOpaque(false);
        f.setOpaque(false);
        h.setFont(new Font(h.getName(), 0, 18));
        f.setFont(new Font(h.getName(), 0, 18));
        this.getContentPane().add(h);
        this.getContentPane().add(f);
        h.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BaseDSValues.homme = h.isSelected();
                panelDEM.updateNSUCO();
            }
        });
        f.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BaseDSValues.homme = h.isSelected();
                panelDEM.updateNSUCO();
            }
        });
    }

    public static boolean isGenreDefined() {
        return h.isSelected() | f.isSelected();
    }

    private static JPanel addTabPanel_VB() {
        basePanel = new JPanel();
        basePanel.setLayout(null);
        panelVB = new Panel_VB();
        panelVB.setSize(600, 460);
        panelVB.setVisible(true);
        radioPanel = polarChart.addPolarPanel();
        radioPanel.setBounds(750, 20, 420, 420);
        radioPanel.setVisible(true);
        panelVB.add(radioPanel);
        JLabel infoClic = new JLabel("(Clic droit sur le sch\u00e9ma pour enregistrer ou copier)");
        infoClic.setFont(new Font(infoClic.getName(), 2, 11));
        infoClic.setBounds(radioPanel.getX(), radioPanel.getY() + radioPanel.getHeight() + 10, 270, 25);
        panelVB.add(infoClic);
        final JSlider jTransparency = new JSlider();
        jTransparency.setMaximum(100);
        jTransparency.setMinimum(0);
        jTransparency.setValue(25);
        jTransparency.setBounds(infoClic.getX() + 120, infoClic.getY() + 40, 200, 17);
        ChangeListener l = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                polarChart.changeTransparency(jTransparency.getValue());
            }
        };
        jTransparency.addChangeListener(l);
        panelVB.add(jTransparency);
        JLabel infoTransparency = new JLabel("Transparence :");
        infoTransparency.setBounds(infoClic.getX(), jTransparency.getY() - 4, 90, 25);
        panelVB.add(infoTransparency);
        return panelVB;
    }

    private static JPanel addTabPanel_DEM() {
        panelDEM = new Panel_DEM();
        panelDEM.setSize(700, 460);
        panelDEM.setVisible(true);
        return panelDEM;
    }

    private static JPanel addTabPanel_NEURO() {
        panelNEURO = new Panel_NEURO();
        panelNEURO.setSize(700, 460);
        panelNEURO.setVisible(true);
        return panelNEURO;
    }

    private static JPanel addTabPanel_OPTIC() {
        panelOPTIC = new Panel_Optic();
        panelOPTIC.setSize(700, 460);
        panelOPTIC.setVisible(true);
        return panelOPTIC;
    }

    private static JPanel addTabPanel_MEC() {
        panelMEC = new Panel_MEC();
        panelMEC.setSize(700, 460);
        panelMEC.setVisible(true);
        return panelMEC;
    }

    private static JPanel addTabPanel_TVPS3() {
        panelTVPS3 = new Panel_TVPS3();
        panelTVPS3.setSize(700, 460);
        panelTVPS3.setVisible(true);
        tvps3ChartPanel = barChartTVPS3.addBarPanel();
        tvps3ChartPanel.setBounds(660, 20, 500, 300);
        tvps3ChartPanel.setVisible(true);
        panelTVPS3.add(tvps3ChartPanel);
        JLabel infoClic = new JLabel("(Clic droit sur le sch\u00e9ma pour enregistrer ou copier)");
        infoClic.setFont(new Font(infoClic.getName(), 2, 11));
        infoClic.setBounds(tvps3ChartPanel.getX(), tvps3ChartPanel.getY() + tvps3ChartPanel.getHeight() + 10, 270, 25);
        panelTVPS3.add(infoClic);
        Panel_TVPS3.jChgeColor.setLocation(infoClic.getX() + 70, infoClic.getY() + infoClic.getHeight() + 60);
        Panel_TVPS3.jCheckTitre.setLocation(infoClic.getX() + 30 + Panel_TVPS3.jChgeColor.getWidth() + 15, infoClic.getY() + infoClic.getHeight() + 15);
        Panel_TVPS3.jCheckRange.setLocation(infoClic.getX() + 30 + Panel_TVPS3.jChgeColor.getWidth() + Panel_TVPS3.jCheckTitre.getWidth() + 15, infoClic.getY() + infoClic.getHeight() + 15);
        return panelTVPS3;
    }

    private static JPanel addTabPanel_TVPS4() {
        panelTVPS4 = new Panel_TVPS4();
        panelTVPS4.setSize(700, 460);
        panelTVPS4.setVisible(true);
        tvps4ChartPanel = barChartTVPS4.addBarPanel();
        tvps4ChartPanel.setBounds(660, 20, 500, 300);
        tvps4ChartPanel.setVisible(true);
        panelTVPS4.add(tvps4ChartPanel);
        JLabel infoClic = new JLabel("(Clic droit sur le sch\u00e9ma pour enregistrer ou copier)");
        infoClic.setFont(new Font(infoClic.getName(), 2, 11));
        infoClic.setBounds(tvps4ChartPanel.getX(), tvps4ChartPanel.getY() + tvps4ChartPanel.getHeight() + 10, 270, 25);
        panelTVPS4.add(infoClic);
        Panel_TVPS4.jChgeColor.setLocation(infoClic.getX() + 70, infoClic.getY() + infoClic.getHeight() + 60);
        Panel_TVPS4.jCheckTitre.setLocation(infoClic.getX() + 30 + Panel_TVPS3.jChgeColor.getWidth() + 15, infoClic.getY() + infoClic.getHeight() + 15);
        Panel_TVPS4.jCheckRange.setLocation(infoClic.getX() + 30 + Panel_TVPS3.jChgeColor.getWidth() + Panel_TVPS3.jCheckTitre.getWidth() + 15, infoClic.getY() + infoClic.getHeight() + 15);
        return panelTVPS4;
    }

    private static JPanel addTabPanel_MVPT4() {
        panelMVPT4 = new Panel_MVPT4();
        panelMVPT4.setSize(700, 460);
        panelMVPT4.setVisible(true);
        return panelMVPT4;
    }

    private static void calculateAge() {
        Date b = (Date)dateBilan.getModel().getValue();
        if (b == null) {
            return;
        }
        LocalDate bilan = b.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Date n = (Date)dateBirth.getModel().getValue();
        if (n == null) {
            return;
        }
        LocalDate birth = n.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Period age = Period.between(birth, bilan);
        labelAge.setText("<html><b>" + age.getYears() + "</b> ans <b>" + age.getMonths() + "</b> mois (" + age.getDays() + " j.)<html>");
        BaseDSValues.patientAge.years = age.getYears();
        BaseDSValues.patientAge.months = age.getMonths();
        BaseDSValues.patientAge.days = age.getDays();
        panelVB.updateFromAge();
        panelDEM.updateResults();
        panelDEM.updateNSUCO();
        panelDEM.updateGROFFMAN();
        panelTVPS3.updateResults();
        panelTVPS4.updateResults();
        panelMVPT4.updateResults();
        if (master) {
            panelNEURO.updateThurstoneFI();
            panelNEURO.updateBentonJLO();
        }
    }

    public static void connected() {
        if (OrthoCotation.user.nom != null) {
            Panel_DEM.jMsgDEM.setText("(Age ? Vous devez indiquer une date de naissance)");
            Panel_DEM.jMsgDEM.setForeground(Color.BLUE);
            Panel_TVPS3.jMsgTVPS.setText("(Age ? Vous devez indiquer une date de naissance)");
            Panel_TVPS3.jMsgTVPS.setForeground(Color.BLUE);
            Panel_TVPS4.jMsgTVPS.setText("(Age ? Vous devez indiquer une date de naissance)");
            Panel_TVPS4.jMsgTVPS.setForeground(Color.BLUE);
            Panel_MVPT4.jMsgMVPT.setText("(Age ? Vous devez indiquer une date de naissance)");
            Panel_MVPT4.jMsgMVPT.setForeground(Color.BLUE);
            Panel_DEM.jMsgNSUCO.setText("(Age ? Vous devez indiquer une date de naissance)");
            Panel_DEM.jMsgNSUCO.setForeground(Color.BLUE);
            Panel_DEM.jMsgGROFFMAN.setText("(Age ? Vous devez indiquer une date de naissance)");
            Panel_DEM.jMsgGROFFMAN.setForeground(Color.BLUE);
            if (master) {
                Panel_NEURO.jMsgThurstone.setText("(Age ? Vous devez indiquer une date de naissance)");
                Panel_NEURO.jMsgThurstone.setForeground(Color.BLUE);
            }
        } else {
            comMenu.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        user = new UserInfo();
        master = true;
        OrthoCotation.user.titre = "M.";
        OrthoCotation.user.nom = "Maillet";
        OrthoCotation.user.prenom = "Fr\u00e9d\u00e9ric";
        OrthoCotation.user.activite = "Orthoptiste Neuropsychologue";
        OrthoCotation.user.adr1 = "209 avenue de castres";
        OrthoCotation.user.adr2 = "RDC BAT G";
        OrthoCotation.user.dateLimite = "2050-12-31";
        fen = new OrthoCotation();
        OrthoCotation.addTabbedPanes(fen.getContentPane().getWidth(), fen.getContentPane().getHeight());
        fen.getContentPane().add(tabbedPane);
        fen.setVisible(true);
        tabbedPane.setBounds(0, 50, fen.getContentPane().getWidth() + 10, fen.getContentPane().getHeight() - 40);
        fen.setResizable(false);
        fen.repaint();
        JLabel infoClic = new JLabel("(Clic droit sur le sch\u00e9ma pour sauver ou copier)");
        infoClic.setFont(new Font(infoClic.getName(), 2, 11));
        infoClic.setBounds(radioPanel.getX(), radioPanel.getY() + radioPanel.getHeight() + 10, 250, 25);
        fen.getContentPane().add(infoClic);
        if (master) {
            OrthoCotation.connected();
        }
    }

    public static String getSoftVersion() {
        return "v1.9.3 du 13/02/2022";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == aboutItem) {
            AboutJDialog about = new AboutJDialog((Frame)this, true);
            about.pack();
            about.getContentPane().setBackground(Color.CYAN);
            about.setLocationRelativeTo(null);
            about.setVisible(true);
        } else if (source == helpVBItem) {
            VB_JDialog about = new VB_JDialog((Frame)this, true);
            about.pack();
            about.setLocationRelativeTo(null);
            about.setVisible(true);
        } else if (source == helpNormsVBItem) {
            Norms_JDialog about = new Norms_JDialog((Frame)this, true);
            about.pack();
            about.setLocationRelativeTo(null);
            about.setVisible(true);
        } else if (source == helpCriteriumItem) {
            Criterium_JDialog about = new Criterium_JDialog((Frame)this, true);
            about.pack();
            about.setLocationRelativeTo(null);
            about.setVisible(true);
        } else if (source == helpTvps4NormsItem) {
            TVPS4Norms_JDialog about = new TVPS4Norms_JDialog((Frame)this, true);
            about.pack();
            about.setSize(500, 700);
            about.setLocationRelativeTo(null);
            about.setVisible(true);
        } else if (source == comMenu) {
            ConnectDialog connect = new ConnectDialog((Frame)this, true);
            connect.setLocationRelativeTo(null);
            connect.setVisible(true);
        } else if (source == helpRedactionItem) {
            JOptionPane.showMessageDialog(this, "Exp\u00e9rimental !!\nCompilateur de compte-rendu...\n\n Vous devez installer MikTex: https://miktex.org/", "Aide \u00e0 la r\u00e9daction", 2);
        } else if (source == redactionItem) {
            try {
                FileOutputStream out = new FileOutputStream("polarChart.png");
                ChartUtils.writeChartAsPNG(out, MyPolarChart.chart, radioPanel.getWidth(), radioPanel.getHeight(), null, true, 0);
                out = new FileOutputStream("tvps3.png");
                ChartUtils.writeChartAsPNG(out, BarChartTVPS3.chart, tvps3ChartPanel.getWidth(), tvps3ChartPanel.getHeight(), null, true, 0);
                out = new FileOutputStream("tvps4.png");
                ChartUtils.writeChartAsPNG(out, BarChartTVPS4.chart, tvps4ChartPanel.getWidth(), tvps4ChartPanel.getHeight(), null, true, 0);
            }
            catch (IOException ex) {
                System.out.println("Erreur polar Chart cration !");
            }
        } else if (source == exitItem) {
            System.exit(0);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        System.out.println("window opened...");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("window is closing...");
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static {
        baseValues = new BaseDSValues();
        polarChart = new MyPolarChart();
        barChartTVPS3 = new BarChartTVPS3();
        barChartTVPS4 = new BarChartTVPS4();
    }
}

