/*
 * Decompiled with CFR 0.152.
 */
package com.fmaillet.orthocotation;

import com.fmaillet.orthocotation.BaseDSValues;
import com.fmaillet.orthocotation.OrthoCotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Panel_DEM
extends JPanel {
    double[] error_M = new double[]{14.9, 7.9, 4.0, 2.6, 2.0, 1.7, 1.1, 1.2, 0.6};
    double[] error_DS = new double[]{8.3, 7.6, 4.6, 3.8, 2.6, 2.0, 1.8, 1.9, 0.9};
    double[] ratio_M = new double[]{1.53, 1.43, 1.31, 1.24, 1.18, 1.13, 1.12, 1.12, 1.12};
    double[] ratio_DS = new double[]{0.29, 0.25, 0.2, 0.18, 0.12, 0.12, 0.09, 0.12, 0.07};
    double[] AHT_M = new double[]{108.12, 75.01, 59.91, 52.04, 44.72, 39.49, 35.34, 33.16, 32.33};
    double[] AHT_DS = new double[]{30.49, 19.33, 14.87, 12.78, 8.08, 8.44, 6.47, 6.57, 5.29};
    double[] VT_M = new double[]{72.29, 52.74, 45.77, 41.98, 38.13, 35.06, 31.55, 29.71, 29.01};
    double[] VT_DS = new double[]{20.99, 10.17, 9.68, 7.89, 6.35, 6.41, 5.74, 4.58, 4.91};
    int[][] nsucoS_P = new int[][]{{3, 3, 3, 3, 3, 3, 3, 3, 3, 4}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
    int[][] nsucoS_H = new int[][]{{2, 2, 3, 3, 3, 3, 3, 3, 3, 3}, {2, 3, 3, 3, 3, 4, 4, 4, 4, 4}};
    int[][] nsucoS_B = new int[][]{{3, 3, 3, 4, 4, 4, 4, 4, 5, 5}, {4, 4, 4, 4, 4, 4, 5, 5, 5, 5}};
    int[][] nsucoP_A = new int[][]{{4, 4, 5, 5, 5, 5, 5, 5, 5, 5}, {5, 5, 5, 5, 5, 5, 5, 5, 5, 5}};
    int[][] nsucoP_P = new int[][]{{2, 2, 3, 3, 3, 4, 4, 4, 5, 5}, {3, 3, 3, 3, 4, 4, 4, 4, 4, 4}};
    int[][] nsucoP_H = new int[][]{{2, 2, 3, 3, 3, 4, 4, 4, 5, 5}, {3, 3, 3, 3, 3, 4, 4, 4, 4, 4}};
    int[][] nsucoP_B = new int[][]{{3, 3, 3, 4, 4, 4, 4, 5, 5, 5}, {4, 4, 4, 4, 4, 5, 5, 5, 5, 5}};
    private JSpinner jError_A;
    private JSpinner jError_O;
    private JSpinner jError_S;
    private JSpinner jError_T;
    private JTextField jErrors;
    private JLabel jErrors_ds;
    private JSpinner jGROFFMAN_A_A;
    private JSpinner jGROFFMAN_A_B;
    private JSpinner jGROFFMAN_A_C;
    private JSpinner jGROFFMAN_A_D;
    private JSpinner jGROFFMAN_A_E;
    private JSpinner jGROFFMAN_B_A;
    private JSpinner jGROFFMAN_B_B;
    private JSpinner jGROFFMAN_B_C;
    private JSpinner jGROFFMAN_B_D;
    private JSpinner jGROFFMAN_B_E;
    private JLabel jGROFMAN_DS_A;
    private JLabel jGROFMAN_DS_B;
    private JTextField jGROFMAN_scoreA;
    private JTextField jGROFMAN_scoreB;
    private JTextField jH_Time;
    private JLabel jH_Time_ds;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    public static JLabel jMsgDEM;
    public static JLabel jMsgGROFFMAN;
    private JLabel jMsgGenre;
    public static JLabel jMsgNSUCO;
    private JSpinner jNSUCO_P_A;
    private JSpinner jNSUCO_P_B;
    private JSpinner jNSUCO_P_H;
    private JSpinner jNSUCO_P_P;
    private JSpinner jNSUCO_S_A;
    private JSpinner jNSUCO_S_B;
    private JSpinner jNSUCO_S_H;
    private JSpinner jNSUCO_S_P;
    private JTextField jRatio;
    private JLabel jRatio_ds;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSpinner jTest_A;
    private JSpinner jTest_B;
    private JSpinner jTest_C;
    private JLabel jUnit1;
    private JLabel jUnit10;
    private JLabel jUnit11;
    private JLabel jUnit12;
    private JLabel jUnit13;
    private JLabel jUnit14;
    private JLabel jUnit2;
    private JLabel jUnit3;
    private JLabel jUnit4;
    private JLabel jUnit5;
    private JLabel jUnit6;
    private JLabel jUnit7;
    private JLabel jUnit8;
    private JLabel jUnit9;
    private JTextField jV_Time;
    private JLabel jV_Time_ds;

    public Panel_DEM() {
        this.initComponents();
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JLabel source = (JLabel)evt.getSource();
                double t = Double.parseDouble(source.getText().replace(",", "."));
                if (t > -1.0) {
                    source.setForeground(Color.GREEN);
                } else {
                    source.setForeground(Color.RED);
                }
            }
        };
        this.jH_Time_ds.addPropertyChangeListener("text", l);
        this.jV_Time_ds.addPropertyChangeListener("text", l);
        this.jRatio_ds.addPropertyChangeListener("text", l);
        this.jErrors_ds.addPropertyChangeListener("text", l);
        this.jGROFMAN_DS_A.addPropertyChangeListener("text", l);
        this.jGROFMAN_DS_B.addPropertyChangeListener("text", l);
        this.updateResults();
        this.updateNSUCO();
        this.updateGROFFMAN();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawRect(this.jLabel2.getX() - 10, this.jLabel2.getY() - 10, 250, 60);
        g.drawRect(this.jLabel4.getX() - 10, this.jLabel4.getY() - 10, 250, 110);
        g.drawRect(this.jLabel10.getX() - 10, this.jLabel10.getY() - 10, 250, 150);
        g.setColor(Color.GRAY);
        g.drawLine(this.jV_Time.getX() - 10, this.jV_Time.getY() + 30, this.jV_Time.getX() + 120, this.jV_Time.getY() + 30);
    }

    public void updateResults() {
        double testA = (Double)this.jTest_A.getValue();
        double testB = (Double)this.jTest_B.getValue();
        double time_V = testA + testB;
        this.jV_Time.setText(String.format("%.2f", time_V));
        int err_o = (Integer)this.jError_O.getValue();
        int err_a = (Integer)this.jError_A.getValue();
        int err = (Integer)this.jError_S.getValue() + err_o + err_a + (Integer)this.jError_T.getValue();
        this.jErrors.setText(String.valueOf(err));
        double testC = (Double)this.jTest_C.getValue();
        double time_H = testC * 80.0 / (double)(80 - err_o + err_a);
        this.jH_Time.setText(String.format("%.2f", time_H));
        double ratio = time_H / time_V;
        this.jRatio.setText(String.format("%.2f", ratio));
        if (OrthoCotation.user.nom == null) {
            return;
        }
        jMsgDEM.setText(null);
        int y = BaseDSValues.patientAge.years - 6;
        if (y < 0) {
            y = 0;
            jMsgDEM.setText("(Normes 6 ans par d\u00e9faut)");
        } else if (y > 8) {
            y = 8;
            jMsgDEM.setText("(Normes 14 ans par d\u00e9faut)");
        }
        double t = (this.error_M[y] - (double)err) / this.error_DS[y];
        this.jErrors_ds.setText(String.format("%+.2f", t));
        t = (this.VT_M[y] - time_V) / this.VT_DS[y];
        this.jV_Time_ds.setText(String.format("%+.2f", t));
        t = (this.AHT_M[y] - time_H) / this.AHT_DS[y];
        this.jH_Time_ds.setText(String.format("%+.2f", t));
        t = (this.ratio_M[y] - ratio) / this.ratio_DS[y];
        this.jRatio_ds.setText(String.format("%+.2f", t));
    }

    public void updateGROFFMAN() {
        if (OrthoCotation.user.nom == null) {
            return;
        }
        if (BaseDSValues.patientAge.years == 0) {
            jMsgGROFFMAN.setText("(Age ? Vous devez indiquer une date de naissance)");
            return;
        }
        jMsgGROFFMAN.setText(null);
        if (BaseDSValues.patientAge.years < 7) {
            jMsgGROFFMAN.setText("(Normes 7 ans par d\u00e9faut)");
        } else if (BaseDSValues.patientAge.years > 12) {
            jMsgGROFFMAN.setText("(Normes 12 ans par d\u00e9faut)");
        }
        int[] a = new int[5];
        int[] b = new int[5];
        a[0] = (Integer)this.jGROFFMAN_A_A.getValue();
        a[1] = (Integer)this.jGROFFMAN_A_B.getValue();
        a[2] = (Integer)this.jGROFFMAN_A_C.getValue();
        a[3] = (Integer)this.jGROFFMAN_A_D.getValue();
        a[4] = (Integer)this.jGROFFMAN_A_E.getValue();
        b[0] = (Integer)this.jGROFFMAN_B_A.getValue();
        b[1] = (Integer)this.jGROFFMAN_B_B.getValue();
        b[2] = (Integer)this.jGROFFMAN_B_C.getValue();
        b[3] = (Integer)this.jGROFFMAN_B_D.getValue();
        b[4] = (Integer)this.jGROFFMAN_B_E.getValue();
        int scoreA = 0;
        int scoreB = 0;
        for (int i = 0; i < 5; ++i) {
            scoreA += this.groffmanPoints(a[i]);
            scoreB += this.groffmanPoints(b[i]);
        }
        this.jGROFMAN_scoreA.setText(String.valueOf(scoreA));
        this.jGROFMAN_scoreB.setText(String.valueOf(scoreB));
        this.jGROFMAN_DS_A.setText(String.format("%+.2f", this.groffmanDS(scoreA)));
        this.jGROFMAN_DS_B.setText(String.format("%+.2f", this.groffmanDS(scoreB)));
    }

    public int groffmanPoints(int t) {
        if (t == 0) {
            return 0;
        }
        if (t < 16) {
            return 10;
        }
        if (t > 50 & t <= 60) {
            return 2;
        }
        if (t > 60) {
            return 1;
        }
        return 9 - (t - 16) / 5;
    }

    private double groffmanDS(int score) {
        if (BaseDSValues.patientAge.years <= 7) {
            return ((double)score - 10.0) / 3.5;
        }
        if (BaseDSValues.patientAge.years == 8) {
            return ((double)score - 17.0) / 3.0;
        }
        if (BaseDSValues.patientAge.years == 9) {
            return ((double)score - 22.0) / 2.0;
        }
        if (BaseDSValues.patientAge.years == 10) {
            return ((double)score - 26.0) / 2.5;
        }
        if (BaseDSValues.patientAge.years == 11) {
            return ((double)score - 28.0) / 3.0;
        }
        return ((double)score - 32.0) / 4.0;
    }

    public void updateNSUCO() {
        if (!OrthoCotation.isGenreDefined()) {
            this.jMsgGenre.setVisible(true);
        } else {
            this.jMsgGenre.setVisible(false);
        }
        if (OrthoCotation.user.nom == null) {
            return;
        }
        if (BaseDSValues.patientAge.years == 0) {
            jMsgNSUCO.setText("(Age ? Vous devez indiquer une date de naissance)");
            return;
        }
        jMsgNSUCO.setText("");
        int y = BaseDSValues.patientAge.years - 5;
        if (y < 0) {
            y = 0;
            jMsgNSUCO.setText("(Normes 5 ans par d\u00e9faut)");
            jMsgNSUCO.setForeground(Color.BLUE);
        }
        if (y > 9) {
            y = 9;
            jMsgNSUCO.setText("(Normes 14 ans par d\u00e9faut)");
            jMsgNSUCO.setForeground(Color.BLUE);
        }
        if ((Integer)this.jNSUCO_S_A.getValue() < 5) {
            this.jNSUCO_S_A.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_S_A.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_P_A.getValue() < this.nsucoP_A[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_P_A.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_P_A.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_S_P.getValue() < this.nsucoS_P[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_S_P.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_S_P.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_P_P.getValue() < this.nsucoP_P[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_P_P.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_P_P.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_S_H.getValue() < this.nsucoS_H[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_S_H.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_S_H.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_P_H.getValue() < this.nsucoP_H[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_P_H.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_P_H.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_S_B.getValue() < this.nsucoS_B[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_S_B.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_S_B.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
        if ((Integer)this.jNSUCO_P_B.getValue() < this.nsucoP_B[BaseDSValues.homme ? 0 : 1][y]) {
            this.jNSUCO_P_B.setBorder(new MatteBorder(2, 4, 2, 0, Color.RED));
        } else {
            this.jNSUCO_P_B.setBorder(new MatteBorder(2, 4, 2, 0, Color.GREEN));
        }
    }

    private void initComponents() {
        this.jTest_A = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jUnit1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTest_B = new JSpinner();
        this.jUnit2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTest_C = new JSpinner();
        this.jUnit3 = new JLabel();
        this.jError_S = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jError_O = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jError_A = new JSpinner();
        this.jLabel9 = new JLabel();
        this.jError_T = new JSpinner();
        this.jLabel10 = new JLabel();
        this.jH_Time = new JTextField();
        this.jUnit4 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jRatio = new JTextField();
        this.jLabel12 = new JLabel();
        this.jV_Time = new JTextField();
        this.jUnit6 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jErrors = new JTextField();
        this.jLabel14 = new JLabel();
        this.jH_Time_ds = new JLabel();
        this.jV_Time_ds = new JLabel();
        this.jRatio_ds = new JLabel();
        this.jErrors_ds = new JLabel();
        this.jLabel15 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel16 = new JLabel();
        this.jSeparator2 = new JSeparator();
        jMsgDEM = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jNSUCO_S_A = new JSpinner();
        this.jNSUCO_S_P = new JSpinner();
        this.jNSUCO_S_H = new JSpinner();
        this.jNSUCO_S_B = new JSpinner();
        jMsgNSUCO = new JLabel();
        this.jNSUCO_P_A = new JSpinner();
        this.jNSUCO_P_P = new JSpinner();
        this.jNSUCO_P_H = new JSpinner();
        this.jNSUCO_P_B = new JSpinner();
        this.jUnit5 = new JLabel();
        this.jUnit7 = new JLabel();
        this.jUnit8 = new JLabel();
        this.jUnit9 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jSeparator3 = new JSeparator();
        jMsgGROFFMAN = new JLabel();
        this.jMsgGenre = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jUnit10 = new JLabel();
        this.jGROFFMAN_A_A = new JSpinner();
        this.jGROFFMAN_B_A = new JSpinner();
        this.jUnit11 = new JLabel();
        this.jGROFFMAN_A_B = new JSpinner();
        this.jGROFFMAN_B_B = new JSpinner();
        this.jUnit12 = new JLabel();
        this.jGROFFMAN_A_C = new JSpinner();
        this.jGROFFMAN_B_C = new JSpinner();
        this.jUnit13 = new JLabel();
        this.jGROFFMAN_A_D = new JSpinner();
        this.jGROFFMAN_B_D = new JSpinner();
        this.jUnit14 = new JLabel();
        this.jGROFFMAN_A_E = new JSpinner();
        this.jGROFFMAN_B_E = new JSpinner();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jGROFMAN_scoreA = new JTextField();
        this.jGROFMAN_scoreB = new JTextField();
        this.jGROFMAN_DS_A = new JLabel();
        this.jGROFMAN_DS_B = new JLabel();
        this.setPreferredSize(new Dimension(700, 550));
        this.jTest_A.setModel(new SpinnerNumberModel((Number)15.0, Double.valueOf(1.0), null, (Number)0.1));
        this.jTest_A.setFocusCycleRoot(true);
        this.jTest_A.setNextFocusableComponent(this.jTest_B);
        this.jTest_A.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jTest_AStateChanged(evt);
            }
        });
        this.jLabel2.setText("Test A :");
        this.jUnit1.setFont(new Font("Tahoma", 0, 10));
        this.jUnit1.setText("sec.");
        this.jLabel3.setText("Test B :");
        this.jTest_B.setModel(new SpinnerNumberModel((Number)15.0, Double.valueOf(1.0), null, (Number)0.1));
        this.jTest_B.setFocusCycleRoot(true);
        this.jTest_B.setNextFocusableComponent(this.jTest_C);
        this.jTest_B.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jTest_BStateChanged(evt);
            }
        });
        this.jUnit2.setFont(new Font("Tahoma", 0, 10));
        this.jUnit2.setText("sec.");
        this.jLabel4.setText("Test C :");
        this.jTest_C.setModel(new SpinnerNumberModel((Number)20.0, Double.valueOf(1.0), null, (Number)0.1));
        this.jTest_C.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jTest_CStateChanged(evt);
            }
        });
        this.jUnit3.setFont(new Font("Tahoma", 0, 10));
        this.jUnit3.setText("sec.");
        this.jError_S.setModel(new SpinnerNumberModel());
        this.jError_S.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jError_SStateChanged(evt);
            }
        });
        this.jLabel5.setText("Vertical");
        this.jLabel6.setText("Horizontal");
        this.jLabel1.setText("s :");
        this.jLabel7.setText("o :");
        this.jError_O.setModel(new SpinnerNumberModel());
        this.jError_O.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jError_OStateChanged(evt);
            }
        });
        this.jLabel8.setText("a :");
        this.jError_A.setModel(new SpinnerNumberModel());
        this.jError_A.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jError_AStateChanged(evt);
            }
        });
        this.jLabel9.setText("t :");
        this.jError_T.setModel(new SpinnerNumberModel());
        this.jError_T.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jError_TStateChanged(evt);
            }
        });
        this.jLabel10.setText("H Time (adj.):");
        this.jH_Time.setEditable(false);
        this.jH_Time.setHorizontalAlignment(4);
        this.jH_Time.setPreferredSize(new Dimension(45, 20));
        this.jUnit4.setFont(new Font("Tahoma", 0, 10));
        this.jUnit4.setText("sec.");
        this.jLabel11.setText("Ratio :");
        this.jRatio.setEditable(false);
        this.jRatio.setHorizontalAlignment(4);
        this.jRatio.setPreferredSize(new Dimension(45, 20));
        this.jLabel12.setText("V Time :");
        this.jV_Time.setEditable(false);
        this.jV_Time.setHorizontalAlignment(4);
        this.jV_Time.setPreferredSize(new Dimension(45, 20));
        this.jUnit6.setFont(new Font("Tahoma", 0, 10));
        this.jUnit6.setText("sec.");
        this.jLabel13.setText("Errors :");
        this.jErrors.setEditable(false);
        this.jErrors.setHorizontalAlignment(4);
        this.jErrors.setPreferredSize(new Dimension(45, 20));
        this.jLabel14.setText("Resultats [2012, Italian norms]");
        this.jH_Time_ds.setFont(new Font("Tahoma", 1, 12));
        this.jH_Time_ds.setForeground(Color.red);
        this.jH_Time_ds.setText("...");
        this.jV_Time_ds.setFont(new Font("Tahoma", 1, 12));
        this.jV_Time_ds.setForeground(Color.red);
        this.jV_Time_ds.setText("...");
        this.jRatio_ds.setFont(new Font("Tahoma", 1, 12));
        this.jRatio_ds.setForeground(Color.red);
        this.jRatio_ds.setText("...");
        this.jErrors_ds.setFont(new Font("Tahoma", 1, 12));
        this.jErrors_ds.setForeground(Color.red);
        this.jErrors_ds.setText("...");
        this.jLabel15.setFont(new Font("Tahoma", 1, 14));
        this.jLabel15.setForeground(Color.gray);
        this.jLabel15.setText("DEM");
        this.jLabel16.setFont(new Font("Tahoma", 1, 14));
        this.jLabel16.setForeground(Color.gray);
        this.jLabel16.setText("NSUCO");
        jMsgDEM.setFont(new Font("Tahoma", 2, 11));
        jMsgDEM.setForeground(Color.red);
        jMsgDEM.setText("(Les \u00e9carts \u00e0 la norme ne sont pas calcul\u00e9s en mode d\u00e9mo)");
        this.jLabel17.setText("Saccades :");
        this.jLabel18.setText("Poursuite :");
        this.jNSUCO_S_A.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_S_A.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_S_AStateChanged(evt);
            }
        });
        this.jNSUCO_S_P.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_S_P.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_S_PStateChanged(evt);
            }
        });
        this.jNSUCO_S_H.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_S_H.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_S_HStateChanged(evt);
            }
        });
        this.jNSUCO_S_B.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_S_B.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_S_BStateChanged(evt);
            }
        });
        jMsgNSUCO.setFont(new Font("Tahoma", 2, 11));
        jMsgNSUCO.setForeground(Color.red);
        jMsgNSUCO.setText("(Ecarts \u00e0 la norme non calcul\u00e9s en mode d\u00e9mo)");
        this.jNSUCO_P_A.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_P_A.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_P_AStateChanged(evt);
            }
        });
        this.jNSUCO_P_P.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_P_P.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_P_PStateChanged(evt);
            }
        });
        this.jNSUCO_P_H.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_P_H.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_P_HStateChanged(evt);
            }
        });
        this.jNSUCO_P_B.setModel(new SpinnerNumberModel(5, 0, 5, 1));
        this.jNSUCO_P_B.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jNSUCO_P_BStateChanged(evt);
            }
        });
        this.jUnit5.setFont(new Font("Tahoma", 0, 10));
        this.jUnit5.setText("Apt.");
        this.jUnit7.setFont(new Font("Tahoma", 0, 10));
        this.jUnit7.setText("Pr\u00e9c.");
        this.jUnit8.setFont(new Font("Tahoma", 0, 10));
        this.jUnit8.setText("T\u00eate");
        this.jUnit9.setFont(new Font("Tahoma", 0, 10));
        this.jUnit9.setText("Corps");
        this.jLabel19.setFont(new Font("Tahoma", 1, 14));
        this.jLabel19.setForeground(Color.gray);
        this.jLabel19.setText("GROFFMAN Visual Tracing Test");
        jMsgGROFFMAN.setFont(new Font("Tahoma", 2, 11));
        jMsgGROFFMAN.setForeground(Color.red);
        jMsgGROFFMAN.setText("(Ecarts \u00e0 la norme non calcul\u00e9s en mode d\u00e9mo)");
        this.jMsgGenre.setFont(new Font("Tahoma", 1, 14));
        this.jMsgGenre.setForeground(Color.red);
        this.jMsgGenre.setText("!! Genre non d\u00e9fini !");
        this.jLabel20.setText("Forme A :");
        this.jLabel21.setText("Forme B :");
        this.jUnit10.setFont(new Font("Tahoma", 0, 10));
        this.jUnit10.setText("A(3)");
        this.jGROFFMAN_A_A.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_A_A.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_A_AStateChanged(evt);
            }
        });
        this.jGROFFMAN_B_A.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_B_A.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_B_AStateChanged(evt);
            }
        });
        this.jUnit11.setFont(new Font("Tahoma", 0, 10));
        this.jUnit11.setText("B(4)");
        this.jGROFFMAN_A_B.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_A_B.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_A_BStateChanged(evt);
            }
        });
        this.jGROFFMAN_B_B.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_B_B.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_B_BStateChanged(evt);
            }
        });
        this.jUnit12.setFont(new Font("Tahoma", 0, 10));
        this.jUnit12.setText("C(1)");
        this.jGROFFMAN_A_C.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_A_C.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_A_CStateChanged(evt);
            }
        });
        this.jGROFFMAN_B_C.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_B_C.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_B_CStateChanged(evt);
            }
        });
        this.jUnit13.setFont(new Font("Tahoma", 0, 10));
        this.jUnit13.setText("D(5)");
        this.jGROFFMAN_A_D.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_A_D.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_A_DStateChanged(evt);
            }
        });
        this.jGROFFMAN_B_D.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_B_D.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_B_DStateChanged(evt);
            }
        });
        this.jUnit14.setFont(new Font("Tahoma", 0, 10));
        this.jUnit14.setText("E(2)");
        this.jGROFFMAN_A_E.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_A_E.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_A_EStateChanged(evt);
            }
        });
        this.jGROFFMAN_B_E.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(0), null, (Number)1));
        this.jGROFFMAN_B_E.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Panel_DEM.this.jGROFFMAN_B_EStateChanged(evt);
            }
        });
        this.jLabel22.setText("score :");
        this.jLabel23.setText("score :");
        this.jGROFMAN_scoreA.setEditable(false);
        this.jGROFMAN_scoreA.setHorizontalAlignment(4);
        this.jGROFMAN_scoreA.setPreferredSize(new Dimension(45, 20));
        this.jGROFMAN_scoreB.setEditable(false);
        this.jGROFMAN_scoreB.setHorizontalAlignment(4);
        this.jGROFMAN_scoreB.setPreferredSize(new Dimension(45, 20));
        this.jGROFMAN_DS_A.setFont(new Font("Tahoma", 1, 12));
        this.jGROFMAN_DS_A.setForeground(Color.red);
        this.jGROFMAN_DS_A.setText("...");
        this.jGROFMAN_DS_B.setFont(new Font("Tahoma", 1, 12));
        this.jGROFMAN_DS_B.setForeground(Color.red);
        this.jGROFMAN_DS_B.setText("...");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator3, -2, 552, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jUnit10, -2, 22, -2).addGap(8, 8, 8)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel21).addGap(18, 18, 18).addComponent(this.jGROFFMAN_B_A, -2, 46, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel20).addGap(18, 18, 18).addComponent(this.jGROFFMAN_A_A, -2, 46, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jUnit11, -2, 22, -2).addGap(8, 8, 8)).addComponent(this.jGROFFMAN_B_B, -2, 46, -2).addComponent(this.jGROFFMAN_A_B, GroupLayout.Alignment.LEADING, -2, 46, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jUnit12, -2, 22, -2).addGap(8, 8, 8)).addComponent(this.jGROFFMAN_B_C, -2, 46, -2).addComponent(this.jGROFFMAN_A_C, GroupLayout.Alignment.LEADING, -2, 46, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jUnit13, -2, 22, -2).addGap(8, 8, 8)).addComponent(this.jGROFFMAN_B_D, -2, 46, -2).addComponent(this.jGROFFMAN_A_D, GroupLayout.Alignment.LEADING, -2, 46, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jUnit14, -2, 22, -2).addGap(8, 8, 8)).addComponent(this.jGROFFMAN_B_E, -2, 46, -2).addComponent(this.jGROFFMAN_A_E, GroupLayout.Alignment.LEADING, -2, 46, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel23).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGROFMAN_scoreB, -2, 45, -2).addGap(18, 18, 18).addComponent(this.jGROFMAN_DS_B, -2, 57, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGROFMAN_scoreA, -2, 45, -2).addGap(18, 18, 18).addComponent(this.jGROFMAN_DS_A, -2, 57, -2)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSeparator2).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel15).addGap(29, 29, 29).addComponent(jMsgDEM)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jTest_B, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jUnit2, -2, 22, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jTest_A, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jUnit1, -2, 22, -2)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jTest_C, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jUnit3, -2, 22, -2)))).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jError_S, -2, 38, -2).addGap(18, 18, 18).addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jError_A, -2, 38, -2).addGap(18, 18, 18).addComponent(this.jLabel9))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jError_T, GroupLayout.Alignment.TRAILING, -2, 38, -2).addComponent(this.jError_O, GroupLayout.Alignment.TRAILING, -2, 38, -2)))).addGap(85, 85, 85).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addGap(18, 18, 18).addComponent(this.jH_Time, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jUnit4, -2, 22, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRatio, -2, 45, -2).addGroup(layout.createSequentialGroup().addComponent(this.jV_Time, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jUnit6, -2, 22, -2)).addComponent(this.jErrors, -2, 45, -2))))).addComponent(this.jLabel14, GroupLayout.Alignment.TRAILING, -2, 174, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jH_Time_ds, -2, 57, -2).addComponent(this.jV_Time_ds, -2, 57, -2).addComponent(this.jRatio_ds, -2, 57, -2).addComponent(this.jErrors_ds, -2, 57, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel16).addGap(18, 18, 18).addComponent(jMsgNSUCO)))).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel18).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNSUCO_S_A, -2, 38, -2).addComponent(this.jUnit5, -2, 22, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jUnit7).addComponent(this.jNSUCO_S_P, -2, 38, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNSUCO_S_H, -2, 38, -2).addComponent(this.jUnit8)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jUnit9).addGroup(layout.createSequentialGroup().addComponent(this.jNSUCO_S_B, -2, 38, -2).addGap(36, 36, 36).addComponent(this.jMsgGenre)))).addGroup(layout.createSequentialGroup().addComponent(this.jNSUCO_P_A, -2, 38, -2).addGap(18, 18, 18).addComponent(this.jNSUCO_P_P, -2, 38, -2).addGap(18, 18, 18).addComponent(this.jNSUCO_P_H, -2, 38, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jMsgGROFFMAN).addComponent(this.jNSUCO_P_B, -2, 38, -2))))).addComponent(this.jLabel19)).addContainerGap(138, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(jMsgDEM)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jH_Time, -2, -1, -2).addComponent(this.jUnit4).addComponent(this.jH_Time_ds)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jV_Time, -2, -1, -2).addComponent(this.jUnit6).addComponent(this.jV_Time_ds)).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jRatio, -2, -1, -2).addComponent(this.jRatio_ds)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jErrors, -2, -1, -2).addComponent(this.jErrors_ds))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTest_A, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jUnit1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTest_B, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jUnit2)).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTest_C, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jUnit3)).addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jError_S, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jError_O, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jError_A, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jError_T, -2, -1, -2).addComponent(this.jLabel9)))).addGap(42, 42, 42).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(jMsgNSUCO)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUnit5).addComponent(this.jUnit7).addComponent(this.jUnit8).addComponent(this.jUnit9)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jMsgGenre)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jNSUCO_S_A, -2, -1, -2).addComponent(this.jNSUCO_S_P, -2, -1, -2).addComponent(this.jNSUCO_S_H, -2, -1, -2).addComponent(this.jNSUCO_S_B, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.jNSUCO_P_A, -2, -1, -2).addComponent(this.jNSUCO_P_P, -2, -1, -2).addComponent(this.jNSUCO_P_H, -2, -1, -2).addComponent(this.jNSUCO_P_B, -2, -1, -2)).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(jMsgGROFFMAN)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jUnit10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.jGROFFMAN_A_A, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.jGROFFMAN_B_A, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jUnit13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGROFFMAN_A_D, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jGROFFMAN_B_D, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jUnit11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGROFFMAN_A_B, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jGROFFMAN_B_B, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jUnit12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGROFFMAN_A_C, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jGROFFMAN_B_C, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jUnit14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jGROFFMAN_A_E, -2, -1, -2).addComponent(this.jLabel22).addComponent(this.jGROFMAN_scoreA, -2, -1, -2).addComponent(this.jGROFMAN_DS_A)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jGROFFMAN_B_E, -2, -1, -2).addComponent(this.jLabel23).addComponent(this.jGROFMAN_scoreB, -2, -1, -2).addComponent(this.jGROFMAN_DS_B)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jTest_AStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jTest_BStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jError_SStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jError_OStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jError_AStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jError_TStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jTest_CStateChanged(ChangeEvent evt) {
        this.updateResults();
    }

    private void jNSUCO_S_AStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_S_PStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_S_HStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_S_BStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_P_AStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_P_PStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_P_HStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jNSUCO_P_BStateChanged(ChangeEvent evt) {
        this.updateNSUCO();
    }

    private void jGROFFMAN_A_AStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_B_AStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_A_BStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_B_BStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_A_CStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_B_CStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_A_DStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_B_DStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_A_EStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }

    private void jGROFFMAN_B_EStateChanged(ChangeEvent evt) {
        this.updateGROFFMAN();
    }
}

