/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla;

import com.mysql.cj.api.Query;
import com.mysql.cj.api.TransactionEventHandler;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.OperationCancelledException;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.mysqla.MysqlaSession;
import com.mysql.cj.mysqla.io.CommandBuilder;
import java.util.TimerTask;

public class CancelQueryTask
extends TimerTask {
    Query queryToCancel;
    Throwable caughtWhileCancelling = null;
    boolean queryTimeoutKillsConnection = false;

    public CancelQueryTask(Query cancellee) {
        this.queryToCancel = cancellee;
        MysqlaSession session = (MysqlaSession)cancellee.getSession();
        this.queryTimeoutKillsConnection = session.getPropertySet().getBooleanReadableProperty("queryTimeoutKillsConnection").getValue();
    }

    @Override
    public boolean cancel() {
        boolean res = super.cancel();
        this.queryToCancel = null;
        return res;
    }

    @Override
    public void run() {
        Thread cancelThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    Query localQueryToCancel = CancelQueryTask.this.queryToCancel;
                    if (localQueryToCancel == null) {
                        return;
                    }
                    MysqlaSession session = (MysqlaSession)localQueryToCancel.getSession();
                    if (session == null) {
                        return;
                    }
                    try {
                        if (CancelQueryTask.this.queryTimeoutKillsConnection) {
                            localQueryToCancel.setCancelStatus(Query.CancelStatus.CANCELED_BY_TIMEOUT);
                            session.invokeCleanupListeners(new OperationCancelledException(Messages.getString("Statement.ConnectionKilledDueToTimeout")));
                            break block11;
                        }
                        Object object = localQueryToCancel.getCancelTimeoutMutex();
                        synchronized (object) {
                            long origConnId = session.getThreadId();
                            HostInfo hostInfo = session.getHostInfo();
                            String database = hostInfo.getDatabase();
                            String user = StringUtils.isNullOrEmpty(hostInfo.getUser()) ? "" : hostInfo.getUser();
                            String password = StringUtils.isNullOrEmpty(hostInfo.getPassword()) ? "" : hostInfo.getPassword();
                            MysqlaSession newSession = new MysqlaSession(hostInfo, session.getPropertySet());
                            newSession.connect(hostInfo, user, password, database, 30000, new TransactionEventHandler(){

                                @Override
                                public void transactionCompleted() {
                                }

                                @Override
                                public void transactionBegun() {
                                }
                            });
                            newSession.sendCommand(new CommandBuilder().buildComQuery(newSession.getSharedSendPacket(), "KILL QUERY " + origConnId), false, 0);
                            localQueryToCancel.setCancelStatus(Query.CancelStatus.CANCELED_BY_TIMEOUT);
                        }
                    }
                    catch (Throwable t) {
                        CancelQueryTask.this.caughtWhileCancelling = t;
                    }
                    finally {
                        CancelQueryTask.this.setQueryToCancel(null);
                    }
                }
            }
        };
        cancelThread.start();
    }

    public Throwable getCaughtWhileCancelling() {
        return this.caughtWhileCancelling;
    }

    public void setCaughtWhileCancelling(Throwable caughtWhileCancelling) {
        this.caughtWhileCancelling = caughtWhileCancelling;
    }

    public Query getQueryToCancel() {
        return this.queryToCancel;
    }

    public void setQueryToCancel(Query queryToCancel) {
        this.queryToCancel = queryToCancel;
    }
}

