/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla;

import com.mysql.cj.api.CacheAdapter;
import com.mysql.cj.api.CacheAdapterFactory;
import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.Query;
import com.mysql.cj.api.Session;
import com.mysql.cj.api.TransactionEventHandler;
import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.interceptors.QueryInterceptor;
import com.mysql.cj.api.io.SocketFactory;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.io.ProtocolEntityFactory;
import com.mysql.cj.api.mysqla.result.ColumnDefinition;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.core.AbstractSession;
import com.mysql.cj.core.CharsetMapping;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ConnectionIsClosedException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.ExceptionInterceptorChain;
import com.mysql.cj.core.exceptions.OperationCancelledException;
import com.mysql.cj.core.exceptions.PasswordExpiredException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.IntegerValueFactory;
import com.mysql.cj.core.io.LongValueFactory;
import com.mysql.cj.core.io.NetworkResources;
import com.mysql.cj.core.io.StringValueFactory;
import com.mysql.cj.core.log.LogFactory;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.TimeUtil;
import com.mysql.cj.mysqla.MysqlaUtils;
import com.mysql.cj.mysqla.io.CommandBuilder;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import com.mysql.cj.mysqla.io.MysqlaServerSession;
import com.mysql.cj.mysqla.io.MysqlaSocketConnection;
import com.mysql.cj.mysqla.io.ResultsetFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public class MysqlaSession
extends AbstractSession
implements Session,
Serializable {
    private static final long serialVersionUID = 5323638898749073419L;
    protected transient MysqlaProtocol protocol;
    private TimeZone serverTimezoneTZ = null;
    private TimeZone defaultTimeZone = TimeZone.getDefault();
    private int sessionMaxRows = -1;
    private HostInfo hostInfo = null;
    protected ModifiableProperty<Integer> socketTimeout;
    private ReadableProperty<Boolean> gatherPerfMetrics;
    private ModifiableProperty<String> characterEncoding;
    private ReadableProperty<Boolean> useOldUTF8Behavior;
    private ReadableProperty<Boolean> disconnectOnExpiredPasswords;
    private ReadableProperty<Boolean> cacheServerConfiguration;
    private ModifiableProperty<Boolean> autoReconnect;
    private ReadableProperty<Boolean> autoReconnectForPools;
    private ReadableProperty<Boolean> maintainTimeStats;
    private boolean serverHasFracSecsSupport = true;
    private CacheAdapter<String, Map<String, String>> serverConfigCache;
    private static final Map<String, Map<Integer, String>> customIndexToCharsetMapByUrl = new HashMap<String, Map<Integer, String>>();
    private static final Map<String, Map<String, Integer>> customCharsetToMblenMapByUrl = new HashMap<String, Map<String, Integer>>();
    private boolean requiresEscapingEncoder;
    private long lastQueryFinishedTime = 0L;
    private boolean needsPing = false;
    private boolean autoCommit = true;
    private long connectionCreationTimeMillis = 0L;
    private CommandBuilder commandBuilder = new CommandBuilder();
    private boolean isClosed = true;
    private Throwable forceClosedReason;
    private CopyOnWriteArrayList<WeakReference<Session.SessionEventListener>> listeners = new CopyOnWriteArrayList();
    private transient Timer cancelTimer;
    private static final String SERVER_VERSION_STRING_VAR_NAME = "server_version_string";

    public MysqlaSession(HostInfo hostInfo, PropertySet propSet) {
        this.connectionCreationTimeMillis = System.currentTimeMillis();
        this.propertySet = propSet;
        this.socketTimeout = this.getPropertySet().getModifiableProperty("socketTimeout");
        this.gatherPerfMetrics = this.getPropertySet().getBooleanReadableProperty("gatherPerfMetrics");
        this.characterEncoding = this.getPropertySet().getModifiableProperty("characterEncoding");
        this.useOldUTF8Behavior = this.getPropertySet().getBooleanReadableProperty("useOldUTF8Behavior");
        this.disconnectOnExpiredPasswords = this.getPropertySet().getBooleanReadableProperty("disconnectOnExpiredPasswords");
        this.cacheServerConfiguration = this.getPropertySet().getBooleanReadableProperty("cacheServerConfiguration");
        this.autoReconnect = this.getPropertySet().getModifiableProperty("autoReconnect");
        this.autoReconnectForPools = this.getPropertySet().getBooleanReadableProperty("autoReconnectForPools");
        this.maintainTimeStats = this.getPropertySet().getBooleanReadableProperty("maintainTimeStats");
        this.hostInfo = hostInfo;
        this.log = LogFactory.getLogger(this.getPropertySet().getStringReadableProperty("logger").getStringValue(), "MySQL");
        if (this.getPropertySet().getBooleanReadableProperty("profileSQL").getValue().booleanValue() || this.getPropertySet().getBooleanReadableProperty("useUsageAdvisor").getValue().booleanValue()) {
            ProfilerEventHandlerFactory.getInstance(this);
        }
    }

    public void connect(HostInfo hi, String user, String password, String database, int loginTimeout, TransactionEventHandler transactionManager) throws IOException {
        this.connect(hi, hi.exposeAsProperties(), user, password, database, loginTimeout, transactionManager);
    }

    public void connect(HostInfo hi, Properties mergedProps, String user, String password, String database, int loginTimeout, TransactionEventHandler transactionManager) throws IOException {
        this.hostInfo = hi;
        this.setSessionMaxRows(-1);
        MysqlaSocketConnection socketConnection = new MysqlaSocketConnection();
        socketConnection.connect(this.hostInfo.getHost(), this.hostInfo.getPort(), mergedProps, this.getPropertySet(), this.getExceptionInterceptor(), this.log, loginTimeout);
        if (this.protocol == null) {
            this.protocol = MysqlaProtocol.getInstance(this, socketConnection, this.propertySet, this.log, transactionManager);
        } else {
            this.protocol.init(this, socketConnection, this.propertySet, transactionManager);
        }
        this.protocol.connect(user, password, database);
        this.serverHasFracSecsSupport = this.protocol.versionMeetsMinimum(5, 6, 4);
        this.protocol.getServerSession().setErrorMessageEncoding(this.protocol.getAuthenticationProvider().getEncodingForHandshake());
        this.isClosed = false;
    }

    public MysqlaProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void changeUser(String userName, String password, String database) {
        this.sessionMaxRows = -1;
        this.protocol.changeUser(userName, password, database);
    }

    @Override
    public String getServerVariable(String name) {
        return this.protocol.getServerSession().getServerVariable(name);
    }

    @Override
    public int getServerVariable(String variableName, int fallbackValue) {
        try {
            return Integer.valueOf(this.protocol.getServerSession().getServerVariable(variableName));
        }
        catch (NumberFormatException nfe) {
            this.getLog().logWarn(Messages.getString("Connection.BadValueInServerVariables", new Object[]{variableName, this.protocol.getServerSession().getServerVariable(variableName), fallbackValue}));
            return fallbackValue;
        }
    }

    @Override
    public boolean inTransactionOnServer() {
        return this.protocol.getServerSession().inTransactionOnServer();
    }

    @Override
    public Map<String, String> getServerVariables() {
        return this.protocol.getServerSession().getServerVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortInternal() {
        if (this.protocol != null) {
            try {
                this.protocol.getSocketConnection().forceClose();
                this.protocol.releaseResources();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        MysqlaSession mysqlaSession = this;
        synchronized (mysqlaSession) {
            if (this.cancelTimer != null) {
                this.cancelTimer.cancel();
                this.cancelTimer = null;
            }
        }
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quit() {
        if (this.protocol != null) {
            try {
                this.protocol.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MysqlaSession mysqlaSession = this;
        synchronized (mysqlaSession) {
            if (this.cancelTimer != null) {
                this.cancelTimer.cancel();
                this.cancelTimer = null;
            }
        }
        this.isClosed = true;
    }

    @Override
    public void forceClose() {
        this.abortInternal();
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.protocol.getServerSession().getServerVersion();
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        return this.protocol.versionMeetsMinimum(major, minor, subminor);
    }

    public void enableMultiQueries() {
        this.sendCommand(this.commandBuilder.buildComSetOption(this.protocol.getSharedSendPacket(), 0), false, 0);
    }

    public void disableMultiQueries() {
        this.sendCommand(this.commandBuilder.buildComSetOption(this.protocol.getSharedSendPacket(), 1), false, 0);
    }

    @Override
    public long getThreadId() {
        return this.protocol.getServerSession().getCapabilities().getThreadId();
    }

    @Override
    public boolean isSetNeededForAutoCommitMode(boolean autoCommitFlag) {
        return this.protocol.getServerSession().isSetNeededForAutoCommitMode(autoCommitFlag, false);
    }

    @Override
    public void configureTimezone() {
        String configuredTimeZoneOnServer = this.protocol.getServerSession().getServerVariable("time_zone");
        if ("SYSTEM".equalsIgnoreCase(configuredTimeZoneOnServer)) {
            configuredTimeZoneOnServer = this.protocol.getServerSession().getServerVariable("system_time_zone");
        }
        String canonicalTimezone = this.getPropertySet().getStringReadableProperty("serverTimezone").getValue();
        if (configuredTimeZoneOnServer != null && (canonicalTimezone == null || StringUtils.isEmptyOrWhitespaceOnly(canonicalTimezone))) {
            try {
                canonicalTimezone = TimeUtil.getCanonicalTimezone(configuredTimeZoneOnServer, this.getExceptionInterceptor());
            }
            catch (IllegalArgumentException iae) {
                throw ExceptionFactory.createException(WrongArgumentException.class, iae.getMessage(), this.getExceptionInterceptor());
            }
        }
        if (canonicalTimezone != null && canonicalTimezone.length() > 0) {
            this.serverTimezoneTZ = TimeZone.getTimeZone(canonicalTimezone);
            if (!canonicalTimezone.equalsIgnoreCase("GMT") && this.serverTimezoneTZ.getID().equals("GMT")) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Connection.9", new Object[]{canonicalTimezone}), this.getExceptionInterceptor());
            }
        }
        this.defaultTimeZone = this.serverTimezoneTZ;
    }

    @Override
    public TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    @Override
    public String getErrorMessageEncoding() {
        return this.protocol.getServerSession().getErrorMessageEncoding();
    }

    public String getServerCharset() {
        return this.protocol.getServerSession().getServerDefaultCharset();
    }

    @Override
    public int getMaxBytesPerChar(String javaCharsetName) {
        return this.protocol.getServerSession().getMaxBytesPerChar(javaCharsetName);
    }

    @Override
    public int getMaxBytesPerChar(Integer charsetIndex, String javaCharsetName) {
        return this.protocol.getServerSession().getMaxBytesPerChar(charsetIndex, javaCharsetName);
    }

    @Override
    public String getEncodingForIndex(int charsetIndex) {
        return this.protocol.getServerSession().getEncodingForIndex(charsetIndex);
    }

    public int getSessionMaxRows() {
        return this.sessionMaxRows;
    }

    public void setSessionMaxRows(int sessionMaxRows) {
        this.sessionMaxRows = sessionMaxRows;
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public void setQueryInterceptors(List<QueryInterceptor> queryInterceptors) {
        this.protocol.setQueryInterceptors(queryInterceptors);
    }

    public boolean isServerLocal(Session sess) {
        SocketFactory factory = this.protocol.getSocketConnection().getSocketFactory();
        return factory.isLocallyConnected(sess);
    }

    public void shutdownServer() {
        if (this.versionMeetsMinimum(5, 7, 9)) {
            this.sendCommand(this.commandBuilder.buildComQuery(this.getSharedSendPacket(), "SHUTDOWN"), false, 0);
        } else {
            this.sendCommand(this.commandBuilder.buildComShutdown(this.getSharedSendPacket()), false, 0);
        }
    }

    public void setSocketTimeout(int milliseconds) {
        this.socketTimeout.setValue(milliseconds);
        this.protocol.setSocketTimeout(milliseconds);
    }

    public int getSocketTimeout() {
        return (Integer)this.socketTimeout.getValue();
    }

    public void checkForCharsetMismatch() {
        this.protocol.checkForCharsetMismatch();
    }

    public PacketPayload getSharedSendPacket() {
        return this.protocol.getSharedSendPacket();
    }

    public void dumpPacketRingBuffer() {
        this.protocol.dumpPacketRingBuffer();
    }

    public <T extends Resultset> T invokeQueryInterceptorsPre(Supplier<String> sql, Query interceptedQuery, boolean forceExecute) {
        return this.protocol.invokeQueryInterceptorsPre(sql, interceptedQuery, forceExecute);
    }

    public <T extends Resultset> T invokeQueryInterceptorsPost(Supplier<String> sql, Query interceptedQuery, T originalResultSet, boolean forceExecute) {
        return this.protocol.invokeQueryInterceptorsPost(sql, interceptedQuery, originalResultSet, forceExecute);
    }

    public boolean shouldIntercept() {
        return this.protocol.getQueryInterceptors() != null;
    }

    public long getCurrentTimeNanosOrMillis() {
        return this.protocol.getCurrentTimeNanosOrMillis();
    }

    public final PacketPayload sendCommand(PacketPayload queryPacket, boolean skipCheck, int timeoutMillis) {
        return this.protocol.sendCommand(queryPacket, skipCheck, timeoutMillis);
    }

    public long getSlowQueryThreshold() {
        return this.protocol.getSlowQueryThreshold();
    }

    public String getQueryTimingUnits() {
        return this.protocol.getQueryTimingUnits();
    }

    public boolean hadWarnings() {
        return this.protocol.hadWarnings();
    }

    public void clearInputStream() {
        this.protocol.clearInputStream();
    }

    public NetworkResources getNetworkResources() {
        return this.protocol.getSocketConnection().getNetworkResources();
    }

    @Override
    public MysqlaServerSession getServerSession() {
        return this.protocol.getServerSession();
    }

    @Override
    public boolean isSSLEstablished() {
        return this.protocol.getSocketConnection().isSSLEstablished();
    }

    public int getCommandCount() {
        return this.protocol.getCommandCount();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.protocol.getSocketConnection().getMysqlSocket().getRemoteSocketAddress();
    }

    @Override
    public boolean serverSupportsFracSecs() {
        return this.serverHasFracSecsSupport;
    }

    public ProfilerEventHandler getProfilerEventHandlerInstanceFunction() {
        return ProfilerEventHandlerFactory.getInstance(this);
    }

    public InputStream getLocalInfileInputStream() {
        return this.protocol.getLocalInfileInputStream();
    }

    public void setLocalInfileInputStream(InputStream stream) {
        this.protocol.setLocalInfileInputStream(stream);
    }

    public void registerQueryExecutionTime(long queryTimeMs) {
        this.protocol.getMetricsHolder().registerQueryExecutionTime(queryTimeMs);
    }

    public void reportNumberOfTablesAccessed(int numTablesAccessed) {
        this.protocol.getMetricsHolder().reportNumberOfTablesAccessed(numTablesAccessed);
    }

    public void incrementNumberOfPreparedExecutes() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            this.protocol.getMetricsHolder().incrementNumberOfPreparedExecutes();
        }
    }

    public void incrementNumberOfPrepares() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            this.protocol.getMetricsHolder().incrementNumberOfPrepares();
        }
    }

    public void incrementNumberOfResultSetsCreated() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            this.protocol.getMetricsHolder().incrementNumberOfResultSetsCreated();
        }
    }

    public void reportMetrics() {
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            // empty if block
        }
    }

    private void configureCharsetProperties() {
        if (this.characterEncoding.getValue() != null) {
            try {
                String testString = "abc";
                StringUtils.getBytes(testString, (String)this.characterEncoding.getValue());
            }
            catch (WrongArgumentException waEx) {
                String oldEncoding = (String)this.characterEncoding.getValue();
                this.characterEncoding.setValue(CharsetMapping.getJavaEncodingForMysqlCharset(oldEncoding));
                if (this.characterEncoding.getValue() == null) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Connection.5", new Object[]{oldEncoding}), this.getExceptionInterceptor());
                }
                String testString = "abc";
                StringUtils.getBytes(testString, (String)this.characterEncoding.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configureClientCharacterSet(boolean dontCheckServerMatch) {
        boolean characterSetAlreadyConfigured;
        block55: {
            block54: {
                String realJavaEncoding = (String)this.characterEncoding.getValue();
                ModifiableProperty<String> characterSetResults = this.getPropertySet().getModifiableProperty("characterSetResults");
                characterSetAlreadyConfigured = false;
                try {
                    String mysqlCharsetName;
                    characterSetAlreadyConfigured = true;
                    this.configureCharsetProperties();
                    realJavaEncoding = (String)this.characterEncoding.getValue();
                    try {
                        String serverEncodingToSet = CharsetMapping.getJavaEncodingForCollationIndex(this.protocol.getServerSession().getServerDefaultCollationIndex());
                        if (serverEncodingToSet == null || serverEncodingToSet.length() == 0) {
                            if (realJavaEncoding != null) {
                                this.characterEncoding.setValue(realJavaEncoding);
                            } else {
                                throw ExceptionFactory.createException(Messages.getString("Connection.6", new Object[]{this.protocol.getServerSession().getServerDefaultCollationIndex()}), this.getExceptionInterceptor());
                            }
                        }
                        if ("ISO8859_1".equalsIgnoreCase(serverEncodingToSet)) {
                            serverEncodingToSet = "Cp1252";
                        }
                        if ("UnicodeBig".equalsIgnoreCase(serverEncodingToSet) || "UTF-16".equalsIgnoreCase(serverEncodingToSet) || "UTF-16LE".equalsIgnoreCase(serverEncodingToSet) || "UTF-32".equalsIgnoreCase(serverEncodingToSet)) {
                            serverEncodingToSet = "UTF-8";
                        }
                        this.characterEncoding.setValue(serverEncodingToSet);
                    }
                    catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                        if (realJavaEncoding != null) {
                            this.characterEncoding.setValue(realJavaEncoding);
                        }
                        throw ExceptionFactory.createException(Messages.getString("Connection.6", new Object[]{this.protocol.getServerSession().getServerDefaultCollationIndex()}), this.getExceptionInterceptor());
                    }
                    if (this.characterEncoding.getValue() == null) {
                        this.characterEncoding.setValue("ISO8859_1");
                    }
                    if (realJavaEncoding != null) {
                        if (realJavaEncoding.equalsIgnoreCase("UTF-8") || realJavaEncoding.equalsIgnoreCase("UTF8")) {
                            boolean useutf8mb4 = CharsetMapping.UTF8MB4_INDEXES.contains(this.protocol.getServerSession().getServerDefaultCollationIndex());
                            if (!this.useOldUTF8Behavior.getValue().booleanValue()) {
                                if (dontCheckServerMatch || !this.protocol.getServerSession().characterSetNamesMatches("utf8") || !this.protocol.getServerSession().characterSetNamesMatches("utf8mb4")) {
                                    this.sendCommand(this.commandBuilder.buildComQuery(null, "SET NAMES " + (useutf8mb4 ? "utf8mb4" : "utf8")), false, 0);
                                    this.protocol.getServerSession().getServerVariables().put("character_set_client", useutf8mb4 ? "utf8mb4" : "utf8");
                                    this.protocol.getServerSession().getServerVariables().put("character_set_connection", useutf8mb4 ? "utf8mb4" : "utf8");
                                }
                            } else {
                                this.sendCommand(this.commandBuilder.buildComQuery(null, "SET NAMES latin1"), false, 0);
                                this.protocol.getServerSession().getServerVariables().put("character_set_client", "latin1");
                                this.protocol.getServerSession().getServerVariables().put("character_set_connection", "latin1");
                            }
                            this.characterEncoding.setValue(realJavaEncoding);
                        } else {
                            mysqlCharsetName = CharsetMapping.getMysqlCharsetForJavaEncoding(realJavaEncoding.toUpperCase(Locale.ENGLISH), this.getServerVersion());
                            if (mysqlCharsetName != null && (dontCheckServerMatch || !this.protocol.getServerSession().characterSetNamesMatches(mysqlCharsetName))) {
                                this.sendCommand(this.commandBuilder.buildComQuery(null, "SET NAMES " + mysqlCharsetName), false, 0);
                                this.protocol.getServerSession().getServerVariables().put("character_set_client", mysqlCharsetName);
                                this.protocol.getServerSession().getServerVariables().put("character_set_connection", mysqlCharsetName);
                            }
                            this.characterEncoding.setValue(realJavaEncoding);
                        }
                    } else if (this.characterEncoding.getValue() != null) {
                        block50: {
                            mysqlCharsetName = this.getServerCharset();
                            if (this.useOldUTF8Behavior.getValue().booleanValue()) {
                                mysqlCharsetName = "latin1";
                            }
                            boolean ucs2 = false;
                            if ("ucs2".equalsIgnoreCase(mysqlCharsetName) || "utf16".equalsIgnoreCase(mysqlCharsetName) || "utf16le".equalsIgnoreCase(mysqlCharsetName) || "utf32".equalsIgnoreCase(mysqlCharsetName)) {
                                mysqlCharsetName = "utf8";
                                ucs2 = true;
                                if (characterSetResults.getValue() == null) {
                                    characterSetResults.setValue("UTF-8");
                                }
                            }
                            if (dontCheckServerMatch || !this.protocol.getServerSession().characterSetNamesMatches(mysqlCharsetName) || ucs2) {
                                try {
                                    this.sendCommand(this.commandBuilder.buildComQuery(null, "SET NAMES " + mysqlCharsetName), false, 0);
                                    this.protocol.getServerSession().getServerVariables().put("character_set_client", mysqlCharsetName);
                                    this.protocol.getServerSession().getServerVariables().put("character_set_connection", mysqlCharsetName);
                                }
                                catch (PasswordExpiredException ex) {
                                    if (!this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block50;
                                    throw ex;
                                }
                            }
                        }
                        realJavaEncoding = (String)this.characterEncoding.getValue();
                    }
                    String onServer = this.protocol.getServerSession().getServerVariable("character_set_results");
                    if (characterSetResults.getValue() == null) {
                        if (onServer != null && onServer.length() > 0 && !"NULL".equalsIgnoreCase(onServer)) {
                            block51: {
                                try {
                                    this.sendCommand(this.commandBuilder.buildComQuery(null, "SET character_set_results = NULL"), false, 0);
                                }
                                catch (PasswordExpiredException ex) {
                                    if (!this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block51;
                                    throw ex;
                                }
                            }
                            this.protocol.getServerSession().getServerVariables().put("local.character_set_results", null);
                        } else {
                            this.protocol.getServerSession().getServerVariables().put("local.character_set_results", onServer);
                        }
                    } else {
                        block52: {
                            if (this.useOldUTF8Behavior.getValue().booleanValue()) {
                                try {
                                    this.sendCommand(this.commandBuilder.buildComQuery(null, "SET NAMES latin1"), false, 0);
                                    this.protocol.getServerSession().getServerVariables().put("character_set_client", "latin1");
                                    this.protocol.getServerSession().getServerVariables().put("character_set_connection", "latin1");
                                }
                                catch (PasswordExpiredException ex) {
                                    if (!this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block52;
                                    throw ex;
                                }
                            }
                        }
                        String charsetResults = (String)characterSetResults.getValue();
                        String mysqlEncodingName = null;
                        mysqlEncodingName = "UTF-8".equalsIgnoreCase(charsetResults) || "UTF8".equalsIgnoreCase(charsetResults) ? "utf8" : ("null".equalsIgnoreCase(charsetResults) ? "NULL" : CharsetMapping.getMysqlCharsetForJavaEncoding(charsetResults.toUpperCase(Locale.ENGLISH), this.getServerVersion()));
                        if (mysqlEncodingName == null) {
                            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Connection.7", new Object[]{charsetResults}), this.getExceptionInterceptor());
                        }
                        if (!mysqlEncodingName.equalsIgnoreCase(this.protocol.getServerSession().getServerVariable("character_set_results"))) {
                            block53: {
                                StringBuilder setBuf = new StringBuilder("SET character_set_results = ".length() + mysqlEncodingName.length());
                                setBuf.append("SET character_set_results = ").append(mysqlEncodingName);
                                try {
                                    this.sendCommand(this.commandBuilder.buildComQuery(null, setBuf.toString()), false, 0);
                                }
                                catch (PasswordExpiredException ex) {
                                    if (!this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block53;
                                    throw ex;
                                }
                            }
                            this.protocol.getServerSession().getServerVariables().put("local.character_set_results", mysqlEncodingName);
                            this.protocol.getServerSession().setErrorMessageEncoding(charsetResults);
                        } else {
                            this.protocol.getServerSession().getServerVariables().put("local.character_set_results", onServer);
                        }
                    }
                    String connectionCollation = this.getPropertySet().getStringReadableProperty("connectionCollation").getStringValue();
                    if (connectionCollation == null) break block54;
                    StringBuilder setBuf = new StringBuilder("SET collation_connection = ".length() + connectionCollation.length());
                    setBuf.append("SET collation_connection = ").append(connectionCollation);
                    try {
                        this.sendCommand(this.commandBuilder.buildComQuery(null, setBuf.toString()), false, 0);
                    }
                    catch (PasswordExpiredException ex) {
                        if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                            throw ex;
                        }
                    }
                }
                finally {
                    this.characterEncoding.setValue(realJavaEncoding);
                }
            }
            try {
                CharsetEncoder enc = Charset.forName((String)this.characterEncoding.getValue()).newEncoder();
                CharBuffer cbuf = CharBuffer.allocate(1);
                ByteBuffer bbuf = ByteBuffer.allocate(1);
                cbuf.put("\u00a5");
                cbuf.position(0);
                enc.encode(cbuf, bbuf, true);
                if (bbuf.get(0) == 92) {
                    this.requiresEscapingEncoder = true;
                } else {
                    cbuf.clear();
                    bbuf.clear();
                    cbuf.put("\u20a9");
                    cbuf.position(0);
                    enc.encode(cbuf, bbuf, true);
                    if (bbuf.get(0) == 92) {
                        this.requiresEscapingEncoder = true;
                    }
                }
            }
            catch (UnsupportedCharsetException ucex) {
                byte[] bbuf = StringUtils.getBytes("\u00a5", (String)this.characterEncoding.getValue());
                if (bbuf[0] == 92) {
                    this.requiresEscapingEncoder = true;
                }
                bbuf = StringUtils.getBytes("\u20a9", (String)this.characterEncoding.getValue());
                if (bbuf[0] != 92) break block55;
                this.requiresEscapingEncoder = true;
            }
        }
        return characterSetAlreadyConfigured;
    }

    public boolean getRequiresEscapingEncoder() {
        return this.requiresEscapingEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfigCacheIfNeeded(Object syncMutex) {
        Object object = syncMutex;
        synchronized (object) {
            if (this.serverConfigCache != null) {
                return;
            }
            try {
                Class<?> factoryClass = Class.forName(this.getPropertySet().getStringReadableProperty("serverConfigCacheFactory").getStringValue());
                CacheAdapterFactory cacheFactory = (CacheAdapterFactory)factoryClass.newInstance();
                this.serverConfigCache = cacheFactory.getInstance(syncMutex, this.hostInfo.getDatabaseUrl(), Integer.MAX_VALUE, Integer.MAX_VALUE);
                ExceptionInterceptor evictOnCommsError = new ExceptionInterceptor(){

                    @Override
                    public ExceptionInterceptor init(Properties config, Log log1) {
                        return this;
                    }

                    @Override
                    public void destroy() {
                    }

                    @Override
                    public Exception interceptException(Exception sqlEx) {
                        if (sqlEx instanceof SQLException && ((SQLException)sqlEx).getSQLState() != null && ((SQLException)sqlEx).getSQLState().startsWith("08")) {
                            MysqlaSession.this.serverConfigCache.invalidate(MysqlaSession.this.hostInfo.getDatabaseUrl());
                        }
                        return null;
                    }
                };
                if (this.exceptionInterceptor == null) {
                    this.exceptionInterceptor = evictOnCommsError;
                } else {
                    ((ExceptionInterceptorChain)this.exceptionInterceptor).addRingZero(evictOnCommsError);
                }
            }
            catch (ClassNotFoundException e) {
                throw ExceptionFactory.createException(Messages.getString("Connection.CantFindCacheFactory", new Object[]{this.getPropertySet().getStringReadableProperty("parseInfoCacheFactory").getValue(), "parseInfoCacheFactory"}), e, this.getExceptionInterceptor());
            }
            catch (CJException | IllegalAccessException | InstantiationException e) {
                throw ExceptionFactory.createException(Messages.getString("Connection.CantLoadCacheFactory", new Object[]{this.getPropertySet().getStringReadableProperty("parseInfoCacheFactory").getValue(), "parseInfoCacheFactory"}), e, this.getExceptionInterceptor());
            }
        }
    }

    public void loadServerVariables(Object syncMutex, String version) {
        if (this.cacheServerConfiguration.getValue().booleanValue()) {
            this.createConfigCacheIfNeeded(syncMutex);
            Map<String, String> cachedVariableMap = this.serverConfigCache.get(this.hostInfo.getDatabaseUrl());
            if (cachedVariableMap != null) {
                String cachedServerVersion = cachedVariableMap.get(SERVER_VERSION_STRING_VAR_NAME);
                if (cachedServerVersion != null && this.getServerVersion() != null && cachedServerVersion.equals(this.getServerVersion().toString())) {
                    this.protocol.getServerSession().setServerVariables(cachedVariableMap);
                    return;
                }
                this.serverConfigCache.invalidate(this.hostInfo.getDatabaseUrl());
            }
        }
        try {
            if (version != null && version.indexOf(42) != -1) {
                StringBuilder buf = new StringBuilder(version.length() + 10);
                for (int i = 0; i < version.length(); ++i) {
                    char c = version.charAt(i);
                    buf.append(c == '*' ? "[star]" : Character.valueOf(c));
                }
                version = buf.toString();
            }
            String versionComment = this.propertySet.getBooleanReadableProperty("paranoid").getValue() != false || version == null ? "" : "/* " + version + " */";
            this.protocol.getServerSession().setServerVariables(new HashMap<String, String>());
            if (this.versionMeetsMinimum(5, 1, 0)) {
                int i;
                Row r;
                StringValueFactory vf;
                StringBuilder queryBuf = new StringBuilder(versionComment).append("SELECT");
                queryBuf.append("  @@session.auto_increment_increment AS auto_increment_increment");
                queryBuf.append(", @@character_set_client AS character_set_client");
                queryBuf.append(", @@character_set_connection AS character_set_connection");
                queryBuf.append(", @@character_set_results AS character_set_results");
                queryBuf.append(", @@character_set_server AS character_set_server");
                queryBuf.append(", @@collation_server AS collation_server");
                queryBuf.append(", @@init_connect AS init_connect");
                queryBuf.append(", @@interactive_timeout AS interactive_timeout");
                if (!this.versionMeetsMinimum(5, 5, 0)) {
                    queryBuf.append(", @@language AS language");
                }
                queryBuf.append(", @@license AS license");
                queryBuf.append(", @@lower_case_table_names AS lower_case_table_names");
                queryBuf.append(", @@max_allowed_packet AS max_allowed_packet");
                queryBuf.append(", @@net_write_timeout AS net_write_timeout");
                if (this.versionMeetsMinimum(8, 0, 3)) {
                    queryBuf.append(", @@have_query_cache AS have_query_cache");
                } else {
                    queryBuf.append(", @@query_cache_size AS query_cache_size");
                    queryBuf.append(", @@query_cache_type AS query_cache_type");
                }
                queryBuf.append(", @@sql_mode AS sql_mode");
                queryBuf.append(", @@system_time_zone AS system_time_zone");
                queryBuf.append(", @@time_zone AS time_zone");
                if (this.versionMeetsMinimum(8, 0, 3)) {
                    queryBuf.append(", @@transaction_isolation AS transaction_isolation");
                } else {
                    queryBuf.append(", @@tx_isolation AS tx_isolation");
                }
                queryBuf.append(", @@wait_timeout AS wait_timeout");
                PacketPayload resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, queryBuf.toString()), false, 0);
                Resultset rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
                Field[] f = rs.getColumnDefinition().getFields();
                if (f.length > 0) {
                    vf = new StringValueFactory(f[0].getEncoding());
                    r = (Row)rs.getRows().next();
                    if (r != null) {
                        for (i = 0; i < f.length; ++i) {
                            this.protocol.getServerSession().getServerVariables().put(f[i].getColumnLabel(), r.getValue(i, vf));
                        }
                    }
                }
                if (this.versionMeetsMinimum(8, 0, 3) && "YES".equalsIgnoreCase(this.protocol.getServerSession().getServerVariables().get("have_query_cache")) && (f = (rs = this.protocol.readAllResults(-1, false, resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, "SELECT @@query_cache_size AS query_cache_size, @@query_cache_type AS query_cache_type"), false, 0), false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null))).getColumnDefinition().getFields()).length > 0) {
                    vf = new StringValueFactory(f[0].getEncoding());
                    r = (Row)rs.getRows().next();
                    if (r != null) {
                        for (i = 0; i < f.length; ++i) {
                            this.protocol.getServerSession().getServerVariables().put(f[i].getColumnLabel(), r.getValue(i, vf));
                        }
                    }
                }
            } else {
                Row r;
                PacketPayload resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, versionComment + "SHOW VARIABLES"), false, 0);
                Resultset rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
                StringValueFactory vf = new StringValueFactory(rs.getColumnDefinition().getFields()[0].getEncoding());
                while ((r = (Row)rs.getRows().next()) != null) {
                    this.protocol.getServerSession().getServerVariables().put(r.getValue(0, vf), r.getValue(1, vf));
                }
            }
        }
        catch (PasswordExpiredException ex) {
            if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                throw ex;
            }
        }
        catch (IOException e) {
            throw ExceptionFactory.createException(e.getMessage(), e);
        }
        if (this.cacheServerConfiguration.getValue().booleanValue()) {
            this.protocol.getServerSession().getServerVariables().put(SERVER_VERSION_STRING_VAR_NAME, this.getServerVersion().toString());
            this.serverConfigCache.put(this.hostInfo.getDatabaseUrl(), this.protocol.getServerSession().getServerVariables());
        }
    }

    public void setSessionVariables() {
        String sessionVariables = this.getPropertySet().getStringReadableProperty("sessionVariables").getValue();
        if (sessionVariables != null) {
            ArrayList<String> variablesToSet = new ArrayList<String>();
            for (String part : StringUtils.split(sessionVariables, ",", "\"'(", "\"')", "\"'", true)) {
                variablesToSet.addAll(StringUtils.split(part, ";", "\"'(", "\"')", "\"'", true));
            }
            if (!variablesToSet.isEmpty()) {
                StringBuilder query = new StringBuilder("SET ");
                String separator = "";
                for (String variableToSet : variablesToSet) {
                    if (variableToSet.length() <= 0) continue;
                    query.append(separator);
                    if (!variableToSet.startsWith("@")) {
                        query.append("SESSION ");
                    }
                    query.append(variableToSet);
                    separator = ",";
                }
                this.sendCommand(this.commandBuilder.buildComQuery(null, query.toString()), false, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildCollationMapping() {
        Map<Integer, String> customCharset = null;
        Map<String, Integer> customMblen = null;
        String databaseURL = this.hostInfo.getDatabaseUrl();
        if (this.cacheServerConfiguration.getValue().booleanValue()) {
            Map<String, Map<Integer, String>> map = customIndexToCharsetMapByUrl;
            synchronized (map) {
                customCharset = customIndexToCharsetMapByUrl.get(databaseURL);
                customMblen = customCharsetToMblenMapByUrl.get(databaseURL);
            }
        }
        if (customCharset == null && this.getPropertySet().getBooleanReadableProperty("detectCustomCollations").getValue().booleanValue()) {
            Resultset rs;
            PacketPayload resultPacket;
            customCharset = new HashMap<Integer, String>();
            customMblen = new HashMap<String, Integer>();
            IntegerValueFactory ivf = new IntegerValueFactory();
            try {
                Row r;
                resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, "SHOW COLLATION"), false, 0);
                rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
                StringValueFactory svf = new StringValueFactory(rs.getColumnDefinition().getFields()[1].getEncoding());
                while ((r = (Row)rs.getRows().next()) != null) {
                    int collationIndex = ((Number)r.getValue(2, ivf)).intValue();
                    String charsetName = r.getValue(1, svf);
                    if (collationIndex >= 2048 || !charsetName.equals(CharsetMapping.getMysqlCharsetNameForCollationIndex(collationIndex))) {
                        customCharset.put(collationIndex, charsetName);
                    }
                    if (CharsetMapping.CHARSET_NAME_TO_CHARSET.containsKey(charsetName)) continue;
                    customMblen.put(charsetName, null);
                }
            }
            catch (PasswordExpiredException ex) {
                if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                    throw ex;
                }
            }
            catch (IOException e) {
                throw ExceptionFactory.createException(e.getMessage(), e, this.exceptionInterceptor);
            }
            if (customMblen.size() > 0) {
                try {
                    Row r;
                    resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, "SHOW CHARACTER SET"), false, 0);
                    rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
                    int charsetColumn = rs.getColumnDefinition().getColumnNameToIndex().get("Charset");
                    int maxlenColumn = rs.getColumnDefinition().getColumnNameToIndex().get("Maxlen");
                    StringValueFactory svf = new StringValueFactory(rs.getColumnDefinition().getFields()[1].getEncoding());
                    while ((r = (Row)rs.getRows().next()) != null) {
                        String charsetName = r.getValue(charsetColumn, svf);
                        if (!customMblen.containsKey(charsetName)) continue;
                        customMblen.put(charsetName, r.getValue(maxlenColumn, ivf));
                    }
                }
                catch (PasswordExpiredException ex) {
                    if (this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                        throw ex;
                    }
                }
                catch (IOException e) {
                    throw ExceptionFactory.createException(e.getMessage(), e, this.exceptionInterceptor);
                }
            }
            if (this.cacheServerConfiguration.getValue().booleanValue()) {
                Map<String, Map<Integer, String>> e = customIndexToCharsetMapByUrl;
                synchronized (e) {
                    customIndexToCharsetMapByUrl.put(databaseURL, customCharset);
                    customCharsetToMblenMapByUrl.put(databaseURL, customMblen);
                }
            }
        }
        if (customCharset != null) {
            this.protocol.getServerSession().indexToCustomMysqlCharset = Collections.unmodifiableMap(customCharset);
        }
        if (customMblen != null) {
            this.protocol.getServerSession().mysqlCharsetToCustomMblen = Collections.unmodifiableMap(customMblen);
        }
        if (this.protocol.getServerSession().getServerDefaultCollationIndex() == 0) {
            String collationServer = this.protocol.getServerSession().getServerVariable("collation_server");
            if (collationServer != null) {
                for (int i = 1; i < CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME.length; ++i) {
                    if (!CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[i].equals(collationServer)) continue;
                    this.protocol.getServerSession().setServerDefaultCollationIndex(i);
                    break;
                }
            } else {
                this.protocol.getServerSession().setServerDefaultCollationIndex(45);
            }
        }
    }

    @Override
    public String getProcessHost() {
        try {
            long threadId = this.getThreadId();
            String processHost = this.findProcessHost(threadId);
            if (processHost == null) {
                this.log.logWarn(String.format("Connection id %d not found in \"SHOW PROCESSLIST\", assuming 32-bit overflow, using SELECT CONNECTION_ID() instead", threadId));
                PacketPayload resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, "SELECT CONNECTION_ID()"), false, 0);
                Resultset rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
                LongValueFactory lvf = new LongValueFactory();
                Row r = (Row)rs.getRows().next();
                if (r != null) {
                    threadId = r.getValue(0, lvf);
                    processHost = this.findProcessHost(threadId);
                } else {
                    this.log.logError("No rows returned for statement \"SELECT CONNECTION_ID()\", local connection check will most likely be incorrect");
                }
            }
            if (processHost == null) {
                this.log.logWarn(String.format("Cannot find process listing for connection %d in SHOW PROCESSLIST output, unable to determine if locally connected", threadId));
            }
            return processHost;
        }
        catch (IOException e) {
            throw ExceptionFactory.createException(e.getMessage(), e);
        }
    }

    private String findProcessHost(long threadId) {
        try {
            Row r;
            String processHost = null;
            PacketPayload resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, "SHOW PROCESSLIST"), false, 0);
            Resultset rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
            LongValueFactory lvf = new LongValueFactory();
            StringValueFactory svf = new StringValueFactory(rs.getColumnDefinition().getFields()[2].getEncoding());
            while ((r = (Row)rs.getRows().next()) != null) {
                long id = r.getValue(0, lvf);
                if (threadId != id) continue;
                processHost = r.getValue(2, svf);
                break;
            }
            return processHost;
        }
        catch (IOException e) {
            throw ExceptionFactory.createException(e.getMessage(), e);
        }
    }

    public String queryServerVariable(String varName) {
        try {
            String s;
            PacketPayload resultPacket = this.sendCommand(this.commandBuilder.buildComQuery(null, "SELECT " + varName), false, 0);
            Resultset rs = this.protocol.readAllResults(-1, false, resultPacket, false, null, new ResultsetFactory(Resultset.Type.FORWARD_ONLY, null));
            StringValueFactory svf = new StringValueFactory(rs.getColumnDefinition().getFields()[0].getEncoding());
            Row r = (Row)rs.getRows().next();
            if (r != null && (s = r.getValue(0, svf)) != null) {
                return s;
            }
            return null;
        }
        catch (IOException e) {
            throw ExceptionFactory.createException(e.getMessage(), e);
        }
    }

    public <T extends Resultset> T execSQL(Query callingQuery, String query, int maxRows, PacketPayload packet, boolean streamResults, ProtocolEntityFactory<T> resultSetFactory, String catalog, ColumnDefinition cachedMetadata, boolean isBatch) {
        long queryStartTime = 0L;
        int endOfQueryPacketPosition = 0;
        if (packet != null) {
            endOfQueryPacketPosition = packet.getPosition();
        }
        if (this.gatherPerfMetrics.getValue().booleanValue()) {
            queryStartTime = System.currentTimeMillis();
        }
        this.lastQueryFinishedTime = 0L;
        if (((Boolean)this.autoReconnect.getValue()).booleanValue() && (this.autoCommit || this.autoReconnectForPools.getValue().booleanValue()) && this.needsPing && !isBatch) {
            try {
                this.ping(false, 0);
                this.needsPing = false;
            }
            catch (Exception Ex) {
                this.invokeReconnectListeners();
            }
        }
        try {
            if (packet == null) {
                String encoding = (String)this.characterEncoding.getValue();
                T t = this.protocol.sendQueryString(callingQuery, query, encoding, maxRows, streamResults, catalog, cachedMetadata, this::getProfilerEventHandlerInstanceFunction, resultSetFactory);
                return t;
            }
            T encoding = this.protocol.sendQueryPacket(callingQuery, packet, maxRows, streamResults, catalog, cachedMetadata, this::getProfilerEventHandlerInstanceFunction, resultSetFactory);
            return encoding;
        }
        catch (CJException sqlE) {
            if (this.getPropertySet().getBooleanReadableProperty("dumpQueriesOnException").getValue().booleanValue()) {
                String extractedSql = MysqlaUtils.extractSqlFromPacket(query, packet, endOfQueryPacketPosition, this.getPropertySet().getIntegerReadableProperty("maxQuerySizeToLog").getValue());
                StringBuilder messageBuf = new StringBuilder(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n");
                messageBuf.append(extractedSql);
                messageBuf.append("\n\n");
                sqlE.appendMessage(messageBuf.toString());
            }
            if (((Boolean)this.autoReconnect.getValue()).booleanValue()) {
                if (sqlE instanceof CJCommunicationsException) {
                    this.protocol.getSocketConnection().forceClose();
                }
                this.needsPing = true;
            } else if (sqlE instanceof CJCommunicationsException) {
                this.invokeCleanupListeners(sqlE);
            }
            throw sqlE;
        }
        catch (Throwable ex) {
            if (((Boolean)this.autoReconnect.getValue()).booleanValue()) {
                if (ex instanceof IOException) {
                    this.protocol.getSocketConnection().forceClose();
                } else if (ex instanceof IOException) {
                    this.invokeCleanupListeners(ex);
                }
                this.needsPing = true;
            }
            throw ExceptionFactory.createException(ex.getMessage(), ex, this.exceptionInterceptor);
        }
        finally {
            if (this.maintainTimeStats.getValue().booleanValue()) {
                this.lastQueryFinishedTime = System.currentTimeMillis();
            }
            if (this.gatherPerfMetrics.getValue().booleanValue()) {
                long queryTime = System.currentTimeMillis() - queryStartTime;
                this.registerQueryExecutionTime(queryTime);
            }
        }
    }

    public long getIdleFor() {
        if (this.lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long idleTime = now - this.lastQueryFinishedTime;
        return idleTime;
    }

    public boolean isNeedsPing() {
        return this.needsPing;
    }

    public void setNeedsPing(boolean needsPing) {
        this.needsPing = needsPing;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void ping(boolean checkForClosedConnection, int timeoutMillis) {
        if (checkForClosedConnection) {
            this.checkClosed();
        }
        long pingMillisLifetime = this.getPropertySet().getIntegerReadableProperty("selfDestructOnPingSecondsLifetime").getValue().intValue();
        int pingMaxOperations = this.getPropertySet().getIntegerReadableProperty("selfDestructOnPingMaxOperations").getValue();
        if (pingMillisLifetime > 0L && System.currentTimeMillis() - this.connectionCreationTimeMillis > pingMillisLifetime || pingMaxOperations > 0 && pingMaxOperations <= this.getCommandCount()) {
            this.invokeNormalCloseListeners();
            throw ExceptionFactory.createException(Messages.getString("Connection.exceededConnectionLifetime"), "08S01", 0, false, null, this.exceptionInterceptor);
        }
        this.sendCommand(this.commandBuilder.buildComPing(null), false, timeoutMillis);
    }

    public long getConnectionCreationTimeMillis() {
        return this.connectionCreationTimeMillis;
    }

    public void setConnectionCreationTimeMillis(long connectionCreationTimeMillis) {
        this.connectionCreationTimeMillis = connectionCreationTimeMillis;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void checkClosed() {
        if (this.isClosed) {
            if (this.forceClosedReason != null && this.forceClosedReason.getClass().equals(OperationCancelledException.class)) {
                throw (OperationCancelledException)this.forceClosedReason;
            }
            throw ExceptionFactory.createException(ConnectionIsClosedException.class, Messages.getString("Connection.2"), this.forceClosedReason, this.getExceptionInterceptor());
        }
    }

    public Throwable getForceClosedReason() {
        return this.forceClosedReason;
    }

    public void setForceClosedReason(Throwable forceClosedReason) {
        this.forceClosedReason = forceClosedReason;
    }

    @Override
    public void addListener(Session.SessionEventListener l) {
        this.listeners.addIfAbsent(new WeakReference<Session.SessionEventListener>(l));
    }

    @Override
    public void removeListener(Session.SessionEventListener listener) {
        for (WeakReference<Session.SessionEventListener> wr : this.listeners) {
            Session.SessionEventListener l = (Session.SessionEventListener)wr.get();
            if (l != listener) continue;
            this.listeners.remove(wr);
            break;
        }
    }

    protected void invokeNormalCloseListeners() {
        for (WeakReference<Session.SessionEventListener> wr : this.listeners) {
            Session.SessionEventListener l = (Session.SessionEventListener)wr.get();
            if (l != null) {
                l.handleNormalClose();
                continue;
            }
            this.listeners.remove(wr);
        }
    }

    protected void invokeReconnectListeners() {
        for (WeakReference<Session.SessionEventListener> wr : this.listeners) {
            Session.SessionEventListener l = (Session.SessionEventListener)wr.get();
            if (l != null) {
                l.handleReconnect();
                continue;
            }
            this.listeners.remove(wr);
        }
    }

    public void invokeCleanupListeners(Throwable whyCleanedUp) {
        for (WeakReference<Session.SessionEventListener> wr : this.listeners) {
            Session.SessionEventListener l = (Session.SessionEventListener)wr.get();
            if (l != null) {
                l.handleCleanup(whyCleanedUp);
                continue;
            }
            this.listeners.remove(wr);
        }
    }

    public String getIdentifierQuoteString() {
        return this.protocol != null && this.protocol.getServerSession().useAnsiQuotedIdentifiers() ? "\"" : "`";
    }

    public synchronized Timer getCancelTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = new Timer("MySQL Statement Cancellation Timer", Boolean.TRUE);
        }
        return this.cancelTimer;
    }
}

