/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChartDemo5
extends ApplicationFrame {
    public BarChartDemo5(String string) {
        super(string);
        JPanel jPanel = BarChartDemo5.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        String string = "Prison Population Rates";
        defaultCategoryDataset.addValue(59.0, (Comparable)((Object)string), (Comparable)((Object)"Norway"));
        defaultCategoryDataset.addValue(69.0, (Comparable)((Object)string), (Comparable)((Object)"Switzerland"));
        defaultCategoryDataset.addValue(85.0, (Comparable)((Object)string), (Comparable)((Object)"France"));
        defaultCategoryDataset.addValue(93.0, (Comparable)((Object)string), (Comparable)((Object)"Syria"));
        defaultCategoryDataset.addValue(96.0, (Comparable)((Object)string), (Comparable)((Object)"Germany"));
        defaultCategoryDataset.addValue(111.0, (Comparable)((Object)string), (Comparable)((Object)"China"));
        defaultCategoryDataset.addValue(116.0, (Comparable)((Object)string), (Comparable)((Object)"Australia"));
        defaultCategoryDataset.addValue(121.0, (Comparable)((Object)string), (Comparable)((Object)"Egypt"));
        defaultCategoryDataset.addValue(129.0, (Comparable)((Object)string), (Comparable)((Object)"England & Wales"));
        defaultCategoryDataset.addValue(157.0, (Comparable)((Object)string), (Comparable)((Object)"New Zealand"));
        defaultCategoryDataset.addValue(205.0, (Comparable)((Object)string), (Comparable)((Object)"Chile"));
        defaultCategoryDataset.addValue(229.0, (Comparable)((Object)string), (Comparable)((Object)"Iran"));
        defaultCategoryDataset.addValue(359.0, (Comparable)((Object)string), (Comparable)((Object)"Singapore"));
        defaultCategoryDataset.addValue(404.0, (Comparable)((Object)string), (Comparable)((Object)"South Africa"));
        defaultCategoryDataset.addValue(406.0, (Comparable)((Object)string), (Comparable)((Object)"Ukraine"));
        defaultCategoryDataset.addValue(686.0, (Comparable)((Object)string), (Comparable)((Object)"USA"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Prison Population Rates - Selected Countries", "Country", "Prisoners Per 100,000 National Population", categoryDataset, PlotOrientation.HORIZONTAL, false, true, false);
        jFreeChart.addSubtitle(new TextTitle("Source: http://www.homeoffice.gov.uk/rds/pdfs2/r188.pdf", new Font("Dialog", 2, 10)));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        categoryPlot.setRangePannable(true);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setItemLabelAnchorOffset(9.0);
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator("{0}, {1}) = {2} per 100,000", new DecimalFormat("0")));
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryMargin(0.25);
        categoryAxis.setUpperMargin(0.02);
        categoryAxis.setLowerMargin(0.02);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setUpperMargin(0.1);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = BarChartDemo5.createChart(BarChartDemo5.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        BarChartDemo5 barChartDemo5 = new BarChartDemo5("JFreeChart: BarChartDemo5.java");
        barChartDemo5.pack();
        RefineryUtilities.centerFrameOnScreen(barChartDemo5);
        barChartDemo5.setVisible(true);
    }
}

