/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class CategoryMarkerDemo1
extends ApplicationFrame {
    public CategoryMarkerDemo1(String string) {
        super(string);
        JPanel jPanel = CategoryMarkerDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(21.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(50.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(152.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(184.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(299.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 5"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createLineChart("Category Marker Demo 1", "Category", "Count", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setSeriesShapesVisible(0, true);
        lineAndShapeRenderer.setDrawOutlines(true);
        lineAndShapeRenderer.setUseFillPaint(true);
        lineAndShapeRenderer.setBaseFillPaint(Color.white);
        CategoryMarker categoryMarker = new CategoryMarker((Comparable)((Object)"Category 4"), Color.blue, new BasicStroke(1.0f));
        categoryMarker.setDrawAsLine(true);
        categoryMarker.setLabel("Marker Label");
        categoryMarker.setLabelFont(new Font("Dialog", 0, 11));
        categoryMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        categoryMarker.setLabelOffset(new RectangleInsets(2.0, 5.0, 2.0, 5.0));
        categoryPlot.addDomainMarker(categoryMarker, Layer.BACKGROUND);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = CategoryMarkerDemo1.createChart(CategoryMarkerDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        CategoryMarkerDemo1 categoryMarkerDemo1 = new CategoryMarkerDemo1("JFreeChart: CategoryMarkerDemo1.java");
        categoryMarkerDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(categoryMarkerDemo1);
        categoryMarkerDemo1.setVisible(true);
    }
}

