/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;

public class ChartTiming4
implements ActionListener {
    private boolean finished;
    private float[][] data = new float[2][1440];

    public void run() {
        this.finished = false;
        this.populateData();
        FastScatterPlot fastScatterPlot = new FastScatterPlot(this.data, new NumberAxis("X"), new NumberAxis("Y"));
        JFreeChart jFreeChart = new JFreeChart("Fast Scatter Plot Timing", JFreeChart.DEFAULT_TITLE_FONT, fastScatterPlot, true);
        BufferedImage bufferedImage = new BufferedImage(400, 300, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 400.0, 300.0);
        Timer timer = new Timer(10000, this);
        timer.setRepeats(false);
        int n = 0;
        timer.start();
        while (!this.finished) {
            jFreeChart.draw(graphics2D, double_, null, null);
            System.out.println("Charts drawn..." + n);
            if (this.finished) continue;
            ++n;
        }
        System.out.println("DONE");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.finished = true;
    }

    private void populateData() {
        for (int i = 0; i < this.data[0].length; ++i) {
            float f;
            this.data[0][i] = f = (float)i;
            this.data[1][i] = 100.0f + 2.0f * f + (float)Math.random() * 1440.0f;
        }
    }

    public static void main(String[] stringArray) {
        ChartTiming4 chartTiming4 = new ChartTiming4();
        chartTiming4.run();
    }
}

