/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.CylinderRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.StandardGradientPaintTransformer;

public class CylinderChartDemo1
extends ApplicationFrame {
    public CylinderChartDemo1(String string) {
        super(string);
        JPanel jPanel = CylinderChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Monday"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Tuesday"));
        defaultCategoryDataset.addValue(-7.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Wednesday"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Thursday"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"S1"), (Comparable)((Object)"Friday"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D("Cylinder Chart Demo 1", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRangePannable(true);
        Paint[] paintArray = CylinderChartDemo1.createPaint();
        CustomCylinderRenderer customCylinderRenderer = new CustomCylinderRenderer(paintArray);
        customCylinderRenderer.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        customCylinderRenderer.setBaseOutlinePaint(Color.gray);
        customCylinderRenderer.setBaseOutlineStroke(new BasicStroke(0.3f));
        customCylinderRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        categoryPlot.setRenderer(customCylinderRenderer);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    private static Paint[] createPaint() {
        Paint[] paintArray = new Paint[]{new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.orange, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.magenta, 0.0f, 0.0f, Color.white)};
        return paintArray;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = CylinderChartDemo1.createChart(CylinderChartDemo1.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        CylinderChartDemo1 cylinderChartDemo1 = new CylinderChartDemo1("JFreeChart: CylinderChartDemo1.java");
        cylinderChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(cylinderChartDemo1);
        cylinderChartDemo1.setVisible(true);
    }

    static class CustomCylinderRenderer
    extends CylinderRenderer {
        private Paint[] colors;

        public CustomCylinderRenderer(Paint[] paintArray) {
            this.colors = paintArray;
        }

        @Override
        public Paint getItemPaint(int n, int n2) {
            return this.colors[n2 % this.colors.length];
        }
    }
}

