/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Week;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class DeviationRendererDemo2
extends ApplicationFrame {
    public DeviationRendererDemo2(String string) {
        super(string);
        JPanel jPanel = DeviationRendererDemo2.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static XYDataset createDataset() {
        YIntervalSeries yIntervalSeries = new YIntervalSeries((Comparable)((Object)"Series 1"));
        YIntervalSeries yIntervalSeries2 = new YIntervalSeries((Comparable)((Object)"Series 2"));
        RegularTimePeriod regularTimePeriod = new Week();
        double d = 100.0;
        double d2 = 100.0;
        for (int i = 0; i <= 52; ++i) {
            double d3 = 0.05 * (double)i;
            yIntervalSeries.add(((RegularTimePeriod)regularTimePeriod).getFirstMillisecond(), d, d - d3, d + d3);
            d = d + Math.random() - 0.45;
            double d4 = 0.07 * (double)i;
            yIntervalSeries2.add(((RegularTimePeriod)regularTimePeriod).getFirstMillisecond(), d2, d2 - d4, d2 + d4);
            d2 = d2 + Math.random() - 0.55;
            regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
        }
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries(yIntervalSeries);
        yIntervalSeriesCollection.addSeries(yIntervalSeries2);
        return yIntervalSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Projected Values - Test", "Date", "Index Projection", xYDataset, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setDomainPannable(true);
        xYPlot.setRangePannable(false);
        xYPlot.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setSeriesStroke(0, new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesStroke(0, new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesStroke(1, new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesFillPaint(0, new Color(255, 200, 200));
        deviationRenderer.setSeriesFillPaint(1, new Color(200, 200, 255));
        xYPlot.setRenderer(deviationRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = DeviationRendererDemo2.createChart(DeviationRendererDemo2.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        DeviationRendererDemo2 deviationRendererDemo2 = new DeviationRendererDemo2("JFreeChart: DeviationRendererDemo2.java");
        deviationRendererDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(deviationRendererDemo2);
        deviationRendererDemo2.setVisible(true);
    }
}

