/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DifferenceChartDemo1
extends ApplicationFrame {
    public DifferenceChartDemo1(String string) {
        super(string);
        JPanel jPanel = DifferenceChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Random 1"));
        TimeSeries timeSeries2 = new TimeSeries((Comparable)((Object)"Random 2"));
        double d = 0.0;
        double d2 = 0.0;
        Day day = new Day();
        for (int i = 0; i < 200; ++i) {
            d = d + Math.random() - 0.5;
            d2 = d2 + Math.random() - 0.5;
            timeSeries.add((RegularTimePeriod)day, d);
            timeSeries2.add((RegularTimePeriod)day, d2);
            day = (Day)day.next();
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        return timeSeriesCollection;
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Difference Chart Demo 1", "Time", "Value", xYDataset, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setDomainPannable(true);
        XYDifferenceRenderer xYDifferenceRenderer = new XYDifferenceRenderer(Color.green, Color.red, false);
        xYDifferenceRenderer.setRoundXCoordinates(true);
        xYPlot.setDomainCrosshairLockedOnData(true);
        xYPlot.setRangeCrosshairLockedOnData(true);
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        xYPlot.setRenderer(xYDifferenceRenderer);
        DateAxis dateAxis = new DateAxis("Time");
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        xYPlot.setDomainAxis(dateAxis);
        xYPlot.setForegroundAlpha(0.5f);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = DifferenceChartDemo1.createChart(DifferenceChartDemo1.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        DifferenceChartDemo1 differenceChartDemo1 = new DifferenceChartDemo1("JFreeChart: DifferenceChartDemo1.java");
        differenceChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(differenceChartDemo1);
        differenceChartDemo1.setVisible(true);
    }
}

