/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.DemoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.UnitType;

public class DynamicDataDemo3
extends ApplicationFrame {
    public DynamicDataDemo3(String string) {
        super(string);
        this.setContentPane(DynamicDataDemo3.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new MyDemoPanel();
    }

    public static void main(String[] stringArray) {
        DynamicDataDemo3 dynamicDataDemo3 = new DynamicDataDemo3("JFreeChart: DynamicDataDemo3.java");
        dynamicDataDemo3.pack();
        RefineryUtilities.centerFrameOnScreen(dynamicDataDemo3);
        dynamicDataDemo3.setVisible(true);
    }

    static class MyDemoPanel
    extends DemoPanel
    implements ActionListener {
        public static final int SUBPLOT_COUNT = 3;
        private TimeSeriesCollection[] datasets;
        private double[] lastValue = new double[3];

        public MyDemoPanel() {
            super(new BorderLayout());
            Serializable serializable;
            ValueAxis valueAxis;
            Cloneable cloneable;
            CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot(new DateAxis("Time"));
            this.datasets = new TimeSeriesCollection[3];
            for (int i = 0; i < 3; ++i) {
                this.lastValue[i] = 100.0;
                cloneable = new TimeSeries((Comparable)((Object)("Random " + i)));
                this.datasets[i] = new TimeSeriesCollection((TimeSeries)cloneable);
                valueAxis = new NumberAxis("Y" + i);
                ((NumberAxis)valueAxis).setAutoRangeIncludesZero(false);
                serializable = new XYPlot(this.datasets[i], null, valueAxis, new StandardXYItemRenderer());
                ((Plot)serializable).setBackgroundPaint(Color.lightGray);
                ((XYPlot)serializable).setDomainGridlinePaint(Color.white);
                ((XYPlot)serializable).setRangeGridlinePaint(Color.white);
                combinedDomainXYPlot.add((XYPlot)serializable);
            }
            JFreeChart jFreeChart = new JFreeChart("Dynamic Data Demo 3", combinedDomainXYPlot);
            this.addChart(jFreeChart);
            cloneable = (LegendTitle)jFreeChart.getSubtitle(0);
            ((Title)cloneable).setPosition(RectangleEdge.RIGHT);
            ((AbstractBlock)cloneable).setMargin(new RectangleInsets(UnitType.ABSOLUTE, 0.0, 4.0, 0.0, 4.0));
            jFreeChart.setBorderPaint(Color.black);
            jFreeChart.setBorderVisible(true);
            valueAxis = combinedDomainXYPlot.getDomainAxis();
            valueAxis.setAutoRange(true);
            valueAxis.setFixedAutoRange(20000.0);
            ChartUtilities.applyCurrentTheme(jFreeChart);
            serializable = new ChartPanel(jFreeChart);
            this.add((Component)serializable);
            JPanel jPanel = new JPanel(new FlowLayout());
            for (int i = 0; i < 3; ++i) {
                JButton jButton = new JButton("Series " + i);
                jButton.setActionCommand("ADD_DATA_" + i);
                jButton.addActionListener(this);
                jPanel.add(jButton);
            }
            JButton jButton = new JButton("ALL");
            jButton.setActionCommand("ADD_ALL");
            jButton.addActionListener(this);
            jPanel.add(jButton);
            this.add((Component)jPanel, "South");
            ((JComponent)serializable).setPreferredSize(new Dimension(500, 470));
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < 3; ++i) {
                if (!actionEvent.getActionCommand().endsWith(String.valueOf(i))) continue;
                Millisecond millisecond = new Millisecond();
                System.out.println("Now = " + millisecond.toString());
                this.lastValue[i] = this.lastValue[i] * (0.9 + 0.2 * Math.random());
                this.datasets[i].getSeries(0).add((RegularTimePeriod)new Millisecond(), this.lastValue[i]);
            }
            if (actionEvent.getActionCommand().equals("ADD_ALL")) {
                Millisecond millisecond = new Millisecond();
                System.out.println("Now = " + millisecond.toString());
                for (int i = 0; i < 3; ++i) {
                    this.lastValue[i] = this.lastValue[i] * (0.9 + 0.2 * Math.random());
                    this.datasets[i].getSeries(0).add((RegularTimePeriod)new Millisecond(), this.lastValue[i]);
                }
            }
        }
    }
}

