/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.AbstractCategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ItemLabelDemo2
extends ApplicationFrame {
    public ItemLabelDemo2(String string) {
        super(string);
        JPanel jPanel = ItemLabelDemo2.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(100.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(44.3, (Comparable)((Object)"S1"), (Comparable)((Object)"C2"));
        defaultCategoryDataset.addValue(93.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C3"));
        defaultCategoryDataset.addValue(80.0, (Comparable)((Object)"S2"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(75.1, (Comparable)((Object)"S2"), (Comparable)((Object)"C2"));
        defaultCategoryDataset.addValue(15.1, (Comparable)((Object)"S2"), (Comparable)((Object)"C3"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Item Label Demo 2", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        categoryPlot.setRangePannable(true);
        categoryPlot.setRangeZeroBaselineVisible(true);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setUpperMargin(0.25);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setItemLabelAnchorOffset(7.0);
        barRenderer.setBaseItemLabelGenerator(new LabelGenerator(null));
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = ItemLabelDemo2.createChart(ItemLabelDemo2.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        ItemLabelDemo2 itemLabelDemo2 = new ItemLabelDemo2("JFreeChart: ItemLabelDemo2.java");
        itemLabelDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(itemLabelDemo2);
        itemLabelDemo2.setVisible(true);
    }

    static class LabelGenerator
    extends AbstractCategoryItemLabelGenerator
    implements CategoryItemLabelGenerator {
        private Integer category;
        private NumberFormat formatter = NumberFormat.getPercentInstance();

        public LabelGenerator(int n) {
            this(new Integer(n));
        }

        public LabelGenerator(Integer n) {
            super("", NumberFormat.getInstance());
            this.category = n;
        }

        @Override
        public String generateLabel(CategoryDataset categoryDataset, int n, int n2) {
            Number number;
            String string = null;
            double d = 0.0;
            if (this.category != null) {
                number = categoryDataset.getValue(n, this.category);
                d = number.doubleValue();
            } else {
                d = this.calculateSeriesTotal(categoryDataset, n);
            }
            number = categoryDataset.getValue(n, n2);
            if (number != null) {
                double d2 = number.doubleValue();
                string = number.toString() + " (" + this.formatter.format(d2 / d) + ")";
            }
            return string;
        }

        private double calculateSeriesTotal(CategoryDataset categoryDataset, int n) {
            double d = 0.0;
            for (int i = 0; i < categoryDataset.getColumnCount(); ++i) {
                Number number = categoryDataset.getValue(n, i);
                if (number == null) continue;
                d += number.doubleValue();
            }
            return d;
        }
    }
}

