/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.DataUtilities;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.SortOrder;

public class ParetoChartDemo1
extends ApplicationFrame {
    public ParetoChartDemo1(String string) {
        super(string);
        JPanel jPanel = ParetoChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(550, 270));
        this.setContentPane(jPanel);
    }

    public static JFreeChart createChart(CategoryDataset[] categoryDatasetArray) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("TIOBE Index of Programming Languages", null, "Index Value", categoryDatasetArray[0]);
        jFreeChart.addSubtitle(new TextTitle("As at August 2013"));
        jFreeChart.removeLegend();
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setLowerMargin(0.02);
        categoryAxis.setUpperMargin(0.02);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        NumberAxis numberAxis2 = new NumberAxis("Percent");
        numberAxis2.setNumberFormatOverride(NumberFormat.getPercentInstance());
        categoryPlot.setRangeAxis(1, numberAxis2);
        categoryPlot.setDataset(1, categoryDatasetArray[1]);
        categoryPlot.setRenderer(1, lineAndShapeRenderer);
        categoryPlot.mapDatasetToRangeAxis(1, 1);
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        TextTitle textTitle = new TextTitle("http://www.tiobe.com/index.php/content/paperinfo/tpci/index.html", new Font("Monospaced", 0, 10));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        textTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        jFreeChart.addSubtitle(textTitle);
        return jFreeChart;
    }

    public static CategoryDataset[] createDatasets() {
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"C"), 15.974);
        defaultKeyedValues.addValue((Comparable)((Object)"C++"), 9.371);
        defaultKeyedValues.addValue((Comparable)((Object)"C#"), 6.117);
        defaultKeyedValues.addValue((Comparable)((Object)"Java"), 15.978);
        defaultKeyedValues.addValue((Comparable)((Object)"Javascript"), 2.093);
        defaultKeyedValues.addValue((Comparable)((Object)"Obj-C"), 8.082);
        defaultKeyedValues.addValue((Comparable)((Object)"PHP"), 6.694);
        defaultKeyedValues.addValue((Comparable)((Object)"Python"), 3.603);
        defaultKeyedValues.addValue((Comparable)((Object)"Ruby"), 2.067);
        defaultKeyedValues.addValue((Comparable)((Object)"VB"), 3.873);
        defaultKeyedValues.sortByValues(SortOrder.DESCENDING);
        KeyedValues keyedValues = DataUtilities.getCumulativePercentages(defaultKeyedValues);
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset((Comparable)((Object)"Languages"), defaultKeyedValues);
        CategoryDataset categoryDataset2 = DatasetUtilities.createCategoryDataset((Comparable)((Object)"Cumulative"), keyedValues);
        return new CategoryDataset[]{categoryDataset, categoryDataset2};
    }

    public static JPanel createDemoPanel() {
        CategoryDataset[] categoryDatasetArray = ParetoChartDemo1.createDatasets();
        JFreeChart jFreeChart = ParetoChartDemo1.createChart(categoryDatasetArray);
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        ParetoChartDemo1 paretoChartDemo1 = new ParetoChartDemo1("JFreeChart: ParetoChartDemo1.java");
        paretoChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(paretoChartDemo1);
        paretoChartDemo1.setVisible(true);
    }
}

