/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.DemoPanel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PieChartDemo6
extends ApplicationFrame {
    public PieChartDemo6(String string) {
        super(string);
        JPanel jPanel = PieChartDemo6.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(800, 600));
        this.setContentPane(jPanel);
    }

    private static PieDataset createDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"S1"), 7.0);
        defaultPieDataset.setValue((Comparable)((Object)"S2"), null);
        defaultPieDataset.setValue((Comparable)((Object)"S3"), 0.0);
        defaultPieDataset.setValue((Comparable)((Object)"S4"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"S5"), -1.0);
        return defaultPieDataset;
    }

    private static JFreeChart createChart(String string, PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createPieChart(string, pieDataset, true, true, false);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0} = {1}"));
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        DemoPanel demoPanel = new DemoPanel(new GridLayout(2, 2));
        JFreeChart jFreeChart = PieChartDemo6.createChart("Pie Chart 1", PieChartDemo6.createDataset());
        Font font = new Font("Dialog", 0, 12);
        jFreeChart.addSubtitle(new TextTitle("Ignore nulls: false; Ignore zeros: false;", font));
        JFreeChart jFreeChart2 = PieChartDemo6.createChart("Pie Chart 2", PieChartDemo6.createDataset());
        jFreeChart2.addSubtitle(new TextTitle("Ignore nulls: true; Ignore zeros: false;", font));
        PiePlot piePlot = (PiePlot)jFreeChart2.getPlot();
        piePlot.setIgnoreNullValues(true);
        piePlot.setIgnoreZeroValues(false);
        JFreeChart jFreeChart3 = PieChartDemo6.createChart("Pie Chart 3", PieChartDemo6.createDataset());
        jFreeChart3.addSubtitle(new TextTitle("Ignore nulls: false; Ignore zeros: true;", font));
        PiePlot piePlot2 = (PiePlot)jFreeChart3.getPlot();
        piePlot2.setIgnoreNullValues(false);
        piePlot2.setIgnoreZeroValues(true);
        JFreeChart jFreeChart4 = PieChartDemo6.createChart("Pie Chart 4", PieChartDemo6.createDataset());
        jFreeChart4.addSubtitle(new TextTitle("Ignore nulls: true; Ignore zeros: true;", font));
        PiePlot piePlot3 = (PiePlot)jFreeChart4.getPlot();
        piePlot3.setIgnoreNullValues(true);
        piePlot3.setIgnoreZeroValues(true);
        demoPanel.add(new ChartPanel(jFreeChart));
        demoPanel.add(new ChartPanel(jFreeChart2));
        demoPanel.add(new ChartPanel(jFreeChart3));
        demoPanel.add(new ChartPanel(jFreeChart4));
        demoPanel.addChart(jFreeChart);
        demoPanel.addChart(jFreeChart2);
        demoPanel.addChart(jFreeChart3);
        demoPanel.addChart(jFreeChart4);
        return demoPanel;
    }

    public static void main(String[] stringArray) {
        PieChartDemo6 pieChartDemo6 = new PieChartDemo6("JFreeChart: PieChartDemo6.java");
        pieChartDemo6.pack();
        RefineryUtilities.centerFrameOnScreen(pieChartDemo6);
        pieChartDemo6.setVisible(true);
    }
}

