/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.DemoPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYDataImageAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.PublicCloneable;

public class PlotOrientationDemo1
extends ApplicationFrame {
    private static int CHART_COUNT = 8;

    public PlotOrientationDemo1(String string) {
        super(string);
        this.setContentPane(PlotOrientationDemo1.createDemoPanel());
    }

    private static XYDataset createDataset(int n) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)("Series " + (n + 1))));
        xYSeries.add(-10.0, -5.0);
        xYSeries.add(10.0, 5.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        return xYSeriesCollection;
    }

    private static JFreeChart createChart(int n, XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Chart " + (n + 1), "X", "Y", xYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setBaseShapesVisible(true);
        xYLineAndShapeRenderer.setBaseShapesFilled(true);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxis valueAxis2 = xYPlot.getRangeAxis();
        valueAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        return new MyDemoPanel();
    }

    public static void main(String[] stringArray) {
        PlotOrientationDemo1 plotOrientationDemo1 = new PlotOrientationDemo1("JFreeChart: PlotOrientationDemo1.java");
        plotOrientationDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(plotOrientationDemo1);
        plotOrientationDemo1.setVisible(true);
    }

    static class MyDemoPanel
    extends DemoPanel {
        private XYDataset[] datasets = new XYDataset[PlotOrientationDemo1.access$000()];
        private JFreeChart[] charts = new JFreeChart[PlotOrientationDemo1.access$000()];
        private ChartPanel[] panels = new ChartPanel[PlotOrientationDemo1.access$000()];

        public MyDemoPanel() {
            super(new GridLayout(2, 4));
            PublicCloneable publicCloneable;
            PublicCloneable publicCloneable2;
            PublicCloneable publicCloneable3;
            XYPlot xYPlot;
            for (int i = 0; i < CHART_COUNT; ++i) {
                this.datasets[i] = PlotOrientationDemo1.createDataset(i);
                this.charts[i] = PlotOrientationDemo1.createChart(i, this.datasets[i]);
                xYPlot = (XYPlot)this.charts[i].getPlot();
                xYPlot.setDomainPannable(true);
                xYPlot.setRangePannable(true);
                publicCloneable3 = new XYShapeAnnotation(new Rectangle2D.Double(-2.0, -3.0, 1.0, 4.0), new BasicStroke(1.0f), Color.blue, Color.yellow);
                publicCloneable2 = new XYLineAnnotation(0.0, -5.0, 10.0, -5.0);
                publicCloneable = new XYDataImageAnnotation(JFreeChart.INFO.getLogo(), 5.0, 2.0, 6.0, 4.0, true);
                xYPlot.addAnnotation((XYAnnotation)((Object)publicCloneable3));
                xYPlot.addAnnotation((XYAnnotation)((Object)publicCloneable2));
                xYPlot.addAnnotation((XYAnnotation)((Object)publicCloneable));
                xYPlot.setQuadrantPaint(0, new Color(230, 230, 255));
                xYPlot.setQuadrantPaint(1, new Color(230, 255, 230));
                xYPlot.setQuadrantPaint(2, new Color(255, 230, 230));
                xYPlot.setQuadrantPaint(3, new Color(255, 230, 255));
                this.addChart(this.charts[i]);
                this.panels[i] = new ChartPanel(this.charts[i]);
                this.panels[i].setMouseWheelEnabled(true);
            }
            XYPlot xYPlot2 = (XYPlot)this.charts[1].getPlot();
            xYPlot = (XYPlot)this.charts[2].getPlot();
            publicCloneable3 = (XYPlot)this.charts[3].getPlot();
            publicCloneable2 = (XYPlot)this.charts[4].getPlot();
            publicCloneable = (XYPlot)this.charts[5].getPlot();
            XYPlot xYPlot3 = (XYPlot)this.charts[6].getPlot();
            XYPlot xYPlot4 = (XYPlot)this.charts[7].getPlot();
            xYPlot2.getDomainAxis().setInverted(true);
            xYPlot.getRangeAxis().setInverted(true);
            ((XYPlot)publicCloneable3).getDomainAxis().setInverted(true);
            ((XYPlot)publicCloneable3).getRangeAxis().setInverted(true);
            ((XYPlot)publicCloneable).getDomainAxis().setInverted(true);
            xYPlot3.getRangeAxis().setInverted(true);
            ((XYPlot)publicCloneable2).getDomainAxis().setInverted(true);
            ((XYPlot)publicCloneable2).getRangeAxis().setInverted(true);
            ((XYPlot)publicCloneable2).setOrientation(PlotOrientation.HORIZONTAL);
            ((XYPlot)publicCloneable).setOrientation(PlotOrientation.HORIZONTAL);
            xYPlot3.setOrientation(PlotOrientation.HORIZONTAL);
            xYPlot4.setOrientation(PlotOrientation.HORIZONTAL);
            this.add(this.panels[0]);
            this.add(this.panels[1]);
            this.add(this.panels[4]);
            this.add(this.panels[5]);
            this.add(this.panels[2]);
            this.add(this.panels[3]);
            this.add(this.panels[6]);
            this.add(this.panels[7]);
            this.setPreferredSize(new Dimension(800, 600));
        }
    }
}

