/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.PublicCloneable;

public class TimeSeriesDemo15
extends ApplicationFrame {
    public TimeSeriesDemo15(String string) {
        super(string);
        JPanel jPanel = TimeSeriesDemo15.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        PublicCloneable publicCloneable;
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Bug Report Submissions for Java", "Date", "Evaluation ID", xYDataset, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            publicCloneable = (XYLineAndShapeRenderer)xYItemRenderer;
            ((XYLineAndShapeRenderer)publicCloneable).setBaseShapesVisible(true);
            ((XYLineAndShapeRenderer)publicCloneable).setBaseShapesFilled(true);
            ((XYLineAndShapeRenderer)publicCloneable).setUseFillPaint(true);
            ((AbstractRenderer)((Object)publicCloneable)).setBaseFillPaint(Color.white);
        }
        publicCloneable = (DateAxis)xYPlot.getDomainAxis();
        ((DateAxis)publicCloneable).setDateFormatOverride(new SimpleDateFormat("MMM-yyyy"));
        return jFreeChart;
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Bugs"));
        timeSeries.add((RegularTimePeriod)new Day(27, 6, 2005), 478474.0);
        timeSeries.add((RegularTimePeriod)new Day(24, 1, 2006), 633804.0);
        timeSeries.add((RegularTimePeriod)new Day(28, 4, 2006), 694096.0);
        timeSeries.add((RegularTimePeriod)new Day(12, 5, 2006), 704680.0);
        timeSeries.add((RegularTimePeriod)new Day(16, 5, 2006), 709599.0);
        timeSeries.add((RegularTimePeriod)new Day(21, 6, 2006), 734754.0);
        timeSeries.add((RegularTimePeriod)new Day(27, 7, 2006), 760008.0);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = TimeSeriesDemo15.createChart(TimeSeriesDemo15.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo15 timeSeriesDemo15 = new TimeSeriesDemo15("Time Series Demo 15");
        timeSeriesDemo15.pack();
        RefineryUtilities.centerFrameOnScreen(timeSeriesDemo15);
        timeSeriesDemo15.setVisible(true);
    }
}

