/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.SamplingXYLineRenderer;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo5
extends ApplicationFrame {
    public TimeSeriesDemo5(String string) {
        super(string);
        JPanel jPanel = TimeSeriesDemo5.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Random Data"));
        Day day = new Day(1, 1, 1990);
        double d = 100.0;
        for (int i = 0; i < 100000; ++i) {
            try {
                d = d + Math.random() - 0.5;
                timeSeries.add((RegularTimePeriod)day, new Double(d));
                day = (Day)day.next();
                continue;
            }
            catch (SeriesException seriesException) {
                System.err.println("Error adding to series");
            }
        }
        return new TimeSeriesCollection(timeSeries);
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Test", "Day", "Value", xYDataset, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setDomainPannable(true);
        SamplingXYLineRenderer samplingXYLineRenderer = new SamplingXYLineRenderer();
        xYPlot.setRenderer(samplingXYLineRenderer);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = TimeSeriesDemo5.createChart(TimeSeriesDemo5.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        String string = "\u20a2\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa";
        TimeSeriesDemo5 timeSeriesDemo5 = new TimeSeriesDemo5(string);
        timeSeriesDemo5.pack();
        RefineryUtilities.positionFrameRandomly(timeSeriesDemo5);
        timeSeriesDemo5.setVisible(true);
    }
}

