/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYBarChartDemo4
extends ApplicationFrame {
    public XYBarChartDemo4(String string) {
        super(string);
        JPanel jPanel = XYBarChartDemo4.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYBarChart("XYBarChartDemo4", "X", false, "Y", intervalXYDataset, PlotOrientation.VERTICAL, true, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYBarRenderer xYBarRenderer = (XYBarRenderer)xYPlot.getRenderer();
        xYBarRenderer.setDrawBarOutline(false);
        return jFreeChart;
    }

    private static IntervalXYDataset createDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 5.0);
        xYSeries.add(2.0, 70.8);
        xYSeries.add(3.0, 48.3);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        return new XYBarDataset(xYSeriesCollection, 0.9);
    }

    public static JPanel createDemoPanel() {
        return new ChartPanel(XYBarChartDemo4.createChart(XYBarChartDemo4.createDataset()));
    }

    public static void main(String[] stringArray) {
        XYBarChartDemo4 xYBarChartDemo4 = new XYBarChartDemo4("XY Bar Chart Demo 4");
        xYBarChartDemo4.pack();
        RefineryUtilities.centerFrameOnScreen(xYBarChartDemo4);
        xYBarChartDemo4.setVisible(true);
    }
}

