/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class XYBlockChartDemo2
extends ApplicationFrame {
    public XYBlockChartDemo2(String string) {
        super(string);
        JPanel jPanel = XYBlockChartDemo2.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(XYZDataset xYZDataset) {
        DateAxis dateAxis = new DateAxis("Date");
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        dateAxis.setInverted(true);
        NumberAxis numberAxis = new NumberAxis("Hour");
        numberAxis.setUpperMargin(0.0);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYBlockRenderer xYBlockRenderer = new XYBlockRenderer();
        xYBlockRenderer.setBlockWidth(8.64E7);
        xYBlockRenderer.setBlockAnchor(RectangleAnchor.BOTTOM_LEFT);
        LookupPaintScale lookupPaintScale = new LookupPaintScale(0.5, 4.5, Color.white);
        lookupPaintScale.add(0.5, (Paint)Color.red);
        lookupPaintScale.add(1.5, (Paint)Color.green);
        lookupPaintScale.add(2.5, (Paint)Color.blue);
        lookupPaintScale.add(3.5, (Paint)Color.yellow);
        xYBlockRenderer.setPaintScale(lookupPaintScale);
        XYPlot xYPlot = new XYPlot(xYZDataset, dateAxis, numberAxis, xYBlockRenderer);
        xYPlot.setOrientation(PlotOrientation.HORIZONTAL);
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        JFreeChart jFreeChart = new JFreeChart("XYBlockChartDemo2", xYPlot);
        jFreeChart.removeLegend();
        jFreeChart.setBackgroundPaint(Color.white);
        SymbolAxis symbolAxis = new SymbolAxis(null, new String[]{"", "Unavailable", "Free", "Group 1", "Group 2"});
        symbolAxis.setRange(0.5, 4.5);
        symbolAxis.setPlot(new PiePlot());
        symbolAxis.setGridBandsVisible(false);
        PaintScaleLegend paintScaleLegend = new PaintScaleLegend(lookupPaintScale, symbolAxis);
        paintScaleLegend.setMargin(new RectangleInsets(3.0, 10.0, 3.0, 10.0));
        paintScaleLegend.setPosition(RectangleEdge.BOTTOM);
        paintScaleLegend.setAxisOffset(5.0);
        jFreeChart.addSubtitle(paintScaleLegend);
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    private static XYZDataset createDataset() {
        double[] dArray = new double[2400];
        double[] dArray2 = new double[2400];
        double[] dArray3 = new double[2400];
        RegularTimePeriod regularTimePeriod = new Day();
        for (int i = 0; i < 100; ++i) {
            double d = 1.0;
            for (int j = 0; j < 24; ++j) {
                if (Math.random() < 0.1) {
                    d = Math.random() * 4.0;
                }
                dArray[i * 24 + j] = regularTimePeriod.getFirstMillisecond();
                dArray2[i * 24 + j] = j;
                dArray3[i * 24 + j] = d;
            }
            regularTimePeriod = regularTimePeriod.next();
        }
        DefaultXYZDataset defaultXYZDataset = new DefaultXYZDataset();
        defaultXYZDataset.addSeries((Comparable)((Object)"Series 1"), new double[][]{dArray, dArray2, dArray3});
        return defaultXYZDataset;
    }

    public static JPanel createDemoPanel() {
        return new ChartPanel(XYBlockChartDemo2.createChart(XYBlockChartDemo2.createDataset()));
    }

    public static void main(String[] stringArray) {
        XYBlockChartDemo2 xYBlockChartDemo2 = new XYBlockChartDemo2("Block Chart Demo 2");
        xYBlockChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(xYBlockChartDemo2);
        xYBlockChartDemo2.setVisible(true);
    }
}

