/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.gantt.XYTaskDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYTaskDatasetDemo1
extends ApplicationFrame {
    public XYTaskDatasetDemo1(String string) {
        super(string);
        JPanel jPanel = XYTaskDatasetDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYBarChart("XYTaskDatasetDemo1", "Resource", false, "Timing", intervalXYDataset, PlotOrientation.HORIZONTAL, true, false, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setRangePannable(true);
        SymbolAxis symbolAxis = new SymbolAxis("Series", new String[]{"Team A", "Team B", "Team C", "Team D"});
        symbolAxis.setGridBandsVisible(false);
        xYPlot.setDomainAxis(symbolAxis);
        XYBarRenderer xYBarRenderer = (XYBarRenderer)xYPlot.getRenderer();
        xYBarRenderer.setUseYInterval(true);
        xYPlot.setRangeAxis(new DateAxis("Timing"));
        ChartUtilities.applyCurrentTheme(jFreeChart);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = XYTaskDatasetDemo1.createChart(XYTaskDatasetDemo1.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    private static IntervalXYDataset createDataset() {
        return new XYTaskDataset(XYTaskDatasetDemo1.createTasks());
    }

    private static TaskSeriesCollection createTasks() {
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        TaskSeries taskSeries = new TaskSeries("Team A");
        taskSeries.add(new Task("T1a", new Hour(11, new Day())));
        taskSeries.add(new Task("T1b", new Hour(14, new Day())));
        taskSeries.add(new Task("T1c", new Hour(16, new Day())));
        TaskSeries taskSeries2 = new TaskSeries("Team B");
        taskSeries2.add(new Task("T2a", new Hour(13, new Day())));
        taskSeries2.add(new Task("T2b", new Hour(19, new Day())));
        taskSeries2.add(new Task("T2c", new Hour(21, new Day())));
        TaskSeries taskSeries3 = new TaskSeries("Team C");
        taskSeries3.add(new Task("T3a", new Hour(13, new Day())));
        taskSeries3.add(new Task("T3b", new Hour(19, new Day())));
        taskSeries3.add(new Task("T3c", new Hour(21, new Day())));
        TaskSeries taskSeries4 = new TaskSeries("Team D");
        taskSeries4.add(new Task("T4a", new Day()));
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        taskSeriesCollection.add(taskSeries3);
        taskSeriesCollection.add(taskSeries4);
        return taskSeriesCollection;
    }

    public static void main(String[] stringArray) {
        XYTaskDatasetDemo1 xYTaskDatasetDemo1 = new XYTaskDatasetDemo1("JFreeChart : XYTaskDatasetDemo1.java");
        xYTaskDatasetDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(xYTaskDatasetDemo1);
        xYTaskDatasetDemo1.setVisible(true);
    }
}

