/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LibCString {
    protected LibCString() {
        throw new UnsupportedOperationException();
    }

    public static native long nmemset(long var0, int var2, long var3);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") ByteBuffer dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)dest.remaining());
    }

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") ShortBuffer dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 1));
    }

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") IntBuffer dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 2));
    }

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") LongBuffer dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 3));
    }

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") FloatBuffer dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 2));
    }

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") DoubleBuffer dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)(dest.remaining() << 3));
    }

    public static native long nmemcpy(long var0, long var2, long var4);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") ByteBuffer dest, @NativeType(value="const void *") ByteBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)dest.remaining());
    }

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") ShortBuffer dest, @NativeType(value="const void *") ShortBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 1));
    }

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") IntBuffer dest, @NativeType(value="const void *") IntBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 2));
    }

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") LongBuffer dest, @NativeType(value="const void *") LongBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 3));
    }

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") FloatBuffer dest, @NativeType(value="const void *") FloatBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 2));
    }

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") DoubleBuffer dest, @NativeType(value="const void *") DoubleBuffer src) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)(src.remaining() << 3));
    }

    public static native long nmemset(byte[] var0, int var1, long var2);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") byte[] dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 0));
    }

    public static native long nmemset(short[] var0, int var1, long var2);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") short[] dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 1));
    }

    public static native long nmemset(int[] var0, int var1, long var2);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") int[] dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 2));
    }

    public static native long nmemset(long[] var0, int var1, long var2);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") long[] dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 3));
    }

    public static native long nmemset(float[] var0, int var1, long var2);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") float[] dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 2));
    }

    public static native long nmemset(double[] var0, int var1, long var2);

    @NativeType(value="void *")
    public static long memset(@NativeType(value="void *") double[] dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(dest, c, (long)(dest.length << 3));
    }

    public static native long nmemcpy(byte[] var0, byte[] var1, long var2);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") byte[] dest, @NativeType(value="const void *") byte[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 0));
    }

    public static native long nmemcpy(short[] var0, short[] var1, long var2);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") short[] dest, @NativeType(value="const void *") short[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 1));
    }

    public static native long nmemcpy(int[] var0, int[] var1, long var2);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") int[] dest, @NativeType(value="const void *") int[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 2));
    }

    public static native long nmemcpy(long[] var0, long[] var1, long var2);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") long[] dest, @NativeType(value="const void *") long[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 3));
    }

    public static native long nmemcpy(float[] var0, float[] var1, long var2);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") float[] dest, @NativeType(value="const void *") float[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 2));
    }

    public static native long nmemcpy(double[] var0, double[] var1, long var2);

    @NativeType(value="void *")
    public static long memcpy(@NativeType(value="void *") double[] dest, @NativeType(value="const void *") double[] src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.length);
        }
        return LibCString.nmemcpy(dest, src, (long)(dest.length << 3));
    }

    @NativeType(value="void *")
    public static <T extends CustomBuffer<T>> long memset(@NativeType(value="void *") T dest, @NativeType(value="int") int c) {
        return LibCString.nmemset(MemoryUtil.memAddress(dest), c, (long)dest.remaining() * (long)dest.sizeof());
    }

    @NativeType(value="void *")
    public static <T extends CustomBuffer<T>> long memcpy(@NativeType(value="void *") T dest, @NativeType(value="const void *") T src) {
        if (Checks.CHECKS) {
            Checks.check(src, dest.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(dest), MemoryUtil.memAddress(src), (long)src.remaining() * (long)src.sizeof());
    }

    static {
        Library.initialize();
    }
}

