/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import javax.swing.JFrame;
import javax.swing.JLabel;
import orthostereogram.CuedJLabel;
import orthostereogram.OrthoStereogram;
import orthostereogram.WavSoundThread;

public class AccommodationJob
extends JFrame
implements WindowListener,
MouseMotionListener,
KeyListener {
    Cursor transparentCursor;
    CuedJLabel[] cue;
    int itemSize = 9;
    private static WavSoundThread sndGood = new WavSoundThread(1);
    private static WavSoundThread sndBad = new WavSoundThread(0);
    JLabel label_1;

    public AccommodationJob(int itemSize) {
        this.itemSize = itemSize;
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.setDefaultCloseOperation(2);
        this.setLayout(null);
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.WHITE);
        this.setExtendedState(6);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.label_1 = new JLabel("Taille : " + String.valueOf(itemSize) + " (ctrl +/- to change)");
        this.label_1.setBounds(10, 10, 180, 30);
        this.getContentPane().add(this.label_1);
    }

    public void setAppearence() {
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addWindowListener(this);
    }

    public void hideCursor() {
        this.setCursor(this.transparentCursor);
    }

    private void resizeAllCues(int size) {
        for (int i = 0; i < this.cue.length; ++i) {
            this.cue[i].resize(size);
        }
        this.label_1.setText("Taille : " + String.valueOf(size) + " (ctrl +/- to change)");
    }

    @Override
    public void windowOpened(WindowEvent e) {
        OrthoStereogram.newController.setEnabled(false);
        this.hideCursor();
        this.cue = new CuedJLabel[5];
        for (int i = 0; i < 5; ++i) {
            this.cue[i] = new CuedJLabel(this.itemSize);
            this.cue[i].setBounds(this.getContentPane().getWidth() / 2 - this.cue[i].getWidth() * 4 + this.cue[i].getWidth() * 2 * i, this.getContentPane().getHeight() / 2 - this.cue[i].getHeight() / 2, 35, 35);
            this.getContentPane().add(this.cue[i]);
            this.cue[i].setVisible(true);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        OrthoStereogram.newController.setEnabled(true);
        OrthoStereogram.newController.setVisible(true);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        if (keyCode == 27) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
        if ((keyCode == 109 | keyCode == 54) & ke.isControlDown() & !ke.isShiftDown()) {
            if (this.itemSize > 3) {
                this.resizeAllCues(--this.itemSize);
            }
        } else if (keyCode == 107 & ke.isControlDown() & !ke.isShiftDown()) {
            if (this.itemSize < 12) {
                this.resizeAllCues(++this.itemSize);
            }
        } else if (keyCode == 61 & ke.isControlDown() & ke.isShiftDown()) {
            if (this.itemSize < 12) {
                this.resizeAllCues(++this.itemSize);
            }
        } else if (keyCode == 38 | keyCode == 40 | keyCode == 37 | keyCode == 39) {
            int index;
            for (index = 0; index < 5 && !this.cue[index].isVisible(); ++index) {
            }
            if (index <= 4) {
                if (this.cue[index].check(keyCode)) {
                    sndGood.run();
                } else {
                    sndBad.run();
                }
            }
            if (index == 4) {
                for (int i = 0; i < 5; ++i) {
                    this.cue[i].alea();
                    this.cue[i].setVisible(true);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

