/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.image.BufferedImage;

public class Anaglyph {
    public static void createStereoscopicCombinedImage(BufferedImage left, BufferedImage right, BufferedImage combined) {
        int width = left.getWidth();
        int height = left.getHeight();
        int[] leftRGB = new int[3];
        int[] rightRGB = new int[3];
        int[] combinedRGB = new int[3];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                left.getRaster().getPixel(x, y, leftRGB);
                right.getRaster().getPixel(x, y, rightRGB);
                Anaglyph.convertToGrayscale(leftRGB);
                Anaglyph.convertToGrayscale(rightRGB);
                combinedRGB[0] = leftRGB[0];
                combinedRGB[1] = rightRGB[1];
                combinedRGB[2] = rightRGB[2];
                combined.getRaster().setPixel(x, y, combinedRGB);
            }
        }
    }

    public static void createStereoscopicCombinedImage(BufferedImage left, BufferedImage right, BufferedImage combined, int deltaX) {
        int y;
        int x;
        if (deltaX < 0) {
            BufferedImage tmp = left;
            left = right;
            right = tmp;
            deltaX = -deltaX;
        }
        int width = left.getWidth();
        int height = left.getHeight();
        int[] leftRGB = new int[3];
        int[] rightRGB = new int[3];
        int[] combinedRGB = new int[3];
        rightRGB[2] = 255;
        rightRGB[1] = 255;
        rightRGB[0] = 255;
        Anaglyph.convertToGrayscale(rightRGB);
        combinedRGB[1] = rightRGB[1];
        combinedRGB[2] = rightRGB[2];
        for (x = 0; x < deltaX; ++x) {
            for (y = 0; y < height; ++y) {
                if (x >= width) {
                    combined.getRaster().setPixel(x, y, rightRGB);
                    continue;
                }
                left.getRaster().getPixel(x, y, leftRGB);
                Anaglyph.convertToGrayscale(leftRGB);
                combinedRGB[0] = leftRGB[0];
                combined.getRaster().setPixel(x, y, combinedRGB);
            }
        }
        leftRGB[2] = 255;
        leftRGB[1] = 255;
        leftRGB[0] = 255;
        Anaglyph.convertToGrayscale(leftRGB);
        combinedRGB[0] = leftRGB[0];
        for (x = 0; x < deltaX; ++x) {
            for (y = 0; y < height; ++y) {
                if (x >= width) {
                    combined.getRaster().setPixel(width + deltaX - x - 1, y, leftRGB);
                    continue;
                }
                right.getRaster().getPixel(width - x - 1, y, rightRGB);
                Anaglyph.convertToGrayscale(rightRGB);
                combinedRGB[1] = rightRGB[1];
                combinedRGB[2] = rightRGB[2];
                combined.getRaster().setPixel(width + deltaX - x - 1, y, combinedRGB);
            }
        }
        for (x = 0; x < width - deltaX; ++x) {
            for (y = 0; y < height; ++y) {
                left.getRaster().getPixel(x + deltaX, y, leftRGB);
                right.getRaster().getPixel(x, y, rightRGB);
                Anaglyph.convertToGrayscale(leftRGB);
                Anaglyph.convertToGrayscale(rightRGB);
                combinedRGB[0] = leftRGB[0];
                combinedRGB[1] = rightRGB[1];
                combinedRGB[2] = rightRGB[2];
                combined.getRaster().setPixel(deltaX + x, y, combinedRGB);
            }
        }
    }

    public static void createStereoscopicRedImage(BufferedImage left) {
        int width = left.getWidth();
        int height = left.getHeight();
        int[] leftRGB = new int[3];
        int[] rightRGB = new int[3];
        int[] combinedRGB = new int[3];
        rightRGB[2] = 255;
        rightRGB[1] = 255;
        rightRGB[0] = 255;
        Anaglyph.convertToGrayscale(rightRGB);
        combinedRGB[1] = rightRGB[1];
        combinedRGB[2] = rightRGB[2];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                left.getRaster().getPixel(x, y, leftRGB);
                Anaglyph.convertToGrayscale(leftRGB);
                combinedRGB[0] = leftRGB[0];
                left.getRaster().setPixel(x, y, combinedRGB);
            }
        }
    }

    public static void createStereoscopicBlueImage(BufferedImage right) {
        int width = right.getWidth();
        int height = right.getHeight();
        int[] leftRGB = new int[3];
        int[] rightRGB = new int[3];
        int[] combinedRGB = new int[3];
        leftRGB[2] = 255;
        leftRGB[1] = 255;
        leftRGB[0] = 255;
        Anaglyph.convertToGrayscale(leftRGB);
        combinedRGB[0] = leftRGB[0];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                right.getRaster().getPixel(x, y, rightRGB);
                Anaglyph.convertToGrayscale(rightRGB);
                combinedRGB[1] = rightRGB[1];
                combinedRGB[2] = rightRGB[2];
                right.getRaster().setPixel(x, y, combinedRGB);
            }
        }
    }

    private static void convertToGrayscale(int[] rgb) {
        int m;
        rgb[1] = rgb[2] = (m = (rgb[0] + rgb[1] + rgb[2]) / 3);
        rgb[0] = rgb[2];
    }
}

