/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import orthostereogram.CSVDatas;
import orthostereogram.Eye;
import orthostereogram.NewController;
import orthostereogram.OrthoStereogram;
import orthostereogram.ResetStereogram;
import orthostereogram.WavSoundThread;

public class DoubleStereogram
extends JFrame
implements WindowListener,
MouseMotionListener,
MouseListener,
KeyListener {
    Cursor transparentCursor;
    int size;
    int clue;
    SecureRandom securRand = new SecureRandom();
    private static int game;
    public static final int GAME_SIMPLE = 0;
    public static final int GAME_DOUBLE = 1;
    public static final int GAME_2PLAYERS = 2;
    JLabel infosHLabel;
    JLabel info;
    JLabel infosMax;
    private double obtainedMax = 0.0;
    private double obtainedMin = 0.0;
    static Eye OD;
    static Eye OG;
    final ScheduledThreadPoolExecutor executor;
    ScheduledFuture<?> scheduledFuture;
    private static int timeOut;
    boolean resizingIsActive = false;
    boolean keypressedIsActive = false;
    private double verticalMin;
    private double verticalMax;
    private double verticalStep;
    private double currentVerticalValue;
    private int workingDistance;
    private double stepC;
    private double stepD;
    private double step;
    private double maxRequired;
    private double minRequired;
    private double currentVergenceValue;
    private static int disparity;
    private static int typeExercice;
    static double currentConvergenceValue;
    static double currentDivergenceValue;
    private static int previousBadAnswer;
    JLabel[] trophy;
    int NB_TROPHY = 8;
    int trophyNumber = 0;
    private static int previous_trophyNumber;
    private static boolean alternate;
    private static boolean jump;
    public static final int CONVERGENCE_UP = 2;
    public static final int CONVERGENCE_DOWN = 1;
    public static final int DIVERGENCE_UP = -1;
    public static final int DIVERGENCE_DOWN = -2;
    private static int currentDirectionOfWork;
    public static final int EXO_CD_PROG = 0;
    public static final int EXO_C_PROG = 1;
    public static final int EXO_D_PROG = 2;
    public static final int EXO_CD_ALTER = 3;
    public static final int EXO_CD_JUMP = 4;
    ControllerIndex currController = OrthoStereogram.controllers.getControllerIndex(0);
    long responseTimeBegin;
    long responseTime;
    private int currentIndex;

    public DoubleStereogram(int stereogramSize, int workingDistance, int initVergence, double vMin, double vMax, double vStep, double stepC, double stepD, boolean getOldTrophy) {
        this.size = stereogramSize;
        this.workingDistance = workingDistance;
        this.verticalMin = -vMin;
        this.verticalMax = vMax;
        this.verticalStep = vStep;
        this.currentVergenceValue = initVergence;
        this.currentVerticalValue = 0.0;
        this.step = this.stepC = stepC;
        this.stepD = stepD;
        if (getOldTrophy) {
            this.trophyNumber = previous_trophyNumber;
        }
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        OD = new Eye(stereogramSize, true);
        OG = new Eye(stereogramSize, false);
        this.setDefaultCloseOperation(2);
        this.setLayout(null);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.WHITE);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.executor = new ScheduledThreadPoolExecutor(1);
        NewController.csvDatasList.clear();
    }

    public void setAppearence(int game, int max, int min, int timeOut, int typeExercice, int disparity) {
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addWindowListener(this);
        this.addMouseListener(this);
        DoubleStereogram.game = game;
        this.maxRequired = max;
        this.minRequired = min;
        currentDirectionOfWork = 2;
        DoubleStereogram.disparity = disparity;
        this.obtainedMax = 0.0;
        this.obtainedMin = 0.0;
        currentDivergenceValue = 0.0;
        currentConvergenceValue = 0.0;
        DoubleStereogram.typeExercice = typeExercice;
        switch (DoubleStereogram.typeExercice) {
            case 0: {
                jump = false;
                alternate = false;
                break;
            }
            case 1: {
                jump = false;
                alternate = false;
                min = 0;
                break;
            }
            case 2: {
                jump = false;
                alternate = false;
                max = 0;
                currentDirectionOfWork = 1;
                this.step = -this.stepC;
                break;
            }
            case 3: {
                alternate = true;
                jump = false;
                break;
            }
            case 4: {
                alternate = false;
                jump = true;
            }
        }
        this.maxRequired = Math.floor((double)max / this.stepC) * this.stepC;
        this.minRequired = Math.floor((double)min / this.stepD) * this.stepD;
        this.currentIndex = 0;
        ScheduledThreadPoolExecutor xboxcutor = new ScheduledThreadPoolExecutor(1);
        xboxcutor.scheduleAtFixedRate(() -> this.checkXBOX(), 0L, 200L, TimeUnit.MILLISECONDS);
    }

    private void checkXBOX() {
        OrthoStereogram.controllers.update();
        try {
            if (this.currController.isButtonPressed(ControllerButton.DPAD_UP)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 38, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.DPAD_DOWN)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 40, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.DPAD_LEFT)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 37, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.DPAD_RIGHT)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 39, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.Y)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 38, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.A)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 40, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.X)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 37, 'A'));
            } else if (this.currController.isButtonPressed(ControllerButton.B)) {
                this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 39, 'A'));
            } else if (!(this.currController.isButtonPressed(ControllerButton.DPAD_UP) || this.currController.isButtonPressed(ControllerButton.DPAD_DOWN) || this.currController.isButtonPressed(ControllerButton.DPAD_LEFT) || this.currController.isButtonPressed(ControllerButton.DPAD_RIGHT) || this.currController.isButtonPressed(ControllerButton.Y) || this.currController.isButtonPressed(ControllerButton.A) || this.currController.isButtonPressed(ControllerButton.X) || this.currController.isButtonPressed(ControllerButton.B))) {
                this.dispatchEvent(new KeyEvent(this, 402, System.currentTimeMillis(), 0, 39, 'A'));
            }
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            // empty catch block
        }
    }

    private void resetStereogram(boolean keepClue) {
        int p;
        if (!keepClue) {
            p = this.securRand.nextInt(4);
        } else {
            switch (this.clue) {
                case 38: {
                    p = 0;
                    break;
                }
                case 37: {
                    p = 1;
                    break;
                }
                case 39: {
                    p = 2;
                    break;
                }
                default: {
                    p = 3;
                }
            }
        }
        ResetStereogram rs = new ResetStereogram(DoubleStereogram.OD.img, DoubleStereogram.OG.img, p, disparity, game);
        rs.run();
        switch (p) {
            case 0: {
                this.clue = 38;
                break;
            }
            case 1: {
                this.clue = 37;
                break;
            }
            case 2: {
                this.clue = 39;
                break;
            }
            default: {
                this.clue = 40;
            }
        }
        int deltaX = this.calcPixelsForVergence(this.currentVergenceValue);
        int deltaY = this.calcPixelsForVergence(this.currentVerticalValue);
        OD.setLocation((this.getWidth() - Eye.size) / 2 - deltaX, (this.getHeight() - Eye.size) / 2 - deltaY);
        OD.setVisible(true);
        OG.setLocation((this.getWidth() - Eye.size) / 2 + deltaX, (this.getHeight() - Eye.size) / 2 + deltaY);
        OG.setVisible(true);
        String str = new String();
        str = currentDirectionOfWork == 2 ? "C\u2191 " : (currentDirectionOfWork == 1 ? "C\u2193 " : (currentDirectionOfWork == -1 ? "D\u2191 " : "D\u2193 "));
        this.infosHLabel.setText("H [" + this.minRequired + ", " + this.maxRequired + "] : " + str + String.valueOf(this.currentVergenceValue) + " \u0394");
        Locale currentLocale = Locale.getDefault();
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(currentLocale);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator(' ');
        DecimalFormat df = new DecimalFormat("#.##", otherSymbols);
        df.setRoundingMode(RoundingMode.CEILING);
        if (this.currentVerticalValue >= 0.0) {
            this.info.setText(str + String.valueOf(this.currentVergenceValue) + " \u0394 (HD" + df.format(Math.abs(this.currentVerticalValue)) + ")");
        } else {
            this.info.setText(str + String.valueOf(this.currentVergenceValue) + " \u0394 (HG" + df.format(Math.abs(this.currentVerticalValue)) + ")");
        }
        this.infosMax.setText("C" + String.valueOf(this.obtainedMax) + "  D" + String.valueOf(Math.abs(this.obtainedMin)));
        this.currentVerticalValue += this.verticalStep;
        if (this.currentVerticalValue == this.verticalMin) {
            this.currentVerticalValue = this.verticalMin - 2.0 * this.verticalStep;
            this.verticalStep = -this.verticalStep;
        } else if (this.currentVerticalValue < this.verticalMin) {
            this.currentVerticalValue = this.verticalMin;
            this.verticalStep = -this.verticalStep;
        } else if (this.currentVerticalValue == this.verticalMax) {
            this.currentVerticalValue = this.verticalMax - 2.0 * this.verticalStep;
            this.verticalStep = -this.verticalStep;
        } else if (this.currentVerticalValue > this.verticalMax) {
            this.currentVerticalValue = this.verticalMax;
            this.verticalStep = -this.verticalStep;
        }
        this.responseTimeBegin = System.currentTimeMillis();
    }

    public int calcPixelsForVergence(double vergence) {
        double pixels = vergence * (double)this.workingDistance / 254.0 * OrthoStereogram.screenResolution1;
        return (int)Math.round(pixels / 2.0);
    }

    public void goToVergence(double value) {
        this.currentVergenceValue = value;
        this.resetStereogram(false);
    }

    public void stepVergence(double delta) {
        if (this.currentVergenceValue + delta > this.maxRequired || this.currentVergenceValue + delta < this.minRequired) {
            delta = 0.0;
        }
        this.currentVergenceValue += delta;
        this.resetStereogram(false);
    }

    public void hideCursor() {
        this.setCursor(this.transparentCursor);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        OrthoStereogram.newController.setEnabled(false);
        this.hideCursor();
        this.infosHLabel = new JLabel("");
        this.infosHLabel.setBounds(10, 10, 300, 30);
        this.getContentPane().add(this.infosHLabel);
        this.info = new JLabel("--");
        this.info.setBounds(20, 35, 300, 30);
        this.info.setForeground(Color.GRAY);
        this.getContentPane().add(this.info);
        JLabel label_2 = new JLabel("Max score :");
        label_2.setBounds(10, 60, 100, 30);
        this.getContentPane().add(label_2);
        this.infosMax = new JLabel("--");
        this.infosMax.setForeground(Color.GRAY);
        this.infosMax.setBounds(20, 85, 300, 30);
        this.getContentPane().add(this.infosMax);
        this.NB_TROPHY = (this.getHeight() - 160 - 64) / 85;
        this.trophy = new JLabel[this.NB_TROPHY];
        for (int i = 0; i < this.NB_TROPHY; ++i) {
            this.trophy[i] = new JLabel();
            this.trophy[i].setIcon(new ImageIcon(NewController.tinyTrophy));
            this.trophy[i].setBounds(20, 160 + i * 85, 64, 64);
            this.getContentPane().add(this.trophy[i]);
            if (i < this.trophyNumber) {
                this.trophy[i].setEnabled(true);
            } else {
                this.trophy[i].setEnabled(false);
            }
            if (!jump) continue;
            this.trophy[i].setVisible(false);
        }
        int deltaX = this.calcPixelsForVergence(this.currentVergenceValue);
        int deltaY = this.calcPixelsForVergence(this.verticalMin);
        OD.setLocation((this.getWidth() - Eye.size) / 2 - deltaX, (this.getHeight() - Eye.size) / 2 - deltaY);
        OD.setVisible(true);
        OG.setLocation((this.getWidth() - Eye.size) / 2 + deltaX, (this.getHeight() - Eye.size) / 2 + deltaY);
        OG.setVisible(true);
        this.resetStereogram(false);
        this.getContentPane().add(OD);
        OD.repaint();
        this.getContentPane().add(OG);
        OG.repaint();
        this.repaint();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        previous_trophyNumber = this.trophyNumber;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        OrthoStereogram.newController.setEnabled(true);
        OrthoStereogram.newController.setVisible(true);
        OrthoStereogram.newController.setState(0);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        char c = ke.getKeyChar();
        if (this.resizingIsActive || this.keypressedIsActive) {
            return;
        }
        if (c != 'M' && !ke.isControlDown() && !ke.isShiftDown()) {
            this.keypressedIsActive = true;
        }
        if (keyCode == 27) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (keyCode == this.clue) {
            this.goodAnswer();
        } else if (keyCode == 38 || keyCode == 40 || keyCode == 37 || keyCode == 39 || keyCode == 32) {
            this.badAnswer();
        }
        if (keyCode == 86) {
            boolean b = OrthoStereogram.newController.menuVibration.isSelected();
            OrthoStereogram.newController.menuVibration.setSelected(!b);
        }
        if ((keyCode == 109 | keyCode == 54) & ke.isControlDown() & !ke.isShiftDown()) {
            this.resizingIsActive = true;
            if (NewController.imgScale(0.9)) {
                OD.resize(NewController.imgSize);
                OG.resize(NewController.imgSize);
                this.resetStereogram(true);
            }
        } else if (keyCode == 107 & ke.isControlDown() & !ke.isShiftDown()) {
            this.resizingIsActive = true;
            if (NewController.imgScale(1.1)) {
                OD.resize(NewController.imgSize);
                OG.resize(NewController.imgSize);
                this.resetStereogram(true);
            }
        } else if (keyCode == 61 & ke.isControlDown() & ke.isShiftDown()) {
            this.resizingIsActive = true;
            if (NewController.imgScale(1.1)) {
                OD.resize(NewController.imgSize);
                OG.resize(NewController.imgSize);
                this.resetStereogram(true);
            }
        }
        this.resizingIsActive = false;
    }

    public void timeOut() {
        this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 32, 'A'));
    }

    public void goodAnswer() {
        this.responseTime = System.currentTimeMillis() - this.responseTimeBegin;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.executor.remove(() -> this.timeOut());
        new WavSoundThread(1).start();
        previousBadAnswer = 0;
        CSVDatas currentCSVData = new CSVDatas();
        currentCSVData.idx = ++this.currentIndex;
        currentCSVData.work = currentDirectionOfWork;
        currentCSVData.vergence = this.currentVergenceValue;
        currentCSVData.verticality = this.currentVerticalValue;
        currentCSVData.succeed = true;
        currentCSVData.delay = this.responseTime;
        NewController.csvDatasList.add(currentCSVData);
        if (alternate) {
            if (this.currentVergenceValue > this.obtainedMax) {
                this.obtainedMax = this.currentVergenceValue;
            } else if (this.currentVergenceValue < this.obtainedMin) {
                this.obtainedMin = this.currentVergenceValue;
            }
        } else if (currentDirectionOfWork == 2 & this.currentVergenceValue > this.obtainedMax) {
            this.obtainedMax = this.currentVergenceValue;
        } else if (currentDirectionOfWork == -1 & this.currentVergenceValue < this.obtainedMin) {
            this.obtainedMin = this.currentVergenceValue;
        }
        if (currentDirectionOfWork == 2 & this.currentVergenceValue + this.step > this.maxRequired) {
            this.step = -this.stepC;
            currentDirectionOfWork = 1;
            OrthoStereogram.newController.addGraphBarTime();
        } else if (currentDirectionOfWork == 1 & this.currentVergenceValue + this.step < this.minRequired) {
            this.step = this.stepC;
            currentDirectionOfWork = 2;
            OrthoStereogram.newController.addGraphBarTime();
        } else if (currentDirectionOfWork == 1 & this.currentVergenceValue + this.step < 0.0) {
            this.step = -this.stepD;
            currentDirectionOfWork = -1;
            OrthoStereogram.newController.addGraphBarTime();
        } else if (currentDirectionOfWork == -1 & this.currentVergenceValue + this.step < this.minRequired) {
            this.step = this.stepD;
            currentDirectionOfWork = -2;
            OrthoStereogram.newController.addGraphBarTime();
        } else if (currentDirectionOfWork == -2 & this.currentVergenceValue + this.step > this.maxRequired) {
            this.step = -this.stepD;
            currentDirectionOfWork = -1;
            OrthoStereogram.newController.addGraphBarTime();
        } else if (currentDirectionOfWork == -2 & this.currentVergenceValue + this.step > 0.0) {
            this.step = this.stepC;
            currentDirectionOfWork = 2;
            OrthoStereogram.newController.addGraphBarTime();
        }
        if (alternate) {
            switch (currentDirectionOfWork) {
                case 2: {
                    currentConvergenceValue += this.stepC;
                    if (currentConvergenceValue > this.maxRequired) {
                        currentConvergenceValue = this.maxRequired;
                        this.step = this.stepC = -this.stepC;
                        break;
                    }
                    if (!(currentConvergenceValue < 0.0)) break;
                    currentConvergenceValue = 0.0;
                    this.step = this.stepC = -this.stepC;
                    break;
                }
                case -1: {
                    currentDivergenceValue -= this.stepD;
                    if (currentDivergenceValue < this.minRequired) {
                        currentDivergenceValue = this.minRequired;
                        this.step = this.stepD = -this.stepD;
                        break;
                    }
                    if (!(currentDivergenceValue > 0.0)) break;
                    currentDivergenceValue = 0.0;
                    this.step = this.stepD = -this.stepD;
                }
            }
        }
        if (jump) {
            switch (currentDirectionOfWork) {
                case 2: {
                    this.goToVergence(this.maxRequired);
                    currentDirectionOfWork = -1;
                    break;
                }
                case -1: {
                    this.goToVergence(this.minRequired);
                    currentDirectionOfWork = 2;
                }
            }
        } else if (alternate & currentDirectionOfWork == 2) {
            this.goToVergence(currentConvergenceValue);
            currentDirectionOfWork = -1;
        } else if (alternate & currentDirectionOfWork == -1) {
            this.goToVergence(currentDivergenceValue);
            currentDirectionOfWork = 2;
        } else {
            this.stepVergence(this.step);
        }
        NewController.addGraphMax(this.currentVergenceValue);
        if (this.responseTime < 20000L) {
            OrthoStereogram.newController.addGraphTime(this.responseTime / 100L);
        }
        if (this.currentVergenceValue == 0.0 && this.obtainedMax == this.maxRequired && this.obtainedMin == this.minRequired) {
            this.trophy[this.trophyNumber].setEnabled(true);
            this.xboxVibre();
            if (this.trophyNumber < this.NB_TROPHY - 1) {
                ++this.trophyNumber;
            }
        }
        this.scheduledFuture = this.executor.schedule(() -> this.timeOut(), (long)timeOut, TimeUnit.SECONDS);
    }

    private void xboxVibre() {
        if (!OrthoStereogram.newController.menuVibration.isSelected()) {
            return;
        }
        try {
            this.currController.doVibration(1.0f, 0.0f, 750);
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            // empty catch block
        }
    }

    public void badAnswer() {
        this.responseTime = System.currentTimeMillis() - this.responseTimeBegin;
        double step = this.step;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.executor.remove(() -> this.timeOut());
        new WavSoundThread(0).start();
        CSVDatas currentCSVData = new CSVDatas();
        currentCSVData.idx = ++this.currentIndex;
        currentCSVData.work = currentDirectionOfWork;
        currentCSVData.vergence = this.currentVergenceValue;
        currentCSVData.verticality = this.currentVerticalValue;
        currentCSVData.succeed = true;
        currentCSVData.delay = this.responseTime;
        NewController.csvDatasList.add(currentCSVData);
        this.currentVerticalValue = 0.0;
        if (!alternate & !jump & previousBadAnswer > 1) {
            switch (currentDirectionOfWork) {
                case 2: {
                    currentDirectionOfWork = 1;
                    this.step = -this.stepC;
                    break;
                }
                case -1: {
                    currentDirectionOfWork = -2;
                    this.step = this.stepD;
                }
            }
        } else if (previousBadAnswer == 1) {
            step = 2.0 * step;
        }
        ++previousBadAnswer;
        if (jump) {
            switch (currentDirectionOfWork) {
                case 2: {
                    this.goToVergence(this.maxRequired);
                    currentDirectionOfWork = -1;
                    break;
                }
                case -1: {
                    this.goToVergence(this.minRequired);
                    currentDirectionOfWork = 2;
                }
            }
        } else if (alternate) {
            switch (currentDirectionOfWork) {
                case 2: {
                    this.goToVergence(currentDivergenceValue);
                    currentDirectionOfWork = -1;
                    break;
                }
                case -1: {
                    this.goToVergence(currentConvergenceValue);
                    currentDirectionOfWork = 2;
                }
            }
        } else if (this.currentVergenceValue == 0.0) {
            this.goToVergence(0.0);
        } else {
            switch (currentDirectionOfWork) {
                case 2: {
                    if (!(this.currentVergenceValue > 0.0)) break;
                    this.stepVergence(-step);
                    break;
                }
                case 1: {
                    if (!(this.currentVergenceValue > 0.0)) break;
                    this.stepVergence(step);
                    break;
                }
                case -1: {
                    if (!(this.currentVergenceValue < 0.0)) break;
                    this.stepVergence(-step);
                    break;
                }
                case -2: {
                    if (!(this.currentVergenceValue < 0.0)) break;
                    this.stepVergence(step);
                }
            }
            this.goToVergence(this.currentVergenceValue);
        }
        this.repaint();
        this.scheduledFuture = this.executor.schedule(() -> this.timeOut(), (long)timeOut, TimeUnit.SECONDS);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keypressedIsActive = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX() - this.getWidth() / 2;
        int y = e.getY() - this.getHeight() / 2;
        int k = 37;
        if (y > 0 && y > Math.abs(x)) {
            k = 40;
        } else if (x > 0 && x > Math.abs(y)) {
            k = 39;
        } else if (y < 0 && -y > Math.abs(x)) {
            k = 38;
        }
        this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, k, 'M'));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        timeOut = 20;
        previousBadAnswer = 0;
        previous_trophyNumber = 0;
        alternate = false;
        jump = false;
    }
}

