/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import orthostereogram.OrthoStereogram;

class EyeSlide
extends JPanel {
    static int size;
    boolean isRight;
    public BufferedImage img;
    public Graphics2D graphics;
    int myRed = -16711681;
    int myCyan = -65536;
    public int myCurrentColor;

    public EyeSlide(int size, boolean isRight) {
        EyeSlide.size = size;
        this.isRight = isRight;
        this.setSize(size, size);
        this.myCurrentColor = isRight && OrthoStereogram.BR_glasses ? this.myRed : (isRight && !OrthoStereogram.BR_glasses ? this.myCyan : (!isRight && OrthoStereogram.BR_glasses ? this.myCyan : this.myRed));
        this.img = new BufferedImage(size, size, 1);
        this.graphics = this.img.createGraphics();
        this.fillWithMyColor();
        this.setOpaque(false);
    }

    public void fillWithMyColor() {
        this.graphics.setPaint(new Color(this.myCurrentColor));
        this.graphics.fillRect(0, 0, size, size);
    }

    public void resize(int newSize) {
        size = newSize;
        this.setSize(newSize, newSize);
        this.img = new BufferedImage(newSize, newSize, 1);
        this.graphics = this.img.createGraphics();
        this.fillWithMyColor();
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        g.setXORMode(Color.WHITE);
        g.drawImage(this.img, 0, 0, this);
    }
}

