/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import orthostereogram.Anaglyph;
import orthostereogram.OneEyeBis;
import orthostereogram.OrthoStereogram;

public class ImageStereogramView
extends JFrame
implements WindowListener,
MouseMotionListener,
KeyListener {
    Image imgStereo;
    public static BufferedImage od;
    public static BufferedImage og;
    public static BufferedImage bimage;
    public static BufferedImage image;
    Cursor transparentCursor;
    private Point center;
    private int deltaX = 0;
    private int deltaY = 0;
    private OneEyeBis xpanelOD;
    private OneEyeBis xpanelOG;
    private JLabel info;
    private int minVergence;
    private int maxVergence;
    private int workingDistance = 70;
    private int minPixels = -200;
    private int maxPixels = 400;
    private int timeout = 150;
    private int vDirection = 38;
    private int minVPixels = 0;
    private int maxVPixels = 0;
    private boolean isThereVerticality = false;
    private int hDirection = 37;
    private int dirMove = 37;
    final ScheduledThreadPoolExecutor executorVergence;
    final ScheduledThreadPoolExecutor executorMove;

    public ImageStereogramView(String file, int speed, int minVergence, int maxVergence, int workingDistance, double verticality) {
        if (verticality != 0.0) {
            this.isThereVerticality = true;
            this.minVPixels = -this.calcPixelsForVergence(0.25 * verticality);
            this.maxVPixels = this.calcPixelsForVergence(0.25 * verticality);
        }
        this.minVergence = minVergence;
        this.maxVergence = maxVergence;
        this.minPixels = this.calcPixelsForVergence(minVergence);
        this.maxPixels = this.calcPixelsForVergence(maxVergence);
        this.workingDistance = workingDistance;
        int[] pixels = new int[256];
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(0, 0), "invisibleCursor");
        URL url = ImageStereogramView.class.getResource("/Ressources/" + file);
        try {
            bimage = ImageIO.read(url);
        }
        catch (IOException io) {
            System.out.println("IO !!");
        }
        this.setDefaultCloseOperation(2);
        this.setTitle("Slider");
        this.setLayout(null);
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.WHITE);
        this.setVisible(true);
        this.executorVergence = new ScheduledThreadPoolExecutor(1);
        this.executorMove = new ScheduledThreadPoolExecutor(1);
        switch (speed) {
            case 0: {
                this.timeout = 200;
                break;
            }
            case 1: {
                this.timeout = 150;
                break;
            }
            case 2: {
                this.timeout = 100;
                break;
            }
            case 3: {
                this.timeout = 50;
                break;
            }
            case 4: {
                this.timeout = 25;
            }
        }
    }

    public int calcPixelsForVergence(double vergence) {
        double pixels = vergence * (double)this.workingDistance / 254.0 * OrthoStereogram.screenResolution1;
        return (int)Math.round(pixels / 2.0);
    }

    public double calcVergenceForPixels(int pixels) {
        double vergence = (double)(pixels * 254 * 2) / (OrthoStereogram.screenResolution1 * (double)this.workingDistance);
        return vergence;
    }

    private boolean isBoundariesOK() {
        int w = this.xpanelOD.getWidth();
        int d = Math.abs(this.deltaX);
        int c = d > w ? 2 * w + d : w + d;
        if (this.dirMove == 37) {
            return this.center.x + c / 2 < this.getWidth();
        }
        return this.center.x - c / 2 > 0;
    }

    public void setAppearence() {
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addWindowListener(this);
        this.setIgnoreRepaint(true);
    }

    public void setPositions() {
        this.xpanelOD.setLocation(this.center.x - this.deltaX / 2 - this.xpanelOD.getWidth() / 2, this.center.y - this.deltaY);
        this.xpanelOG.setLocation(this.center.x + this.deltaX / 2 - this.xpanelOG.getWidth() / 2, this.center.y + this.deltaY);
    }

    public BufferedImage scaleImg(BufferedImage before, double scale) {
        int w = (int)((double)before.getWidth() * scale);
        int h = (int)((double)before.getHeight() * scale);
        if (h > this.getContentPane().getHeight() | h < 200) {
            return before;
        }
        if (w > this.getContentPane().getWidth() | w < 150) {
            return before;
        }
        BufferedImage after = new BufferedImage(w, h, 2);
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        after = scaleOp.filter(before, after);
        return after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowOpened(WindowEvent we) {
        this.info = new JLabel("Initializing...");
        this.info.setBounds(10, 10, 300, 30);
        this.getContentPane().add(this.info);
        BufferedImage sub = bimage.getSubimage(0, 0, bimage.getWidth(), bimage.getHeight());
        od = new BufferedImage(bimage.getWidth() / 2, bimage.getHeight(), 1);
        Graphics2D g = od.createGraphics();
        try {
            g.drawImage((Image)sub, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        sub = bimage.getSubimage(bimage.getWidth() / 2, 0, bimage.getWidth() / 2, bimage.getHeight());
        og = new BufferedImage(bimage.getWidth() / 2, bimage.getHeight(), 1);
        g = og.createGraphics();
        try {
            g.drawImage((Image)sub, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        Anaglyph anaglyph = new Anaglyph();
        if (OrthoStereogram.BR_glasses) {
            Anaglyph.createStereoscopicRedImage(od);
            Anaglyph.createStereoscopicBlueImage(og);
        } else {
            Anaglyph.createStereoscopicRedImage(og);
            Anaglyph.createStereoscopicBlueImage(od);
        }
        this.xpanelOD = new OneEyeBis(od);
        this.xpanelOG = new OneEyeBis(og);
        this.center = new Point(this.getWidth() / 2, (this.getHeight() - this.xpanelOD.getHeight()) / 2);
        this.xpanelOD.setLocation(this.center.x - this.deltaX / 2 - this.xpanelOD.getWidth() / 2, this.center.y);
        this.xpanelOG.setLocation(this.center.x + this.deltaX / 2 - this.xpanelOG.getWidth() / 2, this.center.y);
        this.getContentPane().add(this.xpanelOD);
        this.getContentPane().add(this.xpanelOG);
        this.executorVergence.scheduleAtFixedRate(() -> this.timeOutVergence(), 3000L, this.timeout, TimeUnit.MILLISECONDS);
        this.executorMove.scheduleAtFixedRate(() -> this.timeOutMove(), 3000L, this.timeout / 2, TimeUnit.MILLISECONDS);
        this.hideCursor();
        this.repaint();
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.executorVergence.shutdownNow();
        this.executorMove.shutdownNow();
    }

    @Override
    public void windowClosed(WindowEvent we) {
        OrthoStereogram.newController.setEnabled(true);
        OrthoStereogram.newController.setVisible(true);
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowActivated(WindowEvent we) {
        OrthoStereogram.newController.setEnabled(false);
        this.hideCursor();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    public void hideCursor() {
        this.setCursor(this.transparentCursor);
    }

    private void timeOutMove() {
        if (this.dirMove == 37) {
            if (this.isBoundariesOK()) {
                ++this.center.x;
            } else {
                this.dirMove = 39;
            }
        } else if (this.isBoundariesOK()) {
            --this.center.x;
        } else {
            this.dirMove = 37;
        }
    }

    private void timeOutVergence() {
        if (this.deltaX < this.minPixels) {
            this.hDirection = 39;
        } else if (this.deltaX > this.maxPixels) {
            this.hDirection = 37;
        }
        if (this.isThereVerticality) {
            if (this.deltaY < this.minVPixels) {
                this.vDirection = 38;
            } else if (this.deltaY > this.maxVPixels) {
                this.vDirection = 40;
            }
            this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, this.vDirection, 'A'));
        }
        this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, this.hDirection, 'A'));
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        if (keyCode == 27) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (keyCode == 37) {
            --this.deltaX;
            this.setPositions();
        } else if (keyCode == 39) {
            ++this.deltaX;
            this.setPositions();
        } else if (keyCode == 38) {
            ++this.deltaY;
            this.setPositions();
        } else if (keyCode == 40) {
            --this.deltaY;
            this.setPositions();
        } else if (keyCode == 32) {
            this.center.x = this.getWidth() / 2;
            this.center.y = (this.getHeight() - this.xpanelOD.getHeight()) / 2;
            this.deltaX = 0;
            this.deltaY = 0;
            this.vDirection = 38;
            this.hDirection = 37;
        }
        if ((keyCode == 109 | keyCode == 54) & ke.isControlDown() & !ke.isShiftDown()) {
            od = this.scaleImg(od, 0.9);
            og = this.scaleImg(og, 0.9);
            this.xpanelOD.resize(od);
            this.xpanelOG.resize(og);
            this.center.y = (this.getHeight() - this.xpanelOD.getHeight()) / 2;
            this.setPositions();
        } else if (keyCode == 107 & ke.isControlDown() & !ke.isShiftDown()) {
            od = this.scaleImg(od, 1.1);
            og = this.scaleImg(og, 1.1);
            this.xpanelOD.resize(od);
            this.xpanelOG.resize(og);
            this.center.y = (this.getHeight() - this.xpanelOD.getHeight()) / 2;
            this.setPositions();
        } else if (keyCode == 61 & ke.isControlDown() & ke.isShiftDown()) {
            od = this.scaleImg(od, 1.1);
            og = this.scaleImg(og, 1.1);
            this.xpanelOD.resize(od);
            this.xpanelOG.resize(og);
            this.center.y = (this.getHeight() - this.xpanelOD.getHeight()) / 2;
            this.setPositions();
        }
        this.hideCursor();
        this.info.setText(String.format("%+2.1f", this.calcVergenceForPixels(this.deltaX)));
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }
}

