/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import orthostereogram.AccommodationJob;
import orthostereogram.CSVDatas;
import orthostereogram.Calibrate;
import orthostereogram.ConnectDialog;
import orthostereogram.DoubleStereogram;
import orthostereogram.HelpJDialog;
import orthostereogram.ImageStereogramView;
import orthostereogram.OrthoStereogram;
import orthostereogram.Saccades;
import orthostereogram.SlideStereogramView;
import orthostereogram.SliderStereogram_v2;
import orthostereogram.SystemInfoJDialog;
import orthostereogram.VergencePanel;

public class NewController
extends JFrame
implements WindowListener,
ActionListener {
    JMenuItem menuConnection;
    JMenuItem menuCalibration;
    JMenuItem menuQuitter;
    JMenuItem menuInfos;
    JMenuItem menuInstructions;
    JCheckBoxMenuItem menuVibration;
    static VergencePanel panelVergences;
    Saccades saccades;
    AccommodationJob accommodation;
    JSpinner jSize_acc;
    JSpinner jSize_sacc;
    JSpinner jDelay_sacc;
    JSpinner jExtension_sacc;
    JSpinner jCharSize_flux;
    JCheckBox jBold_sacc;
    JCheckBox jMin_sacc;
    JCheckBox jExclude_sacc;
    public JLabel calibLabel;
    public Image imgBR;
    public Image imgRB;
    public Image xboxImage;
    public JLabel imgLunettes;
    public JLabel xBoxIcon;
    public static Image tinyTrophy;
    DoubleStereogram doubleSt;
    SlideStereogramView slide;
    SliderStereogram_v2 sliderV2;
    ImageStereogramView imageFrame;
    public static JFrame currentFrame;
    static int DEFAULT_IMG_SIZE;
    public static int imgSize;
    public static List<CSVDatas> csvDatasList;

    public NewController() {
        this.setPreferredSize(new Dimension(1000, 700));
        this.pack();
        this.imgRB = this.getToolkit().getImage(this.getClass().getResource("/Ressources/3d-BR.png"));
        this.imgBR = this.getToolkit().getImage(this.getClass().getResource("/Ressources/3d-RB.png"));
        this.xboxImage = this.getToolkit().getImage(this.getClass().getResource("/Ressources/xbox-icon64.png"));
        tinyTrophy = this.getToolkit().getImage(this.getClass().getResource("/Ressources/trophy-small.png"));
        this.setVisible(false);
        this.setTitle("orthoStereogram (F. Maillet - v2.3.2) Mode DEMO");
        this.addMenuBar();
        this.addTabbedPane();
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        DEFAULT_IMG_SIZE = (int)(screenSize.getHeight() * 0.9);
        if ((DEFAULT_IMG_SIZE & 1) != 0) {
            --DEFAULT_IMG_SIZE;
        }
        imgSize = DEFAULT_IMG_SIZE;
    }

    private void addMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menuFichier = new JMenu("Fichier");
        this.menuConnection = new JMenuItem("Connexion serveur");
        this.menuConnection.addActionListener(this);
        menuFichier.add(this.menuConnection);
        menuFichier.addSeparator();
        this.menuQuitter = new JMenuItem("Quitter");
        this.menuQuitter.addActionListener(this);
        menuFichier.add(this.menuQuitter);
        JMenu menuParams = new JMenu("Param\u00e8tres");
        this.menuCalibration = new JMenuItem("Calibration");
        menuParams.add(this.menuCalibration);
        this.menuCalibration.addActionListener(this);
        menuParams.addSeparator();
        this.menuVibration = new JCheckBoxMenuItem("Vibration xBox");
        this.menuVibration.setSelected(true);
        menuParams.add(this.menuVibration);
        JMenu menuAide = new JMenu("Aide");
        this.menuInstructions = new JMenuItem("Instructions");
        this.menuInstructions.addActionListener(this);
        menuAide.add(this.menuInstructions);
        menuAide.addSeparator();
        this.menuInfos = new JMenuItem("\u00c0 propos...");
        this.menuInfos.addActionListener(this);
        menuAide.add(this.menuInfos);
        menubar.add(menuFichier);
        menubar.add(menuParams);
        menubar.add(menuAide);
        this.setJMenuBar(menubar);
    }

    private void addTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        panelVergences = new VergencePanel(this);
        JPanel panelAccommodation = new JPanel();
        JPanel panelSaccades = new JPanel();
        JPanel panelFluxVisuel = new JPanel();
        panelSaccades.setBackground(new Color(102, 255, 102));
        panelAccommodation.setBackground(new Color(255, 255, 204));
        tabbedPane.addTab("Vergences", panelVergences);
        panelVergences.initPanel();
        panelVergences.addGraphiques();
        tabbedPane.addTab("Accommodation ", panelAccommodation);
        tabbedPane.addTab("Saccades", panelSaccades);
        tabbedPane.addTab("Flux visuel", panelFluxVisuel);
        this.defineAccommodationPanel(panelAccommodation);
        this.defineSaccadesPanel(panelSaccades);
        this.defineFluxVisuelPanel(panelFluxVisuel);
        this.add(tabbedPane);
        this.addWindowListener(this);
    }

    private void defineFluxVisuelPanel(JPanel panelFluxVisuel) {
        panelFluxVisuel.setLayout(null);
        panelFluxVisuel.setBackground(Color.LIGHT_GRAY);
        JLabel label_CharSize = new JLabel("Taille caract\u00e8re:");
        label_CharSize.setBounds(20, 50, 100, 30);
        panelFluxVisuel.add(label_CharSize);
        JLabel label_FluxSize = new JLabel("Taille flux:");
        label_FluxSize.setBounds(20, 85, 100, 30);
        panelFluxVisuel.add(label_FluxSize);
        SpinnerNumberModel model = new SpinnerNumberModel(20, 8, 40, 1);
        this.jCharSize_flux = new JSpinner(model);
        this.jCharSize_flux.setBounds(140, 55, 55, 20);
        this.jCharSize_flux.setEnabled(false);
        panelFluxVisuel.add(this.jCharSize_flux);
    }

    private void defineSaccadesPanel(JPanel panelSaccades) {
        panelSaccades.setLayout(null);
        JLabel label_sacc1 = new JLabel("Taille caract\u00e8res:");
        label_sacc1.setBounds(20, 95, 100, 30);
        panelSaccades.add(label_sacc1);
        JLabel label_sacc2 = new JLabel("D\u00e9lai entre flashs:");
        label_sacc2.setBounds(20, 60, 120, 30);
        panelSaccades.add(label_sacc2);
        JLabel label_sacc3 = new JLabel("Extension (\u00b0):");
        label_sacc3.setBounds(20, 145, 120, 30);
        panelSaccades.add(label_sacc3);
        SpinnerNumberModel model = new SpinnerNumberModel(20, 8, 50, 1);
        this.jSize_sacc = new JSpinner(model);
        this.jSize_sacc.setBounds(140, 100, 55, 20);
        this.jSize_sacc.setEnabled(false);
        panelSaccades.add(this.jSize_sacc);
        this.jDelay_sacc = new JSpinner(new SpinnerNumberModel(1200, 400, 5000, 100));
        this.jDelay_sacc.setBounds(140, 65, 55, 20);
        this.jDelay_sacc.setEnabled(false);
        panelSaccades.add(this.jDelay_sacc);
        this.jBold_sacc = new JCheckBox("gras");
        this.jBold_sacc.setSelected(true);
        this.jBold_sacc.setBounds(220, 100, 55, 20);
        this.jBold_sacc.setOpaque(false);
        panelSaccades.add(this.jBold_sacc);
        this.jMin_sacc = new JCheckBox("minuscules");
        this.jMin_sacc.setSelected(false);
        this.jMin_sacc.setBounds(285, 100, 100, 20);
        this.jMin_sacc.setOpaque(false);
        panelSaccades.add(this.jMin_sacc);
        this.jExclude_sacc = new JCheckBox("exclure 'w y'");
        this.jExclude_sacc.setSelected(true);
        this.jExclude_sacc.setBounds(285, 130, 100, 20);
        this.jExclude_sacc.setOpaque(false);
        panelSaccades.add(this.jExclude_sacc);
        this.jExtension_sacc = new JSpinner(new SpinnerNumberModel(15, 5, 40, 1));
        this.jExtension_sacc.setBounds(140, 150, 55, 20);
        this.jExtension_sacc.setEnabled(false);
        panelSaccades.add(this.jExtension_sacc);
        JButton launchSaccades = new JButton("D\u00e9marrer");
        launchSaccades.setBounds(20, 200, 250, 35);
        panelSaccades.add(launchSaccades);
        launchSaccades.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewController.this.saccadesDemarrer();
            }
        });
    }

    private void defineAccommodationPanel(JPanel panelAccommodation) {
        panelAccommodation.setLayout(null);
        JLabel instruction = new JLabel("Faire porter deux sph\u00e8res oppos\u00e9es (comme -1/+2 ou +2/-3) selon les puissances d\u00e9sir\u00e9es");
        instruction.setBounds(10, 10, 550, 30);
        JLabel label_acc1 = new JLabel("Taille caract\u00e8res:");
        label_acc1.setBounds(20, 95, 100, 30);
        SpinnerNumberModel model = new SpinnerNumberModel(9, 5, 20, 1);
        this.jSize_acc = new JSpinner(model);
        this.jSize_acc.setBounds(130, 100, 45, 20);
        this.jSize_acc.setEnabled(false);
        JButton launchAccommodation = new JButton("D\u00e9marrer");
        launchAccommodation.setBounds(20, 150, 200, 35);
        panelAccommodation.add(instruction);
        panelAccommodation.add(label_acc1);
        panelAccommodation.add(this.jSize_acc);
        panelAccommodation.add(launchAccommodation);
        launchAccommodation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewController.this.accommodationDemarrer();
            }
        });
    }

    public void updateCalibrationStatus() {
        if (OrthoStereogram.isCalibrated) {
            this.calibLabel.setText("Calibration ok");
            this.calibLabel.setBackground(Color.GREEN);
            this.calibLabel.setToolTipText(null);
            if (panelVergences != null) {
                panelVergences.updateScreenDistance(OrthoStereogram.screenDistance1);
            }
        } else {
            this.calibLabel.setText("Calibration nok => estim\u00e9e");
            this.calibLabel.setBackground(Color.RED);
            this.calibLabel.setToolTipText("Effectuez une calibration...");
        }
    }

    private void accommodationDemarrer() {
        this.accommodation = new AccommodationJob((Integer)this.jSize_acc.getValue());
        this.accommodation.setAppearence();
    }

    private void saccadesDemarrer() {
        this.saccades = new Saccades((Integer)this.jSize_sacc.getValue(), (Integer)this.jDelay_sacc.getValue(), this.jBold_sacc.isSelected(), this.jMin_sacc.isSelected(), (Integer)this.jExtension_sacc.getValue(), this.jExclude_sacc.isSelected());
        this.saccades.setAppearence();
    }

    public void resetLimites() {
        this.setTitle("orthoStereogram (v2.3.2) - " + OrthoStereogram.user.titre + " " + OrthoStereogram.user.nom.toUpperCase() + " " + OrthoStereogram.user.prenom);
        panelVergences.resetLimites();
        this.jSize_acc.setEnabled(true);
        this.jSize_sacc.setEnabled(true);
        this.jDelay_sacc.setEnabled(true);
        this.jExtension_sacc.setEnabled(true);
    }

    private void displaySystemInfos() {
        SystemInfoJDialog info = new SystemInfoJDialog((Frame)this, true);
        SystemInfoJDialog.jText.append("orthoStereogram : v2.3.2 du 02.02.2023\n\n");
        SystemInfoJDialog.jText.append("Java version : " + System.getProperty("java.version") + "\n");
        SystemInfoJDialog.jText.append("Java runtime : " + System.getProperty("java.runtime.version") + "\n");
        SystemInfoJDialog.jText.append("System is : " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")\n");
        SystemInfoJDialog.jText.append("Free memory : " + Runtime.getRuntime().freeMemory() + "\n");
        SystemInfoJDialog.jText.append("Vergence : \n-----\n");
        SystemInfoJDialog.jText.append("Estimated resolution : " + Toolkit.getDefaultToolkit().getScreenResolution() + " pixels/inch\n");
        if (OrthoStereogram.isCalibrated) {
            SystemInfoJDialog.jText.append("Calibrated resolution1: " + OrthoStereogram.screenResolution1 + " pixels/inch\n");
            SystemInfoJDialog.jText.append("Calibrated resolution2: " + OrthoStereogram.screenResolution2 + " pixels/inch");
        } else {
            SystemInfoJDialog.jText.append("No Calibration available");
        }
        SystemInfoJDialog.jText.append("\n\nDefault img size: " + String.valueOf(DEFAULT_IMG_SIZE));
        SystemInfoJDialog.jText.append("\n-----\n");
        SystemInfoJDialog.jText.append("Manettes : " + OrthoStereogram.controllers.getNumControllers());
        ControllerIndex currController = OrthoStereogram.controllers.getControllerIndex(0);
        try {
            SystemInfoJDialog.jText.append("\nManettes : " + currController.getName());
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            // empty catch block
        }
        info.setLocationRelativeTo(this);
        info.setVisible(true);
    }

    public static boolean imgScale(double factor) {
        int tmp = (int)((double)imgSize * factor);
        if ((tmp & 1) != 0) {
            --tmp;
        }
        if (tmp > currentFrame.getContentPane().getHeight() | tmp < 200) {
            return false;
        }
        imgSize = tmp;
        return true;
    }

    public static void addGraphMax(double max) {
        int n = NewController.panelVergences.xySerieMax.getItemCount();
        NewController.panelVergences.xySerieMax.add((double)(n + 1), max);
    }

    public static void addGraphBarTime() {
        int n = NewController.panelVergences.xySerieTime.getItemCount();
        ValueMarker marker = new ValueMarker(n);
        marker.setPaint(Color.black);
        XYPlot plot = (XYPlot)NewController.panelVergences.chart2.getPlot();
        plot.addDomainMarker(marker);
        plot = (XYPlot)NewController.panelVergences.chart1.getPlot();
        plot.addDomainMarker(marker);
    }

    public void addGraphTime(double min) {
        int n = NewController.panelVergences.xySerieTime.getItemCount();
        NewController.panelVergences.xySerieTime.add((double)(n + 1), min);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.setIconImage(this.getToolkit().getImage(this.getClass().getResource("/Ressources/stereograph_icon.png")));
    }

    @Override
    public void windowClosing(WindowEvent e) {
        OrthoStereogram.sortir();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuConnection) {
            ConnectDialog connect = new ConnectDialog((Frame)this, true);
            connect.setLocationRelativeTo(null);
            connect.setVisible(true);
            if (OrthoStereogram.user.nom != null) {
                OrthoStereogram.connected();
            }
        } else if (e.getSource() == this.menuQuitter) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.menuInfos) {
            this.displaySystemInfos();
        } else if (e.getSource() == this.menuCalibration) {
            Calibrate cal = new Calibrate((Frame)this, true);
            cal.setLocationRelativeTo(this);
            cal.setVisible(true);
        } else if (e.getSource() == this.menuInstructions) {
            HelpJDialog help = new HelpJDialog((Frame)this, true);
            help.setLocationRelativeTo(this);
            help.setVisible(true);
        }
    }

    static {
        imgSize = DEFAULT_IMG_SIZE = 600;
        csvDatasList = new ArrayList<CSVDatas>();
    }
}

