/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import orthostereogram.OrthoStereogram;
import orthostereogram.Stereogram;

class OneEye
extends JPanel {
    private int eye;

    public OneEye(int eye) {
        this.eye = eye;
        this.setVisible(false);
        if (eye == 0) {
            this.setSize(Stereogram.OD.getWidth(), Stereogram.OD.getHeight());
        } else {
            this.setSize(Stereogram.OG.getWidth(), Stereogram.OG.getHeight());
        }
        this.setOpaque(false);
    }

    public void resize() {
        if (this.eye == 0) {
            this.setSize(Stereogram.OD.getWidth(), Stereogram.OD.getHeight());
        } else {
            this.setSize(Stereogram.OG.getWidth(), Stereogram.OG.getHeight());
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setXORMode(Color.WHITE);
        if (this.eye == 0) {
            if (OrthoStereogram.BR_glasses) {
                g.drawImage(Stereogram.OD, 0, 0, this);
            } else {
                g.drawImage(Stereogram.OG, 0 + Stereogram.OG.getWidth(), 0, -Stereogram.OG.getWidth(), Stereogram.OG.getHeight(), this);
            }
        } else if (OrthoStereogram.BR_glasses) {
            g.drawImage(Stereogram.OG, 0, 0, this);
        } else {
            g.drawImage(Stereogram.OD, 0 + Stereogram.OD.getWidth(), 0, -Stereogram.OD.getWidth(), Stereogram.OD.getHeight(), this);
        }
    }
}

