/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

class RegQuery {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String PERSONAL_FOLDER_CMD = "reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v Personal";
    private static final String CPU_SPEED_CMD = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ~MHz";
    private static final String CPU_NAME_CMD = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString";
    private static final String DISPLAY_NAME_CMD = "reg query \"HKLM\\SYSTEM\\CurrentControlSet\\Enum\\DISPLAY\" /s /v HardwareID";

    RegQuery() {
    }

    public static String getCurrentUserPersonalFolderPath() {
        try {
            Process process = Runtime.getRuntime().exec(PERSONAL_FOLDER_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCPUSpeed() {
        try {
            Process process = Runtime.getRuntime().exec(CPU_SPEED_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return null;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.toString(Integer.parseInt(temp.substring("0x".length()), 16) + 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCPUName() {
        try {
            Process process = Runtime.getRuntime().exec(DISPLAY_NAME_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf("HardwareID");
            if (p == -1) {
                return null;
            }
            return result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] s) {
        System.out.println("Personal directory : " + RegQuery.getCurrentUserPersonalFolderPath());
        System.out.println("CPU Name : " + RegQuery.getCPUName());
        System.out.println("CPU Speed : " + RegQuery.getCPUSpeed() + " Mhz");
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

