/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;
import orthostereogram.OrthoStereogram;

class ResetStereogram
implements Runnable {
    BufferedImage od;
    BufferedImage og;
    final ThreadLocalRandom rand = ThreadLocalRandom.current();
    int red = -16711681;
    int cyan = -65536;
    int white = Color.WHITE.getRGB();
    int position = 0;
    int size;
    int disparity;
    int game;
    public Graphics2D odGraphics;
    public Graphics2D ogGraphics;

    public ResetStereogram(BufferedImage od, BufferedImage og, int position, int disparity, int game) {
        this.od = od;
        this.og = og;
        this.position = position;
        this.disparity = disparity;
        this.game = game;
        if (!OrthoStereogram.BR_glasses) {
            int t = this.cyan;
            this.cyan = this.red;
            this.red = t;
        }
        this.size = od.getHeight();
        this.odGraphics = od.createGraphics();
        this.ogGraphics = od.createGraphics();
    }

    private void fillAllRandom() {
        this.odGraphics.setPaint(new Color(this.red));
        this.odGraphics.fillRect(0, 0, this.size, this.size);
        this.ogGraphics.setPaint(new Color(this.cyan));
        this.ogGraphics.fillRect(0, 0, this.size, this.size);
    }

    @Override
    public void run() {
        int j;
        int i;
        int dc;
        int dh;
        boolean b;
        for (int i2 = 0; i2 < this.size; ++i2) {
            for (int j2 = 0; j2 < this.size; ++j2) {
                b = this.rand.nextBoolean();
                this.od.setRGB(i2, j2, b ? this.white : this.red);
                this.og.setRGB(i2, j2, b ? this.white : this.cyan);
            }
        }
        int t = this.size / 3;
        int t2 = t / 2;
        int bord = 30;
        switch (this.position) {
            case 0: {
                dh = bord;
                dc = this.size / 2 - t2;
                break;
            }
            case 1: {
                dh = this.size / 2 - t2;
                dc = bord;
                break;
            }
            case 2: {
                dh = this.size / 2 - t2;
                dc = this.size - t - bord;
                break;
            }
            default: {
                dh = this.size - t - bord;
                dc = this.size / 2 - t2;
            }
        }
        if (this.game < 2) {
            for (i = 0; i < t; ++i) {
                for (j = 0; j < t; ++j) {
                    b = this.rand.nextBoolean();
                    this.od.setRGB(dc + i - this.disparity, j + dh, b ? this.white : this.red);
                    this.og.setRGB(dc + i + this.disparity, j + dh, b ? this.white : this.cyan);
                }
            }
        } else {
            for (i = 0; i < t; ++i) {
                for (j = 0; j < t; ++j) {
                    b = this.rand.nextBoolean();
                    double rt = Math.sqrt((i - t2) * (i - t2) + (j - t2) * (j - t2));
                    if (!(rt <= (double)t2)) continue;
                    this.od.setRGB(dc + i - this.disparity, j + dh, b ? this.white : this.red);
                    this.og.setRGB(dc + i + this.disparity, j + dh, b ? this.white : this.cyan);
                }
            }
        }
        if (this.game == 1) {
            switch (this.position) {
                case 0: {
                    this.position = 3;
                    break;
                }
                case 1: {
                    this.position = 2;
                    break;
                }
                case 2: {
                    this.position = 1;
                    break;
                }
                default: {
                    this.position = 0;
                }
            }
            switch (this.position) {
                case 0: {
                    dh = bord;
                    dc = this.size / 2 - t2;
                    break;
                }
                case 1: {
                    dh = this.size / 2 - t2;
                    dc = bord;
                    break;
                }
                case 2: {
                    dh = this.size / 2 - t2;
                    dc = this.size - t - bord;
                    break;
                }
                default: {
                    dh = this.size - t - bord;
                    dc = this.size / 2 - t2;
                }
            }
            this.disparity -= 2;
            for (i = 0; i < t; ++i) {
                for (j = 0; j < t; ++j) {
                    b = this.rand.nextBoolean();
                    this.od.setRGB(dc + i - this.disparity, j + dh, b ? this.white : this.red);
                    this.og.setRGB(dc + i + this.disparity, j + dh, b ? this.white : this.cyan);
                }
            }
        } else if (this.game == 2) {
            int pos3 = 0;
            int pos4 = 0;
            switch (this.position) {
                case 0: {
                    this.position = 3;
                    pos3 = 1;
                    pos4 = 2;
                    break;
                }
                case 1: {
                    this.position = 2;
                    pos3 = 3;
                    pos4 = 0;
                    break;
                }
                case 2: {
                    this.position = 1;
                    pos3 = 0;
                    pos4 = 3;
                    break;
                }
                default: {
                    this.position = 0;
                    pos3 = 2;
                    pos4 = 1;
                }
            }
            this.drawCircle(this.position, this.disparity - 1);
            this.drawCircle(pos3, this.disparity - 2);
            this.drawCircle(pos4, this.disparity - 3);
        }
    }

    private void drawCircle(int pos, int disparity) {
        int dc;
        int dh;
        int t = this.size / 3;
        int t2 = t / 2;
        int bord = 30;
        switch (pos) {
            case 0: {
                dh = bord;
                dc = this.size / 2 - t2;
                break;
            }
            case 1: {
                dh = this.size / 2 - t2;
                dc = bord;
                break;
            }
            case 2: {
                dh = this.size / 2 - t2;
                dc = this.size - t - bord;
                break;
            }
            default: {
                dh = this.size - t - bord;
                dc = this.size / 2 - t2;
            }
        }
        for (int i = 0; i < t; ++i) {
            for (int j = 0; j < t; ++j) {
                boolean b = this.rand.nextBoolean();
                double rt = Math.sqrt((i - t2) * (i - t2) + (j - t2) * (j - t2));
                if (!(rt <= (double)t2)) continue;
                this.od.setRGB(dc + i - disparity, j + dh, b ? this.white : this.red);
                this.og.setRGB(dc + i + disparity, j + dh, b ? this.white : this.cyan);
            }
        }
    }
}

