/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.util.concurrent.ThreadLocalRandom;
import orthostereogram.EyeSlide;

class ResetStereogramSlide
implements Runnable {
    static EyeSlide OD;
    static EyeSlide OG;
    int disparityInPixels;
    boolean resetAll = true;
    final ThreadLocalRandom rand = ThreadLocalRandom.current();
    int white = Color.WHITE.getRGB();

    public ResetStereogramSlide(EyeSlide od, EyeSlide og, int disparity) {
        OD = od;
        OG = og;
        this.disparityInPixels = disparity;
    }

    public void setDisparityInPixels(int disparity, boolean resetAll) {
        this.disparityInPixels = disparity;
        this.resetAll = resetAll;
    }

    @Override
    public void run() {
        int size = EyeSlide.size;
        if (this.resetAll) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    if (!this.rand.nextBoolean()) continue;
                    ResetStereogramSlide.OD.img.setRGB(i, j, this.white);
                    ResetStereogramSlide.OG.img.setRGB(i, j, this.white);
                }
            }
            this.resetAll = false;
        }
        int s1 = size / 4;
        int s2 = size / 2;
        int s3 = 3 * size / 4;
        for (int i = 0; i < s1; ++i) {
            for (int j = 0; j < i; ++j) {
                boolean b = this.rand.nextBoolean();
                int odColor = b ? this.white : ResetStereogramSlide.OD.myCurrentColor;
                int ogColor = b ? this.white : ResetStereogramSlide.OG.myCurrentColor;
                ResetStereogramSlide.OD.img.setRGB(s3 - i - this.disparityInPixels, s2 - j, odColor);
                ResetStereogramSlide.OG.img.setRGB(s3 - i + this.disparityInPixels, s2 - j, ogColor);
                ResetStereogramSlide.OD.img.setRGB(s3 - i - this.disparityInPixels, s2 + j, odColor);
                ResetStereogramSlide.OG.img.setRGB(s3 - i + this.disparityInPixels, s2 + j, ogColor);
                ResetStereogramSlide.OD.img.setRGB(s1 + i - this.disparityInPixels, s2 - j, odColor);
                ResetStereogramSlide.OG.img.setRGB(s1 + i + this.disparityInPixels, s2 - j, ogColor);
                ResetStereogramSlide.OD.img.setRGB(s1 + i - this.disparityInPixels, s2 + j, odColor);
                ResetStereogramSlide.OG.img.setRGB(s1 + i + this.disparityInPixels, s2 + j, ogColor);
            }
        }
    }
}

