/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import orthostereogram.OrthoStereogram;
import orthostereogram.WavSoundThread;

public class Saccades
extends JFrame
implements WindowListener,
MouseMotionListener,
KeyListener {
    int MARGIN_W = 200;
    int MARGIN_H = 100;
    int angle;
    int distance = 70;
    Cursor transparentCursor;
    JLabel item;
    private ScheduledThreadPoolExecutor executor;
    ScheduledFuture<?> schedFuture;
    private int delay_btwn = 1000;
    Random rand = new Random();
    int previous_letter = -1;
    private int charSize;
    private boolean isBold;
    private boolean isMinuscules;
    private boolean charExcluded;
    private boolean drawExtensionCircle = false;

    public Saccades(int size, int delay_btwn, boolean isBold, boolean isMinuscules, int angle, boolean charExcluded) {
        this.charSize = size;
        this.delay_btwn = delay_btwn;
        this.isBold = isBold;
        this.isMinuscules = isMinuscules;
        this.angle = angle;
        this.charExcluded = charExcluded;
        this.setDefaultCloseOperation(2);
        this.setLayout(null);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.CYAN);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.executor = new ScheduledThreadPoolExecutor(1);
    }

    public void setAppearence() {
        this.addKeyListener(this);
        this.addWindowListener(this);
    }

    public static int random(Random r, int n) {
        int val;
        int bits;
        if ((n & -n) == n) {
            return (int)((long)n * (long)r.nextInt() >> 31);
        }
        while ((bits = r.nextInt()) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    private String getRandomChar() {
        int letter;
        while (this.charExcluded & ((letter = Saccades.random(this.rand, 26)) == 22 | letter == 24) | letter == this.previous_letter) {
        }
        char c = this.isMinuscules ? (char)(letter + 97) : (char)(letter + 65);
        this.previous_letter = letter;
        return String.valueOf(c);
    }

    private Point getRandomPosition() {
        double h = (double)(96 * this.distance) * Math.sin(Math.toRadians((double)this.angle / 2.0)) / 2.54;
        h = Math.min(h, (double)(this.getHeight() - this.MARGIN_H - this.item.getHeight()));
        double d = Saccades.random(this.rand, (int)h);
        double a = Saccades.random(this.rand, 360);
        a = a / 180.0 * Math.PI;
        double x = d * Math.cos(a);
        double y = d * Math.sin(a);
        return new Point(this.getWidth() / 2 + (int)x, this.getHeight() / 2 + (int)y);
    }

    public void timeOut() {
        Point where = this.getRandomPosition();
        new WavSoundThread(1).start();
        this.item.setText(this.getRandomChar());
        this.item.setLocation(where.x, where.y);
    }

    public void hideCursor() {
        this.setCursor(this.transparentCursor);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        OrthoStereogram.newController.setEnabled(false);
        this.hideCursor();
        this.item = new JLabel(this.getRandomChar(), 0);
        Font itemFont = this.item.getFont();
        if (this.isBold) {
            this.item.setFont(new Font(itemFont.getName(), 1, this.charSize));
        } else {
            this.item.setFont(new Font(itemFont.getName(), 0, this.charSize));
        }
        this.item.setBounds(this.getWidth() / 2 - this.item.getWidth() / 2, this.getHeight() / 2 - this.item.getHeight() / 2, 40, 40);
        this.item.setForeground(Color.BLACK);
        this.item.setBackground(Color.CYAN);
        this.item.setOpaque(true);
        this.getContentPane().add(this.item);
        JLabel instructions = new JLabel("<\u00e9chap> : quitter  <espace> : d\u00e9marrer/arr\u00eater   <e> : voir extension", 0);
        instructions.setForeground(Color.GRAY);
        instructions.setBounds(10, this.getHeight() - 40, 400, 40);
        this.getContentPane().add(instructions);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.executor.shutdownNow();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        OrthoStereogram.newController.setEnabled(true);
        OrthoStereogram.newController.setVisible(true);
        OrthoStereogram.newController.setState(0);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.drawExtensionCircle) {
            double h = (double)(96 * this.distance) * Math.sin(Math.toRadians((double)this.angle / 2.0)) / 2.54;
            h = Math.min(h, (double)(this.getHeight() - this.MARGIN_H - this.item.getHeight()));
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(Color.GRAY);
            g2d.drawOval(this.getWidth() / 2 - (int)h, this.getHeight() / 2 - (int)h, 2 * (int)h, 2 * (int)h);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        char c = ke.getKeyChar();
        if (keyCode == 27) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (keyCode == 32) {
            if (this.executor.getQueue().isEmpty()) {
                this.executor.setCorePoolSize(1);
                this.schedFuture = this.executor.scheduleAtFixedRate(() -> this.timeOut(), 1L, this.delay_btwn, TimeUnit.MILLISECONDS);
            } else {
                this.executor.shutdownNow();
                this.executor = new ScheduledThreadPoolExecutor(1);
            }
        } else if (c == 'f') {
            if (this.item.getBackground() == Color.red) {
                this.item.setBackground(Color.CYAN);
            } else {
                this.item.setBackground(Color.RED);
            }
        } else if (c == 'e') {
            this.drawExtensionCircle = !this.drawExtensionCircle;
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

