/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import orthostereogram.Anaglyph;
import orthostereogram.NewController;
import orthostereogram.OneEye;
import orthostereogram.OrthoStereogram;
import orthostereogram.Stereogram;

public final class SlideStereogramView
extends JFrame
implements WindowListener,
MouseMotionListener,
KeyListener {
    Anaglyph anaglyph;
    private static Stereogram bimage;
    private OneEye od;
    private OneEye og;
    private int deltaX = 0;
    private int deltaY = 0;
    Cursor transparentCursor;
    private JLabel info;
    final ScheduledThreadPoolExecutor executor;
    boolean randomJumps = false;
    boolean keypressedIsActive = false;
    Random rand = new Random();
    boolean isRunning = false;
    private int askedMax;
    private int askedMin;
    private int minPixels = -200;
    private int maxPixels = 400;
    private int timeout = 150;
    private int hDirection = 37;
    private int vDirection = 38;
    private int minVPixels = 0;
    private int maxVPixels = 0;
    private boolean isThereVerticality = false;
    private int disparityMin;
    private int disparityMax;
    private int disparityStep;
    static Dimension screenSize;
    static int workingDistance;

    public SlideStereogramView(int speed, int min, int max, int workingDistance, int initialValue, double verticalityMin, double verticalityMax, int disparityMin, int disparityMax, int disparityStep) {
        this.disparityMin = disparityMin;
        this.disparityMax = disparityMax;
        this.disparityStep = disparityStep;
        this.askedMax = max;
        this.askedMin = min;
        if (verticalityMin != 0.0) {
            this.isThereVerticality = true;
            this.minVPixels = -this.calcPixelsForVergence(0.25 * verticalityMin);
            this.maxVPixels = this.calcPixelsForVergence(0.25 * verticalityMin);
        }
        this.minPixels = this.calcPixelsForVergence(min);
        this.maxPixels = this.calcPixelsForVergence(max);
        SlideStereogramView.workingDistance = workingDistance;
        this.deltaX = this.calcPixelsForVergence(initialValue);
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.setDefaultCloseOperation(2);
        this.setTitle("St\u00e9r\u00e9ogramme: ");
        this.setLayout(null);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.WHITE);
        this.executor = new ScheduledThreadPoolExecutor(1);
        switch (speed) {
            case 0: {
                this.timeout = 200;
                break;
            }
            case 1: {
                this.timeout = 150;
                break;
            }
            case 2: {
                this.timeout = 100;
                break;
            }
            case 3: {
                this.timeout = 50;
                break;
            }
            case 4: {
                this.timeout = 25;
            }
        }
        this.setVisible(true);
    }

    public void setAppearence(boolean randomJumps) {
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addWindowListener(this);
        this.randomJumps = randomJumps;
    }

    public int calcPixelsForVergence(double vergence) {
        double pixels = vergence * (double)workingDistance / 254.0 * OrthoStereogram.screenResolution1;
        return (int)Math.round(pixels / 2.0);
    }

    public double calcVergenceForPixels(int pixels) {
        double vergence = (double)(pixels * 254 * 2) / (OrthoStereogram.screenResolution1 * (double)workingDistance);
        return vergence;
    }

    public void setPositions() {
        this.od.setLocation((this.getWidth() - this.od.getWidth()) / 2 - this.deltaX, (this.getHeight() - this.od.getHeight()) / 2 - this.deltaY);
        this.og.setLocation((this.getWidth() - this.og.getWidth()) / 2 + this.deltaX, (this.getHeight() - this.og.getHeight()) / 2 + this.deltaY);
    }

    public void timeOut() {
        if (this.deltaX < this.minPixels) {
            this.hDirection = 39;
        } else if (this.deltaX > this.maxPixels) {
            this.hDirection = 37;
        }
        if (this.isThereVerticality) {
            if (this.deltaY < this.minVPixels) {
                this.vDirection = 38;
            } else if (this.deltaY > this.maxVPixels) {
                this.vDirection = 40;
            }
            this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, this.vDirection, 'A'));
        }
        this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, this.hDirection, 'A'));
    }

    public void hideCursor() {
        this.setCursor(this.transparentCursor);
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (this.keypressedIsActive) {
            return;
        }
        int keyCode = ke.getKeyCode();
        if (keyCode == 32 && !this.isRunning) {
            this.executor.scheduleAtFixedRate(() -> this.timeOut(), 0L, this.timeout, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        } else if (keyCode == 27) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (keyCode == 37) {
            --this.deltaX;
            this.setPositions();
        } else if (keyCode == 39) {
            ++this.deltaX;
            this.setPositions();
        } else if (keyCode == 38) {
            ++this.deltaY;
            this.setPositions();
        } else if (keyCode == 40) {
            --this.deltaY;
            this.setPositions();
        } else if (keyCode == 32) {
            this.deltaX = 0;
            this.deltaY = 0;
            this.hDirection = 37;
            this.vDirection = 38;
        }
        if ((keyCode == 109 | keyCode == 54) & ke.isControlDown() & !ke.isShiftDown()) {
            this.keypressedIsActive = true;
            if (NewController.imgScale(0.9)) {
                bimage.resize(NewController.imgSize, true);
                this.od.resize();
                Anaglyph.createStereoscopicBlueImage(Stereogram.OD);
                this.og.resize();
                Anaglyph.createStereoscopicRedImage(Stereogram.OG);
                this.setPositions();
            }
        } else if (keyCode == 107 & ke.isControlDown() & !ke.isShiftDown()) {
            this.keypressedIsActive = true;
            if (NewController.imgScale(1.1)) {
                bimage.resize(NewController.imgSize, true);
                this.od.resize();
                Anaglyph.createStereoscopicBlueImage(Stereogram.OD);
                this.og.resize();
                Anaglyph.createStereoscopicRedImage(Stereogram.OG);
                this.setPositions();
            }
        } else if (keyCode == 61 & ke.isControlDown() & ke.isShiftDown()) {
            this.keypressedIsActive = true;
            if (NewController.imgScale(1.1)) {
                bimage.resize(NewController.imgSize, true);
                this.od.resize();
                Anaglyph.createStereoscopicBlueImage(Stereogram.OD);
                this.og.resize();
                Anaglyph.createStereoscopicRedImage(Stereogram.OG);
                this.setPositions();
            }
        } else if (keyCode == 38 & ke.isControlDown()) {
            ++this.askedMax;
            this.maxPixels = this.calcPixelsForVergence(this.askedMax);
        } else if (keyCode == 40 & ke.isControlDown()) {
            --this.askedMax;
            this.maxPixels = this.calcPixelsForVergence(this.askedMax);
        } else if (keyCode == 38 & ke.isShiftDown()) {
            ++this.askedMin;
            this.minPixels = this.calcPixelsForVergence(this.askedMin);
        } else if (keyCode == 40 & ke.isShiftDown()) {
            --this.askedMin;
            this.minPixels = this.calcPixelsForVergence(this.askedMin);
        }
        this.hideCursor();
        this.keypressedIsActive = false;
        this.info.setText("[" + this.askedMin + ", " + this.askedMax + "] : " + String.format("%+2.1f", this.calcVergenceForPixels(this.deltaX)));
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void windowOpened(WindowEvent we) {
        bimage = new Stereogram(NewController.imgSize, workingDistance, 0, true, this.disparityMin);
        bimage.resetImg(false);
        this.anaglyph = new Anaglyph();
        Anaglyph.createStereoscopicBlueImage(Stereogram.OD);
        this.og = new OneEye(0);
        Anaglyph.createStereoscopicRedImage(Stereogram.OG);
        this.od = new OneEye(1);
        this.setPositions();
        this.getContentPane().add(this.od);
        this.getContentPane().add(this.og);
        this.od.setVisible(true);
        this.og.setVisible(true);
        this.info = new JLabel("<espace> pour d\u00e9marrer...");
        this.info.setBounds(10, 10, 300, 30);
        this.getContentPane().add(this.info);
        this.hideCursor();
        this.repaint();
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.executor.shutdownNow();
    }

    @Override
    public void windowClosed(WindowEvent we) {
        OrthoStereogram.newController.setEnabled(true);
        OrthoStereogram.newController.setVisible(true);
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowActivated(WindowEvent we) {
        OrthoStereogram.newController.setEnabled(false);
        this.hideCursor();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    static {
        workingDistance = 70;
    }
}

