/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLabel;
import orthostereogram.EyeSlide;
import orthostereogram.NewController;
import orthostereogram.OrthoStereogram;
import orthostereogram.ResetStereogramSlide;

public class SliderStereogram_v2
extends JFrame
implements WindowListener,
KeyListener {
    private int workingDistance;
    private int vergenceInit;
    private int vergenceMin;
    private int vergenceMax;
    private double verticalityMin;
    private double verticalityMax;
    private int disparityMin;
    private int disparityMax;
    private int disparityStep;
    private boolean isThereVerticality = false;
    private int minVPixels;
    private int maxVPixels;
    private int minHPixels;
    private int maxHPixels;
    private JLabel infosHLabel;
    private JLabel infosVLabel;
    private JLabel infosZLabel;
    private JLabel infosCommandes;
    private Cursor transparentCursor;
    private static EyeSlide OD;
    private static EyeSlide OG;
    private static ResetStereogramSlide resetStereogramSlide;
    private boolean dessinFluctuant;
    private final ScheduledThreadPoolExecutor timerExecutor;
    private Future<?> future;
    private int timerTimeout;
    private boolean timerIsRunning;
    private long timerTickCount = 0L;
    private int deltaXPixels;
    private int deltaYPixels;
    private int deltaZPixels;
    private int hIncrement;
    private int vIncrement;
    private boolean resizingIsActive = false;

    public SliderStereogram_v2(int speed, int vergenceMin, int vergenceMax, int workingDistance, int vergenceInit, double verticalityMin, double verticalityMax, int disparityMin, int disparityMax) {
        this.vergenceMin = vergenceMin;
        this.vergenceMax = vergenceMax;
        this.vergenceInit = vergenceInit;
        this.verticalityMin = verticalityMin;
        this.verticalityMax = verticalityMax;
        this.disparityMin = disparityMin;
        this.disparityMax = disparityMax;
        this.disparityStep = this.disparityStep;
        this.workingDistance = workingDistance;
        if (verticalityMin != 0.0 | verticalityMax != 0.0) {
            this.isThereVerticality = true;
            this.minVPixels = -this.calcPixelsForVergence(verticalityMin);
            this.maxVPixels = this.calcPixelsForVergence(verticalityMax);
            this.vIncrement = 1;
        } else {
            this.vIncrement = 0;
        }
        this.minHPixels = this.calcPixelsForVergence(vergenceMin);
        this.maxHPixels = this.calcPixelsForVergence(vergenceMax);
        this.deltaXPixels = this.calcPixelsForVergence(vergenceInit);
        this.deltaYPixels = 0;
        this.deltaZPixels = disparityMin;
        this.disparityStep = disparityMin == disparityMax ? 0 : 1;
        this.hIncrement = vergenceMin == vergenceMax ? 0 : 1;
        this.dessinFluctuant = true;
        this.setDefaultCloseOperation(2);
        this.setLayout(null);
        this.setUndecorated(true);
        this.getContentPane().setBackground(Color.WHITE);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.timerIsRunning = false;
        this.timerExecutor = new ScheduledThreadPoolExecutor(1);
        switch (speed) {
            case 0: {
                this.timerTimeout = 200;
                break;
            }
            case 1: {
                this.timerTimeout = 150;
                break;
            }
            case 2: {
                this.timerTimeout = 100;
                break;
            }
            case 3: {
                this.timerTimeout = 50;
                break;
            }
            case 4: {
                this.timerTimeout = 25;
                break;
            }
            default: {
                this.timerTimeout = 25;
            }
        }
    }

    public void initSliderStereogram_v2() {
        this.addKeyListener(this);
        this.addWindowListener(this);
    }

    public int calcPixelsForVergence(double vergence) {
        double pixels = vergence * (double)this.workingDistance / 254.0 * OrthoStereogram.screenResolution1;
        return (int)Math.round(pixels / 2.0);
    }

    public double calcVergenceForPixels(int pixels) {
        double vergence = (double)(pixels * 254 * 2) / (OrthoStereogram.screenResolution1 * (double)this.workingDistance);
        return vergence;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.infosHLabel = new JLabel("");
        this.infosHLabel.setBounds(10, 10, 300, 30);
        this.getContentPane().add(this.infosHLabel);
        this.infosVLabel = new JLabel("");
        this.infosVLabel.setBounds(10, 35, 300, 30);
        this.infosVLabel.setForeground(Color.GRAY);
        this.getContentPane().add(this.infosVLabel);
        this.infosZLabel = new JLabel("");
        this.infosZLabel.setBounds(10, 60, 300, 30);
        this.infosZLabel.setForeground(Color.GRAY);
        this.getContentPane().add(this.infosZLabel);
        this.infosCommandes = new JLabel("<espace> pour d\u00e9marrer...");
        this.infosCommandes.setForeground(Color.LIGHT_GRAY);
        this.infosCommandes.setBounds(10, this.getHeight() - 40, 420, 30);
        this.getContentPane().add(this.infosCommandes);
        OD = new EyeSlide(NewController.imgSize, true);
        OG = new EyeSlide(NewController.imgSize, false);
        this.getContentPane().add(OD);
        this.getContentPane().add(OG);
        this.setPositions();
        resetStereogramSlide = new ResetStereogramSlide(OD, OG, this.deltaZPixels);
        resetStereogramSlide.run();
        OD.repaint();
        OG.repaint();
        this.setCursor(this.transparentCursor);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.timerExecutor.shutdownNow();
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (this.resizingIsActive) {
            return;
        }
        int keyCode = ke.getKeyCode();
        if (keyCode == 27) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (keyCode == 32 && !this.timerIsRunning) {
            this.future = this.timerExecutor.scheduleAtFixedRate(() -> this.timerTickEvent(), 0L, this.timerTimeout, TimeUnit.MILLISECONDS);
            this.timerIsRunning = true;
        } else if (keyCode == 32 & ke.isControlDown()) {
            this.future.cancel(true);
            this.deltaXPixels = 0;
            this.deltaYPixels = 0;
            this.hIncrement = 1;
            this.vIncrement = 1;
            this.timerIsRunning = false;
            this.setPositions();
            this.updateInfosLabels();
        } else if (keyCode == 32) {
            this.future.cancel(true);
            this.deltaXPixels = 0;
            this.deltaYPixels = 0;
            this.hIncrement = 1;
            this.vIncrement = 1;
            this.setPositions();
            this.future = this.timerExecutor.scheduleAtFixedRate(() -> this.timerTickEvent(), 1000L, this.timerTimeout, TimeUnit.MILLISECONDS);
        } else if (keyCode == 70) {
            this.dessinFluctuant = !this.dessinFluctuant;
        }
        if ((keyCode == 109 | keyCode == 54) & ke.isControlDown() & !ke.isShiftDown()) {
            this.resizingIsActive = true;
            if (NewController.imgScale(0.9)) {
                OD.resize(NewController.imgSize);
                OG.resize(NewController.imgSize);
                this.setPositions();
                resetStereogramSlide.setDisparityInPixels(this.deltaZPixels, true);
                resetStereogramSlide.run();
            }
        } else if (keyCode == 107 & ke.isControlDown() & !ke.isShiftDown()) {
            this.resizingIsActive = true;
            if (NewController.imgScale(1.1)) {
                OD.resize(NewController.imgSize);
                OG.resize(NewController.imgSize);
                this.setPositions();
                resetStereogramSlide.setDisparityInPixels(this.deltaZPixels, true);
                resetStereogramSlide.run();
            }
        } else if (keyCode == 61 & ke.isControlDown() & ke.isShiftDown()) {
            this.resizingIsActive = true;
            if (NewController.imgScale(1.1)) {
                OD.resize(NewController.imgSize);
                OG.resize(NewController.imgSize);
                this.setPositions();
                resetStereogramSlide.setDisparityInPixels(this.deltaZPixels, true);
                resetStereogramSlide.run();
            }
        }
        if (this.timerIsRunning) {
            this.updateInfosLabels();
        }
        this.resizingIsActive = false;
    }

    private void updateInfosLabels() {
        if (this.timerIsRunning) {
            this.infosCommandes.setText("<Espace> remise \u00e0 z\u00e9ro <ctrl+espace> pause \u00e0 z\u00e9ro <F> toggle flickering");
        } else {
            this.infosCommandes.setText("<Espace> pour d\u00e9marer...");
        }
        this.infosHLabel.setText("H [" + this.vergenceMin + ", " + this.vergenceMax + "] : " + String.format("%+2.1f", this.calcVergenceForPixels(this.deltaXPixels)));
        if (this.deltaYPixels > 0) {
            this.infosVLabel.setText("V [" + this.verticalityMin + ", " + String.format("%+2.1f", this.verticalityMax) + "] : HD" + String.format("%+2.1f", this.calcVergenceForPixels(this.deltaYPixels)));
        } else {
            this.infosVLabel.setText("V [" + this.verticalityMin + ", " + String.format("%+2.1f", this.verticalityMax) + "] : HG" + String.format("%+2.1f", Math.abs(this.calcVergenceForPixels(this.deltaYPixels))));
        }
        this.infosZLabel.setText("Z [" + this.disparityMin + ", " + this.disparityMax + "] : " + this.deltaZPixels);
    }

    public void timerTickEvent() {
        ++this.timerTickCount;
        if (this.hIncrement != 0) {
            if (this.deltaXPixels < this.minHPixels) {
                this.hIncrement = -this.hIncrement;
            } else if (this.deltaXPixels > this.maxHPixels) {
                this.hIncrement = -this.hIncrement;
            }
            this.deltaXPixels += this.hIncrement;
        }
        if (this.vIncrement != 0) {
            if (this.deltaYPixels + this.vIncrement < this.minVPixels || this.deltaYPixels + this.vIncrement > this.maxVPixels) {
                this.vIncrement = -this.vIncrement;
            }
            this.deltaYPixels += this.vIncrement;
        }
        if (this.disparityStep != 0 & this.timerTickCount % 10L == 0L) {
            if (this.deltaZPixels < this.disparityMin) {
                this.disparityStep = -this.disparityStep;
            } else if (this.deltaZPixels > this.disparityMax) {
                this.disparityStep = -this.disparityStep;
            }
            this.deltaZPixels += this.disparityStep;
            resetStereogramSlide.setDisparityInPixels(this.deltaZPixels, false);
        }
        if (this.dessinFluctuant & this.timerTickCount % 10L == 0L) {
            resetStereogramSlide.run();
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        try {
            Robot robot = new Robot();
            robot.mouseMove(point.x + 1, point.y);
            robot.mouseMove(point.x, point.y);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.setPositions();
        this.updateInfosLabels();
    }

    public void setPositions() {
        OD.setLocation((this.getWidth() - OD.getWidth()) / 2 - this.deltaXPixels, (this.getHeight() - OD.getHeight()) / 2 - this.deltaYPixels);
        OG.setLocation((this.getWidth() - OG.getWidth()) / 2 + this.deltaXPixels, (this.getHeight() - OG.getHeight()) / 2 + this.deltaYPixels);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

