/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.Random;
import javax.swing.JPanel;
import orthostereogram.Anaglyph;
import orthostereogram.OrthoStereogram;

public class Stereogram
extends JPanel {
    public static BufferedImage OD;
    public static BufferedImage OG;
    public static BufferedImage ana;
    private static Anaglyph anaglyph;
    public int clue;
    public static int deltaPixelsX;
    public static double currentVergenceValue;
    SecureRandom securRand = new SecureRandom();
    Random rand = new Random();
    private static int disparity;
    private boolean centered = false;
    static Dimension screenSize;
    static int screenResolution;
    static int workingDistance;

    public Stereogram(int stereogramSize, int workingDistance, int initialDelta, boolean centered, int disparity) {
        Stereogram.disparity = disparity;
        this.centered = centered;
        Stereogram.workingDistance = workingDistance;
        if ((stereogramSize & 1) != 0) {
            --stereogramSize;
        }
        screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        currentVergenceValue = initialDelta;
        deltaPixelsX = this.calcPixelsForVergence(initialDelta);
        OD = new BufferedImage(stereogramSize, stereogramSize, 1);
        OG = new BufferedImage(stereogramSize, stereogramSize, 1);
        ana = new BufferedImage(stereogramSize + Math.abs(deltaPixelsX), stereogramSize, 1);
        this.setSize(stereogramSize + Math.abs(deltaPixelsX), stereogramSize);
        anaglyph = new Anaglyph();
    }

    public int calcPixelsForVergence(double vergence) {
        double pixels = vergence * (double)workingDistance / 100.0 / (double)2.54f * (double)screenResolution;
        return (int)Math.round(pixels);
    }

    public void stepVergence(double delta) {
        deltaPixelsX = this.calcPixelsForVergence(currentVergenceValue += delta);
        this.resize(OD.getWidth(), false);
    }

    public void goToVergence(double value) {
        currentVergenceValue = value;
        deltaPixelsX = this.calcPixelsForVergence(value);
        this.resize(OD.getWidth(), false);
    }

    public void resize(int newSize, boolean keepClue) {
        OD.flush();
        OD = null;
        OG.flush();
        OG = null;
        ana.flush();
        ana = null;
        OD = new BufferedImage(newSize, newSize, 1);
        OG = new BufferedImage(newSize, newSize, 1);
        ana = new BufferedImage(newSize + Math.abs(deltaPixelsX), newSize, 1);
        this.resetImg(keepClue);
        this.setSize(newSize + Math.abs(deltaPixelsX), newSize);
        this.repaint();
    }

    public void resetImg(boolean keepClue) {
        int dc;
        int dh;
        int p;
        int couleurRGB = 0;
        int taille = OD.getHeight();
        for (int i = 0; i < taille; ++i) {
            for (int j = 0; j < taille; ++j) {
                couleurRGB = this.rand.nextBoolean() ? Color.BLACK.getRGB() : Color.WHITE.getRGB();
                OD.setRGB(i, j, couleurRGB);
                OG.setRGB(i, j, couleurRGB);
            }
        }
        int t = taille / 3;
        int bord = 30;
        if (keepClue) {
            switch (this.clue) {
                case 38: {
                    p = 0;
                    break;
                }
                case 37: {
                    if (OrthoStereogram.BR_glasses) {
                        p = 1;
                        break;
                    }
                    p = 2;
                    break;
                }
                case 39: {
                    if (OrthoStereogram.BR_glasses) {
                        p = 2;
                        break;
                    }
                    p = 1;
                    break;
                }
                default: {
                    p = 3;
                    break;
                }
            }
        } else {
            p = this.securRand.nextInt(4);
        }
        switch (p) {
            case 0: {
                dh = bord;
                dc = taille / 2 - t / 2;
                this.clue = 38;
                break;
            }
            case 1: {
                dh = taille / 2 - t / 2;
                dc = bord;
                this.clue = 37;
                break;
            }
            case 2: {
                dh = taille / 2 - t / 2;
                dc = taille - t - bord;
                this.clue = 39;
                break;
            }
            default: {
                dh = taille - t - bord;
                dc = taille / 2 - t / 2;
                this.clue = 40;
            }
        }
        if (this.centered) {
            t = taille / 2;
            dh = dc = (taille - t) / 2;
            boolean c = false;
            for (int i = 0; i < t / 2; ++i) {
                for (int j = 0; j < i; ++j) {
                    couleurRGB = this.rand.nextBoolean() ? Color.BLACK.getRGB() : Color.WHITE.getRGB();
                    OG.setRGB(taille / 4 + i - disparity, taille / 2 + j, couleurRGB);
                    OD.setRGB(taille / 4 + i + disparity, taille / 2 + j, couleurRGB);
                    OG.setRGB(taille / 4 + i - disparity, taille / 2 - j, couleurRGB);
                    OD.setRGB(taille / 4 + i + disparity, taille / 2 - j, couleurRGB);
                    OG.setRGB(3 * taille / 4 - i - disparity, taille / 2 + j, couleurRGB);
                    OD.setRGB(3 * taille / 4 - i + disparity, taille / 2 + j, couleurRGB);
                    OG.setRGB(3 * taille / 4 - i - disparity, taille / 2 - j, couleurRGB);
                    OD.setRGB(3 * taille / 4 - i + disparity, taille / 2 - j, couleurRGB);
                }
            }
        } else {
            for (int i = 0; i < t; ++i) {
                for (int j = 0; j < t; ++j) {
                    couleurRGB = this.rand.nextBoolean() ? Color.BLACK.getRGB() : Color.WHITE.getRGB();
                    OG.setRGB(dc + i - disparity, j + dh, couleurRGB);
                    OD.setRGB(dc + i + disparity, j + dh, couleurRGB);
                }
            }
        }
        Anaglyph.createStereoscopicCombinedImage(OG, OD, ana, deltaPixelsX);
        if (OrthoStereogram.BR_glasses) {
            if (deltaPixelsX < 0 & this.clue == 37) {
                this.clue = 39;
            } else if (deltaPixelsX < 0 & this.clue == 39) {
                this.clue = 37;
            }
        } else if (deltaPixelsX >= 0 & this.clue == 37) {
            this.clue = 39;
        } else if (deltaPixelsX >= 0 & this.clue == 39) {
            this.clue = 37;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        if (OrthoStereogram.BR_glasses) {
            if (deltaPixelsX >= 0) {
                g.drawImage(ana, 0, 0, this);
            } else {
                g.drawImage(ana, 0 + ana.getWidth(), 0, -ana.getWidth(), ana.getHeight(), this);
            }
        } else if (deltaPixelsX >= 0) {
            g.drawImage(ana, 0 + ana.getWidth(), 0, -ana.getWidth(), ana.getHeight(), this);
        } else {
            g.drawImage(ana, 0, 0, this);
        }
    }

    static {
        workingDistance = 70;
    }
}

