/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import orthostereogram.CSVDatas;
import orthostereogram.DoubleStereogram;
import orthostereogram.ImageStereogramView;
import orthostereogram.NewController;
import orthostereogram.OrthoStereogram;
import orthostereogram.SlideStereogramView;
import orthostereogram.SliderStereogram_v2;

class VergencePanel
extends JPanel {
    NewController parent = null;
    JSpinner screenDistance;
    JSpinner initialValue;
    JSpinner minConvValue;
    JSpinner maxConvValue;
    JSpinner stepDivValue;
    JSpinner stepConvValue;
    JSpinner vMinValue;
    JSpinner vMaxValue;
    JSpinner stepVertValue;
    JSpinner dMinValue;
    JSpinner dMaxValue;
    JSpinner stepDispValue;
    JLabel distLabel;
    int vPos = 155;
    int hPos = 125;
    int vPos2 = 220;
    int hPos2 = 125;
    int vPos3 = 285;
    int hPos3 = 125;
    ChartPanel chartPanel1;
    ChartPanel chartPanel2;
    JFreeChart chart1;
    JFreeChart chart2;
    XYSeries xySerieMax;
    XYSeries xySerieTime;

    public VergencePanel(NewController p) {
        this.parent = p;
    }

    public void initPanel() {
        this.setLayout(null);
        this.setBackground(Color.CYAN);
        this.distLabel = new JLabel("Ecran :");
        this.distLabel.setFont(this.distLabel.getFont().deriveFont(13.0f));
        this.distLabel.setBounds(25, 20, 100, 30);
        this.add(this.distLabel);
        this.distLabel.setToolTipText("Cliquez pour changer");
        this.screenDistance = new JSpinner(new SpinnerNumberModel(70, 20, 500, 10));
        this.screenDistance.setBounds(105, 25, 50, 22);
        this.screenDistance.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        this.screenDistance.setValue(OrthoStereogram.screenDistance1);
        this.screenDistance.setEnabled(false);
        this.add(this.screenDistance);
        this.distLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (VergencePanel.this.distLabel.getText().equals("Ecran :")) {
                    VergencePanel.this.distLabel.setText("Vid\u00e9oProj.:");
                    VergencePanel.this.screenDistance.setValue(OrthoStereogram.screenDistance2);
                    double t = OrthoStereogram.screenResolution1;
                    OrthoStereogram.screenResolution1 = OrthoStereogram.screenResolution2;
                    OrthoStereogram.screenResolution2 = t;
                } else {
                    VergencePanel.this.distLabel.setText("Ecran :");
                    VergencePanel.this.screenDistance.setValue(OrthoStereogram.screenDistance1);
                    double t = OrthoStereogram.screenResolution1;
                    OrthoStereogram.screenResolution1 = OrthoStereogram.screenResolution2;
                    OrthoStereogram.screenResolution2 = t;
                }
            }
        });
        JLabel JunitCM = new JLabel("cm");
        JunitCM.setFont(JunitCM.getFont().deriveFont(JunitCM.getFont().getStyle() | 2, 13.0f));
        JunitCM.setBounds(165, 20, 120, 30);
        this.add(JunitCM);
        this.parent.xBoxIcon = new JLabel("");
        this.parent.xBoxIcon.setBounds(200, 50, 64, 64);
        this.parent.xBoxIcon.setIcon(new ImageIcon(this.parent.xboxImage));
        this.parent.xBoxIcon.setEnabled(OrthoStereogram.xboxConnected);
        this.add(this.parent.xBoxIcon);
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                OrthoStereogram.controllers.update();
                OrthoStereogram.xboxConnected = OrthoStereogram.controllers.getNumControllers() > 0;
                VergencePanel.this.parent.xBoxIcon.setEnabled(OrthoStereogram.xboxConnected);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        this.parent.imgLunettes = new JLabel("");
        this.parent.imgLunettes.setBounds(285, 0, 160, 128);
        this.updateAnaglyph();
        this.add(this.parent.imgLunettes);
        this.parent.imgLunettes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OrthoStereogram.BR_glasses = !OrthoStereogram.BR_glasses;
                VergencePanel.this.updateAnaglyph();
            }
        });
        this.parent.calibLabel = new JLabel("Calibration ?");
        this.parent.calibLabel.setFont(this.distLabel.getFont().deriveFont(13.0f));
        this.parent.calibLabel.setBounds(25, 65, 160, 30);
        this.add(this.parent.calibLabel);
        this.updateCalibrationStatus();
        JPanel p1 = new JPanel();
        p1.setBounds(10, 10, 435, 110);
        p1.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add(p1);
        JLabel title1Label = new JLabel("Horizontalit\u00e9:");
        title1Label.setFont(title1Label.getFont().deriveFont(16.0f));
        title1Label.setBounds(this.hPos - 110, this.vPos - 4, 120, 28);
        this.add(title1Label);
        this.initialValue = new JSpinner(new SpinnerNumberModel(0, -30, 50, 1));
        this.initialValue.setToolTipText("Valeur initiale");
        this.initialValue.setBounds(this.hPos + 130, this.vPos, 50, 22);
        this.initialValue.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        this.initialValue.setEnabled(false);
        this.add(this.initialValue);
        this.minConvValue = new JSpinner(new SpinnerNumberModel(-3, -3, 10, 1));
        this.minConvValue.setToolTipText("Valeur minimum");
        this.minConvValue.setBounds(this.hPos, this.vPos, 50, 22);
        this.minConvValue.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        this.minConvValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i;
                int m = (Integer)VergencePanel.this.minConvValue.getValue();
                if (m > (i = ((Integer)VergencePanel.this.initialValue.getValue()).intValue())) {
                    VergencePanel.this.minConvValue.setValue(i);
                }
            }
        });
        this.add(this.minConvValue);
        this.maxConvValue = new JSpinner(new SpinnerNumberModel(5, -3, 10, 1));
        this.maxConvValue.setToolTipText("Valeur maximale");
        this.maxConvValue.setBounds(this.hPos + 260, this.vPos, 50, 22);
        this.maxConvValue.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        this.maxConvValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i;
                int m = (Integer)VergencePanel.this.maxConvValue.getValue();
                if (m < (i = ((Integer)VergencePanel.this.initialValue.getValue()).intValue())) {
                    VergencePanel.this.maxConvValue.setValue(i);
                }
            }
        });
        this.add(this.maxConvValue);
        this.initialValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int M = (Integer)VergencePanel.this.maxConvValue.getValue();
                int m = (Integer)VergencePanel.this.minConvValue.getValue();
                int i = (Integer)VergencePanel.this.initialValue.getValue();
                if (i < m) {
                    VergencePanel.this.initialValue.setValue(m);
                } else if (i > M) {
                    VergencePanel.this.initialValue.setValue(M);
                }
            }
        });
        JLabel jUnit = new JLabel("\u0394");
        jUnit.setBounds(this.hPos + 320, this.vPos, 30, 22);
        jUnit.setFont(jUnit.getFont().deriveFont(14.0f));
        this.add(jUnit);
        this.stepDivValue = new JSpinner(new SpinnerNumberModel(1.0, 0.25, 10.0, 0.25));
        this.stepDivValue.setToolTipText("Step");
        this.stepDivValue.setBounds(this.hPos + 55, this.vPos + 15, 50, 20);
        this.stepDivValue.setFont(this.stepDivValue.getFont().deriveFont(12.0f));
        ((JSpinner.DefaultEditor)this.stepDivValue.getEditor()).getTextField().setForeground(Color.GRAY);
        this.stepDivValue.setOpaque(false);
        this.stepDivValue.getEditor().setOpaque(false);
        ((JSpinner.DefaultEditor)this.stepDivValue.getEditor()).getTextField().setOpaque(false);
        this.stepDivValue.setBorder(null);
        this.stepDivValue.setEnabled(false);
        this.add(this.stepDivValue);
        this.stepConvValue = new JSpinner(new SpinnerNumberModel(2.0, 0.5, 10.0, 0.5));
        this.stepConvValue.setToolTipText("Step");
        this.stepConvValue.setBounds(this.hPos + 180, this.vPos + 15, 50, 20);
        this.stepConvValue.setFont(this.screenDistance.getFont().deriveFont(12.0f));
        ((JSpinner.DefaultEditor)this.stepConvValue.getEditor()).getTextField().setForeground(Color.GRAY);
        this.stepConvValue.setOpaque(false);
        this.stepConvValue.getEditor().setOpaque(false);
        ((JSpinner.DefaultEditor)this.stepConvValue.getEditor()).getTextField().setOpaque(false);
        this.stepConvValue.setBorder(null);
        this.stepConvValue.setEnabled(false);
        this.add(this.stepConvValue);
        JLabel title1Label2 = new JLabel("Verticalit\u00e9 :");
        title1Label2.setFont(title1Label.getFont().deriveFont(16.0f));
        title1Label2.setBounds(this.hPos2 - 110, this.vPos2 - 4, 120, 28);
        this.add(title1Label2);
        this.vMinValue = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10.0, 0.25));
        this.vMinValue.setToolTipText("Hauteur gauche");
        this.vMinValue.setBounds(this.hPos2, this.vPos2, 50, 22);
        this.vMinValue.setFont(this.screenDistance.getFont().deriveFont(13.0f));
        this.vMinValue.setEnabled(false);
        this.add(this.vMinValue);
        this.vMaxValue = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10.0, 0.25));
        this.vMaxValue.setToolTipText("Hauteur droite");
        this.vMaxValue.setBounds(this.hPos2 + 130, this.vPos2, 50, 22);
        this.vMaxValue.setFont(this.screenDistance.getFont().deriveFont(13.0f));
        this.vMaxValue.setEnabled(false);
        this.add(this.vMaxValue);
        this.stepVertValue = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 10.0, 0.1));
        this.stepVertValue.setToolTipText("Step");
        this.stepVertValue.setBounds(this.hPos + 55, this.vPos2 + 15, 50, 20);
        this.stepVertValue.setFont(this.screenDistance.getFont().deriveFont(12.0f));
        ((JSpinner.DefaultEditor)this.stepVertValue.getEditor()).getTextField().setForeground(Color.GRAY);
        this.stepVertValue.setOpaque(false);
        this.stepVertValue.getEditor().setOpaque(false);
        ((JSpinner.DefaultEditor)this.stepVertValue.getEditor()).getTextField().setOpaque(false);
        this.stepVertValue.setBorder(null);
        this.stepVertValue.setEnabled(false);
        this.add(this.stepVertValue);
        JLabel jUnit2 = new JLabel("\u0394");
        jUnit2.setBounds(this.hPos + 190, this.vPos2, 30, 22);
        jUnit2.setFont(jUnit2.getFont().deriveFont(14.0f));
        this.add(jUnit2);
        JLabel title1Label3 = new JLabel("Disparit\u00e9 :");
        title1Label3.setFont(title1Label.getFont().deriveFont(16.0f));
        title1Label3.setBounds(this.hPos3 - 110, this.vPos3 - 4, 120, 28);
        this.add(title1Label3);
        this.dMinValue = new JSpinner(new SpinnerNumberModel(15, 5, 30, 1));
        this.dMinValue.setToolTipText("Disparit\u00e9 min");
        this.dMinValue.setBounds(this.hPos3, this.vPos3, 50, 22);
        this.dMinValue.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        this.dMinValue.setEnabled(false);
        this.add(this.dMinValue);
        this.dMaxValue = new JSpinner(new SpinnerNumberModel(20, 5, 50, 1));
        this.dMaxValue.setToolTipText("Disparit\u00e9 max");
        this.dMaxValue.setBounds(this.hPos3 + 130, this.vPos3, 50, 22);
        this.dMaxValue.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        this.dMaxValue.setEnabled(false);
        this.add(this.dMaxValue);
        this.dMaxValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int m;
                int M = (Integer)VergencePanel.this.dMaxValue.getValue();
                if (M < (m = ((Integer)VergencePanel.this.dMinValue.getValue()).intValue())) {
                    VergencePanel.this.dMaxValue.setValue(m);
                }
            }
        });
        this.dMinValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int M = (Integer)VergencePanel.this.dMaxValue.getValue();
                int m = (Integer)VergencePanel.this.dMinValue.getValue();
                if (m > M) {
                    VergencePanel.this.dMinValue.setValue(M);
                }
            }
        });
        this.stepDispValue = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
        this.stepDispValue.setToolTipText("Step");
        this.stepDispValue.setBounds(this.hPos3 + 55, this.vPos3 + 15, 50, 20);
        this.stepDispValue.setFont(this.screenDistance.getFont().deriveFont(12.0f));
        ((JSpinner.DefaultEditor)this.stepDispValue.getEditor()).getTextField().setForeground(Color.GRAY);
        this.stepDispValue.setOpaque(false);
        this.stepDispValue.getEditor().setOpaque(false);
        ((JSpinner.DefaultEditor)this.stepDispValue.getEditor()).getTextField().setOpaque(false);
        this.stepDispValue.setBorder(null);
        this.stepDispValue.setEnabled(false);
        this.add(this.stepDispValue);
        JLabel jUnit3 = new JLabel("pixels");
        jUnit3.setBounds(this.hPos + 190, this.vPos3, 50, 22);
        jUnit3.setFont(jUnit2.getFont().deriveFont(jUnit2.getFont().getStyle() | 2, 14.0f));
        this.add(jUnit3);
        JSeparator s = new JSeparator();
        s.setBounds(this.hPos3 - 110, this.vPos3 + 60, 440, 5);
        this.add(s);
        DefaultListModel<String> l1 = new DefaultListModel<String>();
        l1.addElement("Steps: conv <-> div");
        l1.addElement("Steps: convergence");
        l1.addElement("Steps: divergence");
        l1.addElement("Steps Altern\u00e9s : conv <-> div");
        l1.addElement("Jumps sur Max: conv <-> div");
        l1.addElement("Slider: conv <-> div");
        l1.addElement("Slider image: conv <-> div");
        final JList activityList = new JList(l1);
        activityList.setBounds(this.hPos3 - 108, this.vPos3 + 90, 230, 150);
        activityList.setToolTipText("Activit\u00e9");
        activityList.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        activityList.setBackground(new Color(51, 204, 255));
        activityList.setBorder(new LineBorder(Color.BLUE));
        this.add(activityList);
        String[] stimTitles = new String[]{"Un carr\u00e9", "Deux carr\u00e9s", "Quatre ronds"};
        final JComboBox<String> stimList = new JComboBox<String>(stimTitles);
        stimList.setBounds(this.hPos3 + 150, this.vPos3 + 90, 150, 25);
        stimList.setToolTipText("Stimulus");
        this.add(stimList);
        final JLabel toLabel = new JLabel("Time-out:");
        toLabel.setBounds(this.hPos3 + 150, this.vPos3 + 130, 60, 22);
        toLabel.setFont(toLabel.getFont().deriveFont(13.0f));
        this.add(toLabel);
        final JSpinner timeOutSpinner = new JSpinner(new SpinnerNumberModel(20, 10, 60, 2));
        timeOutSpinner.setToolTipText("Time-Out");
        timeOutSpinner.setFont(this.screenDistance.getFont().deriveFont(14.0f));
        timeOutSpinner.setBounds(this.hPos3 + 215, this.vPos3 + 130, 50, 22);
        this.add(timeOutSpinner);
        final JLabel toUnitLabel = new JLabel("sec.");
        toUnitLabel.setBounds(this.hPos3 + 275, this.vPos3 + 130, 60, 22);
        toUnitLabel.setFont(toUnitLabel.getFont().deriveFont(toUnitLabel.getFont().getStyle() | 2, 13.0f));
        this.add(toUnitLabel);
        final JLabel sliderSpeedLabel = new JLabel("Vitesse:");
        sliderSpeedLabel.setBounds(this.hPos3 + 150, this.vPos3 + 170, 60, 22);
        sliderSpeedLabel.setFont(sliderSpeedLabel.getFont().deriveFont(13.0f));
        this.add(sliderSpeedLabel);
        String[] speedTitles = new String[]{"Tr\u00e8s lent", "Lent", "Moyen", "Vite", "Tr\u00e8s vite"};
        final JComboBox<String> speedList = new JComboBox<String>(speedTitles);
        speedList.setBounds(this.hPos3 + 215, this.vPos3 + 170, 85, 25);
        speedList.setToolTipText("Vitesse (slider & images)");
        speedList.setSelectedIndex(2);
        this.add(speedList);
        String[] imagesTitles = new String[]{"Cubes x2", "Ruban M\u00f6bius", "Sph\u00e8re (polytope)", "Champignon", "Arcades", "Hypercube", "Pos\u00e9idon"};
        final JComboBox<String> imagesList = new JComboBox<String>(imagesTitles);
        imagesList.setBounds(this.hPos3 + 150, this.vPos3 + 215, 150, 25);
        imagesList.setToolTipText("Images");
        this.add(imagesList);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){
            final /* synthetic */ VergencePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int idx = activityList.getSelectedIndex();
                stimList.setEnabled(idx < 5);
                timeOutSpinner.setEnabled(idx < 5);
                toLabel.setEnabled(idx < 5);
                toUnitLabel.setEnabled(idx < 5);
                imagesList.setEnabled(idx == 6);
                sliderSpeedLabel.setEnabled(idx > 4);
                speedList.setEnabled(idx > 4);
                if (OrthoStereogram.userIsConnected) {
                    this.this$0.dMaxValue.setEnabled(idx > 4);
                    this.this$0.stepDispValue.setEnabled(idx < 5);
                    this.this$0.stepDivValue.setEnabled(idx < 5);
                    this.this$0.stepConvValue.setEnabled(idx < 5);
                }
            }
        };
        activityList.addListSelectionListener(listSelectionListener);
        activityList.setSelectedIndex(0);
        JButton startActivity = new JButton("D\u00e9marrer");
        startActivity.setBounds(this.hPos3 - 110, this.vPos3 + 260, 440, 50);
        startActivity.setForeground(new Color(0, 153, 0));
        startActivity.setFont(startActivity.getFont().deriveFont(20.0f));
        startActivity.setToolTipText("D\u00e9marrer l'activit\u00e9");
        this.add(startActivity);
        startActivity.addActionListener(new ActionListener(){
            final /* synthetic */ VergencePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                int idx = activityList.getSelectedIndex();
                if (idx < 5) {
                    boolean getOldTrophy = false;
                    if ((2 & evt.getModifiers()) != 0) {
                        getOldTrophy = true;
                    }
                    NewController cfr_ignored_0 = this.this$0.parent;
                    this.this$0.parent.doubleSt = new DoubleStereogram(NewController.imgSize, (Integer)this.this$0.screenDistance.getValue(), (Integer)this.this$0.initialValue.getValue(), (Double)this.this$0.vMinValue.getValue(), (Double)this.this$0.vMaxValue.getValue(), (Double)this.this$0.stepVertValue.getValue(), (Double)this.this$0.stepConvValue.getValue(), (Double)this.this$0.stepDivValue.getValue(), getOldTrophy);
                    this.this$0.parent.doubleSt.setAppearence(stimList.getSelectedIndex(), (Integer)this.this$0.maxConvValue.getValue(), (Integer)this.this$0.minConvValue.getValue(), (Integer)timeOutSpinner.getValue(), activityList.getSelectedIndex(), (Integer)this.this$0.dMinValue.getValue());
                    NewController cfr_ignored_1 = this.this$0.parent;
                    NewController.currentFrame = this.this$0.parent.doubleSt;
                } else if (idx == 5) {
                    if ((2 & evt.getModifiers()) == 0) {
                        this.this$0.parent.sliderV2 = new SliderStereogram_v2(speedList.getSelectedIndex(), (Integer)this.this$0.minConvValue.getValue(), (Integer)this.this$0.maxConvValue.getValue(), (Integer)this.this$0.screenDistance.getValue(), (Integer)this.this$0.initialValue.getValue(), (Double)this.this$0.vMinValue.getValue(), (Double)this.this$0.vMaxValue.getValue(), (Integer)this.this$0.dMinValue.getValue(), (Integer)this.this$0.dMaxValue.getValue());
                        NewController cfr_ignored_2 = this.this$0.parent;
                        NewController.currentFrame = this.this$0.parent.sliderV2;
                        this.this$0.parent.sliderV2.setExtendedState(6);
                        this.this$0.parent.sliderV2.initSliderStereogram_v2();
                    } else {
                        this.this$0.parent.slide = new SlideStereogramView(speedList.getSelectedIndex(), (Integer)this.this$0.minConvValue.getValue(), (Integer)this.this$0.maxConvValue.getValue(), (Integer)this.this$0.screenDistance.getValue(), (Integer)this.this$0.initialValue.getValue(), (Double)this.this$0.vMinValue.getValue(), (Double)this.this$0.vMaxValue.getValue(), (Integer)this.this$0.dMinValue.getValue(), (Integer)this.this$0.dMaxValue.getValue(), (Integer)this.this$0.stepDispValue.getValue());
                        this.this$0.parent.slide.setAppearence(false);
                        NewController cfr_ignored_3 = this.this$0.parent;
                        NewController.currentFrame = this.this$0.parent.slide;
                        this.this$0.parent.slide.setExtendedState(6);
                    }
                } else {
                    int imgIdx = imagesList.getSelectedIndex();
                    String file = null;
                    switch (imgIdx) {
                        case 0: {
                            file = "3d-practise.png";
                            break;
                        }
                        case 1: {
                            file = "3dring.png";
                            break;
                        }
                        case 2: {
                            file = "polytope.png";
                            break;
                        }
                        case 3: {
                            file = "3D_champignon.png";
                            break;
                        }
                        case 4: {
                            file = "3D_arcades.png";
                            break;
                        }
                        case 5: {
                            file = "teseract.png";
                            break;
                        }
                        case 6: {
                            file = "poseidon.png";
                            break;
                        }
                        default: {
                            file = "3d-practise.png";
                        }
                    }
                    this.this$0.parent.imageFrame = new ImageStereogramView(file, speedList.getSelectedIndex(), (Integer)this.this$0.minConvValue.getValue(), (Integer)this.this$0.maxConvValue.getValue(), (Integer)this.this$0.screenDistance.getValue(), (Double)this.this$0.vMinValue.getValue());
                    this.this$0.parent.imageFrame.setAppearence();
                    NewController cfr_ignored_4 = this.this$0.parent;
                    NewController.currentFrame = this.this$0.parent.imageFrame;
                    this.this$0.parent.imageFrame.setExtendedState(6);
                }
            }
        });
        JSeparator v = new JSeparator();
        v.setOrientation(1);
        v.setBounds(470, 10, 15, 585);
        this.add(v);
        this.repaint();
    }

    public void updateAnaglyph() {
        if (OrthoStereogram.BR_glasses) {
            this.parent.imgLunettes.setIcon(new ImageIcon(this.parent.imgBR));
            this.parent.imgLunettes.setToolTipText("Bleu sur l'oeil gauche");
        } else {
            this.parent.imgLunettes.setIcon(new ImageIcon(this.parent.imgRB));
            this.parent.imgLunettes.setToolTipText("Bleu sur l'oeil droit");
        }
    }

    public void updateScreenDistance(int d) {
        this.distLabel.setText("Ecran :");
        this.screenDistance.setValue(d);
    }

    public void addGraphiques() {
        XYSeriesCollection xySeriesCollection1 = new XYSeriesCollection();
        this.xySerieMax = new XYSeries((Comparable)((Object)"Vergence (\u0394)"));
        xySeriesCollection1.addSeries(this.xySerieMax);
        this.chart1 = ChartFactory.createXYLineChart("", "", "", xySeriesCollection1, PlotOrientation.VERTICAL, true, false, false);
        this.chartPanel1 = new ChartPanel(this.chart1);
        this.chartPanel1.setBounds(500, 10, 450, 290);
        this.add(this.chartPanel1);
        this.chartPanel1.setVisible(true);
        JMenuItem mnuSaveCSV = new JMenuItem("Save CSV");
        this.chartPanel1.getPopupMenu().remove(0);
        this.chartPanel1.getPopupMenu().remove(0);
        this.chartPanel1.getPopupMenu().remove(0);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().remove(1);
        this.chartPanel1.getPopupMenu().addSeparator();
        this.chartPanel1.getPopupMenu().add(mnuSaveCSV);
        mnuSaveCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VergencePanel.this.saveCSVDatas_toFile();
            }
        });
        XYSeriesCollection xySeriesCollection2 = new XYSeriesCollection();
        this.xySerieTime = new XYSeries((Comparable)((Object)"Tps de r\u00e9ponse (dixi\u00e8mes de sec)"));
        xySeriesCollection2.addSeries(this.xySerieTime);
        this.chart2 = ChartFactory.createXYLineChart("", "", "", xySeriesCollection2, PlotOrientation.VERTICAL, true, false, false);
        this.chartPanel2 = new ChartPanel(this.chart2);
        this.chartPanel2.setBounds(500, 310, 450, 290);
        this.add(this.chartPanel2);
        this.chartPanel2.setVisible(true);
        this.chartPanel2.setPopupMenu(null);
        this.chart1.setBackgroundPaint(Color.CYAN);
        XYPlot plot1 = this.chart1.getXYPlot();
        plot1.setBackgroundPaint(Color.lightGray);
        this.chart2.setBackgroundPaint(Color.CYAN);
        XYPlot plot2 = this.chart2.getXYPlot();
        plot2.setBackgroundPaint(Color.lightGray);
        ValueMarker rangeMarker = new ValueMarker(0.0);
        rangeMarker.setPaint(Color.RED);
        rangeMarker.setStroke(new BasicStroke(2.0f));
        plot1.addRangeMarker(rangeMarker);
        plot2.addRangeMarker(rangeMarker);
        plot1.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot2.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot1.getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot2.getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer();
        renderer1.setSeriesPaint(0, Color.BLUE);
        renderer1.setSeriesShapesVisible(1, true);
        Ellipse2D.Double circle = new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
        renderer1.setSeriesShape(0, circle);
        plot1.setRenderer(renderer1);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        renderer2.setSeriesPaint(0, Color.RED);
        renderer2.setSeriesShapesVisible(1, true);
        Rectangle rect = new Rectangle(2, 2);
        renderer2.setSeriesShape(0, rect);
        plot2.setRenderer(renderer2);
        this.chartPanel1.addChartMouseListener(new ChartMouseListener(){

            @Override
            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getTrigger().getClickCount() == 2) {
                    VergencePanel.this.xySerieMax.clear();
                    VergencePanel.this.xySerieTime.clear();
                    NewController.csvDatasList.clear();
                }
            }

            @Override
            public void chartMouseMoved(ChartMouseEvent cme) {
            }
        });
        this.chartPanel2.addChartMouseListener(new ChartMouseListener(){

            @Override
            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getTrigger().getClickCount() == 2) {
                    VergencePanel.this.xySerieMax.clear();
                    VergencePanel.this.xySerieTime.clear();
                    NewController.csvDatasList.clear();
                }
            }

            @Override
            public void chartMouseMoved(ChartMouseEvent cme) {
            }
        });
    }

    private void saveCSVDatas_toFile() {
        if (NewController.csvDatasList.size() == 0) {
            return;
        }
        FileDialog dialog = new FileDialog((Frame)null, "Select File to Open");
        dialog.setFile("*.csv");
        dialog.setDirectory(FileSystemView.getFileSystemView().getDefaultDirectory().getPath());
        dialog.setMode(0);
        dialog.setVisible(true);
        if (dialog.getFile() == null || dialog.getDirectory() == null) {
            return;
        }
        String file = dialog.getDirectory() + dialog.getFile();
        System.out.println(file + " chosen.");
        if (file == null) {
            return;
        }
        try {
            FileWriter myWriter = new FileWriter(file);
            myWriter.write("idx;work;vergence;verticality;suceed;delay\n");
            for (CSVDatas csvData : NewController.csvDatasList) {
                myWriter.write(csvData.idx + ";");
                switch (csvData.work) {
                    case 2: {
                        myWriter.write("C_UP");
                        break;
                    }
                    case 1: {
                        myWriter.write("C_DN");
                        break;
                    }
                    case -1: {
                        myWriter.write("D_UP");
                        break;
                    }
                    case -2: {
                        myWriter.write("D_DN");
                        break;
                    }
                    default: {
                        myWriter.write("ERR");
                    }
                }
                myWriter.write(";" + csvData.vergence + ";" + csvData.verticality + ";" + csvData.succeed + ";" + csvData.delay + "\n");
            }
            myWriter.close();
            System.out.println("Successfully wrote to the file.");
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    public void resetLimites() {
        this.screenDistance.setEnabled(true);
        this.initialValue.setEnabled(true);
        this.stepDivValue.setEnabled(true);
        this.stepConvValue.setEnabled(true);
        this.vMinValue.setEnabled(true);
        this.vMaxValue.setEnabled(true);
        this.stepVertValue.setEnabled(true);
        this.dMinValue.setEnabled(true);
        this.dMaxValue.setEnabled(true);
        this.minConvValue.setModel(new SpinnerNumberModel(-4, -30, 50, 1));
        this.maxConvValue.setModel(new SpinnerNumberModel(20, -30, 50, 1));
        this.updateAnaglyph();
    }

    public void updateCalibrationStatus() {
        if (OrthoStereogram.isCalibrated) {
            this.parent.calibLabel.setText("Calibration : ok");
            this.parent.calibLabel.setBackground(Color.GREEN);
        } else {
            this.parent.calibLabel.setText("Calibration : nok => estim\u00e9e");
            this.parent.calibLabel.setBackground(Color.RED);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(Color.BLUE);
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(this.hPos + 50, this.vPos + 10, this.hPos + 260, this.vPos + 10);
        g2.drawLine(this.hPos + 50, this.vPos + 10, this.hPos + 61, this.vPos + 7);
        g2.drawLine(this.hPos + 50, this.vPos + 10, this.hPos + 61, this.vPos + 13);
        g2.drawLine(this.hPos + 260 - 11, this.vPos + 7, this.hPos + 260, this.vPos + 10);
        g2.drawLine(this.hPos + 260 - 11, this.vPos + 13, this.hPos + 260, this.vPos + 10);
        g2.drawLine(this.hPos2 + 50, this.vPos2 + 10, this.hPos2 + 130, this.vPos2 + 10);
        g2.drawLine(this.hPos + 50, this.vPos2 + 10, this.hPos + 61, this.vPos2 + 7);
        g2.drawLine(this.hPos + 50, this.vPos2 + 10, this.hPos + 61, this.vPos2 + 13);
        g2.drawLine(this.hPos + 130 - 11, this.vPos2 + 7, this.hPos + 130, this.vPos2 + 10);
        g2.drawLine(this.hPos + 130 - 11, this.vPos2 + 13, this.hPos + 130, this.vPos2 + 10);
        g2.drawLine(this.hPos3 + 50, this.vPos3 + 10, this.hPos3 + 130, this.vPos3 + 10);
        g2.drawLine(this.hPos3 + 50, this.vPos3 + 10, this.hPos3 + 61, this.vPos3 + 7);
        g2.drawLine(this.hPos3 + 50, this.vPos3 + 10, this.hPos3 + 61, this.vPos3 + 13);
        g2.drawLine(this.hPos3 + 130 - 11, this.vPos3 + 7, this.hPos3 + 130, this.vPos3 + 10);
        g2.drawLine(this.hPos3 + 130 - 11, this.vPos3 + 13, this.hPos3 + 130, this.vPos3 + 10);
    }
}

