/*
 * Decompiled with CFR 0.152.
 */
package orthostereogram;

import java.io.BufferedInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WavSoundThread
extends Thread {
    int son;
    String fichier;
    Clip clip;

    public WavSoundThread(int t) {
        this.son = t;
    }

    @Override
    public void run() {
        switch (this.son) {
            case 0: {
                this.fichier = "/Ressources/incorrect.wav";
                break;
            }
            case 1: {
                this.fichier = "/Ressources/correct.wav";
            }
        }
        try {
            this.clip = AudioSystem.getClip();
            if (this.clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                double gain = 0.25;
                float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
                gainControl.setValue(dB);
            }
            this.clip.open(AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(this.fichier))));
            this.clip.start();
            this.clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent evt) {
                    if (evt.getType() == LineEvent.Type.STOP) {
                        evt.getLine().close();
                    }
                }
            });
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace(System.out);
        }
    }
}

