/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ListIterator;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;

public class FichesPatientsDialog
extends Dialog {
    DefaultTableModel dm;
    UtilDateModel model;
    private int selectedID = 0;
    private JDatePickerImpl datePicker;
    private JRadioButton jActif;
    private JLabel jAge;
    private JCheckBox jCheckBox1;
    private JButton jCreate;
    private JLabel jDN;
    private JButton jDelete;
    private JButton jFermer;
    private JTextField jFirstName;
    private JRadioButton jInactifs;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jLastName;
    private JLabel jPatientName;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox<String> jSex;
    public static JTable jTable;

    public FichesPatientsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        jTable.getColumnModel().getColumn(2).setPreferredWidth(20);
        jTable.setSelectionMode(0);
        jTable.getTableHeader().setFont(new Font("SansSerif", 1, 13));
        jTable.setRowSelectionAllowed(true);
        TableColumnModel tcm = jTable.getColumnModel();
        tcm.removeColumn(tcm.getColumn(3));
        this.model = new UtilDateModel();
        Properties p = new Properties();
        p.put("text.today", "Aujourd'hui");
        p.put("text.month", "Mois");
        p.put("text.year", "Ann\u00e9e");
        JDatePanelImpl datePanel = new JDatePanelImpl(this.model, p);
        this.datePicker = new JDatePickerImpl(datePanel, new DateLabelFormatter());
        this.datePicker.setBounds(this.jLastName.getLocation().x, this.jDN.getLocation().y - 5, this.jLastName.getSize().width, this.jDN.getSize().height + 10);
        this.datePicker.setVisible(true);
        this.datePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Calendar tdCal = Calendar.getInstance();
                Date dn = (Date)FichesPatientsDialog.this.model.getValue();
                if (dn != null) {
                    Calendar dnCal = Calendar.getInstance();
                    dnCal.setTime(dn);
                    int age = tdCal.get(1) - dnCal.get(1);
                    if (tdCal.get(2) < dnCal.get(2)) {
                        --age;
                    }
                    FichesPatientsDialog.this.jAge.setText("(" + String.valueOf(age) + " ans)");
                } else {
                    FichesPatientsDialog.this.jAge.setText("");
                }
            }
        });
        this.add(this.datePicker);
        this.majTableau(0);
        this.sort();
    }

    private void majTableau(int idSelected) {
        this.dm = (DefaultTableModel)jTable.getModel();
        this.dm.setRowCount(0);
        ListIterator lit = UserInfo.listePatients.listIterator();
        while (lit.hasNext()) {
            Patient pP = (Patient)lit.next();
            this.dm.addRow(new Object[]{pP.nom, pP.prenom, pP.getAge(), pP.id});
        }
        if (idSelected != 0) {
            int i = 0;
            while ((Integer)this.dm.getValueAt(i, 3) != idSelected) {
                ++i;
            }
            int r = jTable.getRowSorter().convertRowIndexToView(i);
            jTable.setRowSelectionInterval(r, r);
            this.jTableMouseReleased(null);
        } else {
            this.jLastName.setText("");
            this.jFirstName.setText("");
            this.model.setValue(null);
            this.jAge.setText("(\u00e2ge)");
            this.jPatientName.setText("(aucun)");
            this.selectedID = 0;
        }
    }

    private void sort() {
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.dm);
        jTable.setRowSorter(sorter);
        sorter.toggleSortOrder(0);
    }

    private void initComponents() {
        this.jFermer = new JButton();
        this.jLabel1 = new JLabel();
        this.jPatientName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        jTable = new JTable();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jDN = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLastName = new JTextField();
        this.jFirstName = new JTextField();
        this.jActif = new JRadioButton();
        this.jInactifs = new JRadioButton();
        this.jSeparator2 = new JSeparator();
        this.jAge = new JLabel();
        this.jCreate = new JButton();
        this.jDelete = new JButton();
        this.jSex = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.setBackground(Color.cyan);
        this.setMinimumSize(new Dimension(654, 563));
        this.setResizable(false);
        this.setSize(new Dimension(654, 563));
        this.setTitle("orthoEVA : fiches patients...");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FichesPatientsDialog.this.closeDialog(evt);
            }
        });
        this.jFermer.setFont(new Font("Tahoma", 1, 12));
        this.jFermer.setText("Fermer");
        this.jFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FichesPatientsDialog.this.jFermerActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 18));
        this.jLabel1.setText("S\u00e9lection patient :");
        this.jPatientName.setFont(new Font("Tahoma", 1, 24));
        this.jPatientName.setForeground(new Color(102, 102, 102));
        this.jPatientName.setHorizontalAlignment(2);
        this.jPatientName.setText("(aucun)");
        this.jPatientName.setDoubleBuffered(true);
        this.jPatientName.setFocusable(false);
        this.jPatientName.setHorizontalTextPosition(2);
        this.jPatientName.setMaximumSize(new Dimension(411, 40));
        this.jPatientName.setMinimumSize(new Dimension(411, 40));
        this.jPatientName.setPreferredSize(new Dimension(411, 40));
        this.jPatientName.setRequestFocusEnabled(false);
        this.jPatientName.setVerifyInputWhenFocusTarget(false);
        jTable.setBackground(new Color(204, 255, 255));
        jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Nom", "Pr\u00e9nom", "Age", "id"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        jTable.setFocusTraversalPolicyProvider(true);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FichesPatientsDialog.this.jTableMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FichesPatientsDialog.this.jTableMouseReleased(evt);
            }
        });
        jTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FichesPatientsDialog.this.jTablePropertyChange(evt);
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FichesPatientsDialog.this.jTableKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                FichesPatientsDialog.this.jTableKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(jTable);
        this.jLabel2.setText("Nom :");
        this.jLabel3.setText("Pr\u00e9nom :");
        this.jDN.setText("N\u00e9(e) le :");
        this.jLastName.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FichesPatientsDialog.this.jLastNamePropertyChange(evt);
            }
        });
        this.jActif.setBackground(Color.cyan);
        this.jActif.setSelected(true);
        this.jActif.setText("Patients actifs");
        this.jActif.setActionCommand("");
        this.jActif.setFocusPainted(false);
        this.jActif.setFocusable(false);
        this.jActif.setRolloverEnabled(false);
        this.jActif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FichesPatientsDialog.this.jActifActionPerformed(evt);
            }
        });
        this.jInactifs.setBackground(Color.cyan);
        this.jInactifs.setText("Patients inactifs");
        this.jInactifs.setActionCommand("");
        this.jInactifs.setEnabled(false);
        this.jInactifs.setFocusPainted(false);
        this.jInactifs.setFocusable(false);
        this.jInactifs.setRolloverEnabled(false);
        this.jInactifs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FichesPatientsDialog.this.jInactifsActionPerformed(evt);
            }
        });
        this.jAge.setText("(\u00e2ge)");
        this.jCreate.setFont(new Font("Tahoma", 1, 12));
        this.jCreate.setText("Nouveau");
        this.jCreate.setToolTipText("Cr\u00e9er un nouveau patient");
        this.jCreate.setMaximumSize(new Dimension(73, 23));
        this.jCreate.setMinimumSize(new Dimension(73, 23));
        this.jCreate.setPreferredSize(new Dimension(73, 23));
        this.jCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FichesPatientsDialog.this.jCreateActionPerformed(evt);
            }
        });
        this.jDelete.setFont(new Font("Tahoma", 1, 12));
        this.jDelete.setText("Supprimer");
        this.jDelete.setToolTipText("Supprimer cette fiche");
        this.jDelete.setEnabled(false);
        this.jDelete.setMaximumSize(new Dimension(73, 23));
        this.jDelete.setMinimumSize(new Dimension(73, 23));
        this.jDelete.setPreferredSize(new Dimension(73, 23));
        this.jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FichesPatientsDialog.this.jDeleteActionPerformed(evt);
            }
        });
        this.jSex.setModel(new DefaultComboBoxModel<String>(new String[]{"Genre ?", "Gar\u00e7on", "Fille"}));
        this.jCheckBox1.setText("Accord explicite d'utilisation statistique");
        this.jCheckBox1.setToolTipText("Autorise l'introduction des r\u00e9sultats dans les calculs statistiques du programme en vue d'am\u00e9liorer les performances");
        this.jCheckBox1.setEnabled(false);
        this.jCheckBox1.setOpaque(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FichesPatientsDialog.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 174, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPatientName, -2, 411, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 300, -2).addGroup(layout.createSequentialGroup().addComponent(this.jActif).addGap(37, 37, 37).addComponent(this.jInactifs))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, 265, -2).addComponent(this.jDelete, GroupLayout.Alignment.TRAILING, -2, 110, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jFermer, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCreate, -2, 110, -2)).addComponent(this.jSeparator2, -2, 271, -2)).addComponent(this.jDN).addComponent(this.jLabel3).addComponent(this.jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCheckBox1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(65, 65, 65).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jAge, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSex, -2, 105, -2)).addComponent(this.jFirstName, -2, 200, -2).addComponent(this.jLastName, -2, 200, -2))))))).addContainerGap(43, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jPatientName, -2, 40, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1, -2, 10, -2).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLastName, -2, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jFirstName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jDN).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAge, -2, 19, -2).addComponent(this.jSex, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCreate, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jFermer, GroupLayout.Alignment.TRAILING))).addComponent(this.jScrollPane1, -2, 438, -2)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jActif).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jInactifs).addComponent(this.jDelete, -2, -1, -2))).addContainerGap(22, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jFermerActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.selectedID != 0) {
            Patient pP = (Patient)UserInfo.listePatients.get(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()));
            Date newDate = (Date)this.model.getValue();
            Calendar dnCal = Calendar.getInstance();
            dnCal.setTime(newDate);
            dnCal.set(10, 0);
            dnCal.set(11, 0);
            dnCal.set(12, 0);
            dnCal.set(13, 0);
            dnCal.set(14, 0);
            if (!(pP.nom.equals(this.jLastName.getText()) && pP.prenom.equals(this.jFirstName.getText()) && pP.dn.equals(dnCal.getTime()) && pP.sex == this.jSex.getSelectedIndex())) {
                this.majTableau(this.selectedID);
            }
        }
        if (!this.jFermer.getText().equalsIgnoreCase("Fermer")) {
            if (UserInfo.currentPatient != 0) {
                while (UserInfo.areThereModifiedResults()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
            }
            OrthoEVA.user.activatePatient(this.selectedID);
        } else {
            UserInfo.currentPatient = 0;
        }
        this.setVisible(false);
        this.dispose();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.jFermerActionPerformed(null);
        }
    }

    private void jTableMouseReleased(MouseEvent evt) {
        Patient pP = (Patient)UserInfo.listePatients.get(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()));
        Calendar cal = Calendar.getInstance();
        cal.setTime(pP.dn);
        String lName = (String)jTable.getModel().getValueAt(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()), 0) + " " + jTable.getModel().getValueAt(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()), 1);
        this.jPatientName.setText(lName);
        this.jLastName.setText((String)jTable.getModel().getValueAt(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()), 0));
        this.jFirstName.setText((String)jTable.getModel().getValueAt(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()), 1));
        this.model.setDate(cal.get(1), cal.get(2), cal.get(5));
        this.model.setSelected(true);
        this.jAge.setText("(" + String.valueOf(pP.getAge()) + " ans)");
        this.jSex.setSelectedIndex(pP.sex);
        this.jCreate.setEnabled(false);
        this.jDelete.setEnabled(true);
        this.jFermer.setText("S\u00e9lectionner");
        this.selectedID = (Integer)jTable.getModel().getValueAt(jTable.getRowSorter().convertRowIndexToModel(jTable.getSelectedRow()), 3);
    }

    private void jTablePropertyChange(PropertyChangeEvent evt) {
    }

    private void jTableKeyPressed(KeyEvent evt) {
    }

    private void jTableKeyReleased(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 38 | code == 40) {
            this.jTableMouseClicked(null);
        }
    }

    private void jActifActionPerformed(ActionEvent evt) {
        this.jActif.setSelected(true);
        this.jInactifs.setSelected(false);
    }

    private void jInactifsActionPerformed(ActionEvent evt) {
        this.jActif.setSelected(false);
        this.jInactifs.setSelected(true);
    }

    private void jCreateActionPerformed(ActionEvent evt) {
    }

    private void jLastNamePropertyChange(PropertyChangeEvent evt) {
    }

    private void jDeleteActionPerformed(ActionEvent evt) {
        String n = this.jLastName.getText() + " " + this.jLastName.getText();
        int r = JOptionPane.showConfirmDialog(this, "Voulez-vous supprimer cette fiche d\u00e9finitivement ?\n(" + n + ")\n ", "Fiches patients :", 2);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
    }

    class DateLabelFormatter
    extends JFormattedTextField.AbstractFormatter {
        private String datePattern = "dd-MMM-yyyy";
        private SimpleDateFormat dateFormatter = new SimpleDateFormat(this.datePattern);

        DateLabelFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return this.dateFormatter.parseObject(text);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                Calendar cal = (Calendar)value;
                return this.dateFormatter.format(cal.getTime());
            }
            return "";
        }
    }
}

