/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.printing.PDFPageable;

public class GeneratePDF
extends Thread {
    public GeneratePDF() {
        this.setName("GeneratePDF");
    }

    @Override
    public void run() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy");
            Date today = new Date();
            String fileName = "Rapport orthoEVA " + OrthoEVA.fen.jPatient.getText() + ".pdf";
            PDDocument doc = new PDDocument();
            PDPage page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            PDPageContentStream content = new PDPageContentStream(doc, page);
            content.beginText();
            float fontSize = 14.0f;
            float leading = 1.5f * fontSize;
            content.setFont(PDType1Font.HELVETICA_BOLD, fontSize);
            content.setLeading(leading);
            content.newLineAtOffset(50.0f, 777.0f);
            content.showText(OrthoEVA.user.titre + " " + OrthoEVA.user.nom + " " + OrthoEVA.user.prenom + ", " + OrthoEVA.user.activite);
            content.newLine();
            fontSize = 11.0f;
            leading = 1.5f * fontSize;
            content.setLeading(leading);
            content.setFont(PDType1Font.HELVETICA, fontSize);
            content.showText(OrthoEVA.user.adr1 + " - " + OrthoEVA.user.adr2 + "  " + OrthoEVA.user.cp + "  " + OrthoEVA.user.ville);
            content.newLine();
            content.showText("Tel: " + OrthoEVA.user.tel1);
            content.endText();
            content.moveTo(35.0f, 727.0f);
            content.lineTo(page.getMediaBox().getWidth() - 50.0f, 727.0f);
            content.moveTo(45.0f, 805.0f);
            content.lineTo(45.0f, 680.0f);
            content.moveTo(35.0f, 795.0f);
            content.lineTo(150.0f, 795.0f);
            content.stroke();
            content.beginText();
            fontSize = 16.0f;
            leading = 1.5f * fontSize;
            content.setLeading(leading);
            content.setFont(PDType1Font.HELVETICA_BOLD, fontSize);
            content.setNonStrokingColor(Color.DARK_GRAY);
            content.newLineAtOffset(50.0f, 705.0f);
            content.showText("Synth\u00e8se OrthoEVA : " + OrthoEVA.fen.jPatient.getText());
            fontSize = 10.0f;
            leading = 1.5f * fontSize;
            content.setLeading(leading);
            content.newLine();
            content.setFont(PDType1Font.HELVETICA_OBLIQUE, fontSize);
            content.showText(df.format(today));
            content.endText();
            content.beginText();
            content.setFont(PDType1Font.HELVETICA_BOLD, 12.0f);
            content.setNonStrokingColor(Color.BLACK);
            content.newLineAtOffset(50.0f, 640.0f);
            content.showText("Synth\u00e8se Report Global de lettres :");
            content.endText();
            BufferedImage bufferedImage = OrthoEVA.fen.chartPanelBAD.getChart().createBufferedImage(OrthoEVA.fen.chartPanelBAD.getWidth(), OrthoEVA.fen.chartPanelBAD.getHeight(), 1, null);
            PDImageXObject ximage = LosslessFactory.createFromImage(doc, bufferedImage);
            content.drawImage(ximage, 375.0f, 540.0f, 175.0f, 146.0f);
            String analyse = PanelSynthese.jTextRG.getDocument().getText(0, PanelSynthese.jTextRG.getDocument().getLength());
            analyse = analyse.replace("\n", "").replace("\r", "");
            PDType1Font pdfFont = PDType1Font.HELVETICA;
            float width = 310.0f;
            ArrayList<String> lines = new ArrayList<String>();
            int lastSpace = -1;
            while (analyse.length() > 0) {
                String subString;
                float size;
                int spaceIndex = analyse.indexOf(32, lastSpace + 1);
                if (spaceIndex < 0) {
                    spaceIndex = analyse.length();
                }
                if ((size = fontSize * pdfFont.getStringWidth(subString = analyse.substring(0, spaceIndex)) / 1000.0f) > width) {
                    if (lastSpace < 0) {
                        lastSpace = spaceIndex;
                    }
                    subString = analyse.substring(0, lastSpace);
                    lines.add(subString);
                    analyse = analyse.substring(lastSpace).trim();
                    lastSpace = -1;
                    continue;
                }
                if (spaceIndex == analyse.length()) {
                    lines.add(analyse);
                    analyse = "";
                    continue;
                }
                lastSpace = spaceIndex;
            }
            fontSize = 10.0f;
            leading = 1.5f * fontSize;
            content.beginText();
            content.setFont(PDType1Font.HELVETICA, fontSize);
            content.setLeading(leading);
            content.newLineAtOffset(50.0f, 620.0f);
            for (String line : lines) {
                content.showText(line);
                content.newLine();
            }
            content.newLine();
            content.setFont(PDType1Font.HELVETICA_OBLIQUE, 8.0f);
            content.setNonStrokingColor(Color.RED);
            content.showText("(Synth\u00e8se incompl\u00e8te en l'\u00e9tat actuel du programme : " + OrthoEVA.user.getSoftVersion() + ")");
            content.endText();
            content.close();
            if (!OrthoEVA.onLine) {
                doc.save(fileName);
                File myFile = new File(fileName);
                Desktop.getDesktop().open(myFile);
            } else {
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPageable(new PDFPageable(doc));
                job.print();
            }
            doc.close();
        }
        catch (Exception e) {
            UserInfo.journal.addJournal(e.toString());
        }
    }
}

