/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jfree.data.xy.XYSeries;

public class LaunchRG
extends Thread {
    int nbCycles;
    int speed;
    int i;
    public static int n_minL;
    public static int n_maxL;
    static SoundClips snd;
    boolean isQLearningOn;
    QLearning qLearning;
    PanelInputChars panCheck;

    public LaunchRG(int nb, int minL, int maxL, int sp, int minC, int maxC, boolean ql) {
        this.isQLearningOn = ql;
        if (this.isQLearningOn) {
            this.qLearning = new QLearning();
        }
        this.nbCycles = nb;
        n_minL = minL;
        n_maxL = maxL;
        this.speed = sp;
        this.setName("LaunchRG");
    }

    @Override
    public void run() {
        LinkedList<Score> results = new LinkedList<Score>();
        OrthoEVA.fen.chartPanelOK.setVisible(false);
        OrthoEVA.fen.chartPanelBAD.setVisible(false);
        OrthoEVA.fen.panelParametresRG.setVisible(false);
        OrthoEVA.fen.enableMenuBar(false);
        OrthoEVA.fen.jPatient.setVisible(false);
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        boolean notFin = true;
        this.i = 0;
        long tempsDebut = System.currentTimeMillis();
        float delay = (Integer)ParamsRG.jDelay.getValue() * 60;
        do {
            OrthoEVA.fen.panelPressSB.setVisible(true);
            OrthoEVA.fen.setCursor(transparentCursor);
            OrthoEVA.fen.panelPressSB.repaint();
            OrthoEVA.fen.panelPressSB.requestFocus();
            while (!OrthoEVA.fen.panelPressSB.flag) {
                try {
                    LaunchRG.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            OrthoEVA.fen.panelPressSB.setVisible(false);
            OrthoEVA.fen.panelPressSB.flag = false;
            snd = new SoundClips(1);
            snd.start();
            MainFenetre.panelFP.setVisible(true);
            MainFenetre.panelFP.requestFocus();
            try {
                LaunchRG.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MainFenetre.panelFP.setVisible(false);
            try {
                LaunchRG.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Score score = new Score();
            score.n = EVAFlash.EVAGenerate(n_minL, n_maxL);
            OrthoEVA.fen.panelFlash.repaint();
            OrthoEVA.fen.panelFlash.setVisible(true);
            try {
                LaunchRG.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OrthoEVA.fen.panelFlash.setVisible(false);
            try {
                LaunchRG.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.panCheck = new PanelInputChars(OrthoEVA.fen.getContentPane().getWidth(), OrthoEVA.fen.getContentPane().getHeight(), score.n, score);
            OrthoEVA.fen.getContentPane().add(this.panCheck);
            this.panCheck.setVisible(false);
            this.panCheck.setFocusable(true);
            this.panCheck.input.setText("");
            this.panCheck.setVisible(true);
            this.panCheck.input.requestFocus();
            while (true) {
                if (PanelInputChars.flag || this.panCheck.out) break;
                try {
                    LaunchRG.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.panCheck.setVisible(false);
            MainFenetre.panelFP.flag = false;
            PanelInputChars.flag = false;
            OrthoEVA.fen.panelPressSB.setVisible(true);
            if (this.panCheck.out) break;
            score.speed = this.speed;
            results.add(score);
            if (ParamsRG.jSelectCycles.isSelected()) {
                ++this.i;
                if (this.i == this.nbCycles) {
                    notFin = false;
                }
            } else {
                float seconds = (float)(System.currentTimeMillis() - tempsDebut) / 1000.0f;
                if (seconds > delay) {
                    notFin = false;
                }
                ++this.i;
            }
            if (!notFin || !this.isQLearningOn || this.i <= 3) continue;
            int s = this.qLearning.calcState(results);
            System.out.println("Current state=" + s + " reward= " + this.qLearning.calcReward(results));
            this.qLearning.updateQMatrice();
            int a = this.qLearning.selectAction();
            System.out.print("Action : " + a);
            if (a == 1) {
                this.speed -= 5;
            }
            if (a == 2) {
                this.speed += 5;
            }
            System.out.println(" (new speed =" + this.speed + ")");
        } while (notFin);
        if (results.size() > 0) {
            Session session = new Session();
            session.date = new Date();
            session.results = results;
            UserInfo.resultatsRG.add(session);
            UserInfo.modifiedResultatsRG = true;
        }
        this.panCheck.out = false;
        OrthoEVA.fen.panelPressSB.setVisible(false);
        OrthoEVA.fen.panelParametresRG.setVisible(true);
        OrthoEVA.fen.chartPanelOK.setVisible(true);
        OrthoEVA.fen.chartPanelBAD.setVisible(true);
        OrthoEVA.fen.enableMenuBar(true);
        OrthoEVA.fen.jPatient.setVisible(true);
        LaunchRG.computeChartsRG(true);
    }

    public static void computeChartsRG(boolean on) {
        OrthoEVA.fen.serieOK = new XYSeries((Comparable)((Object)"% corrects"));
        OrthoEVA.fen.serieBAD = new XYSeries((Comparable)((Object)"% inversions"));
        OrthoEVA.fen.serie2 = new XYSeries((Comparable)((Object)"2 lettres"));
        OrthoEVA.fen.serie3 = new XYSeries((Comparable)((Object)"3 lettres"));
        OrthoEVA.fen.serie4 = new XYSeries((Comparable)((Object)"4 lettres"));
        OrthoEVA.fen.serie5 = new XYSeries((Comparable)((Object)"5 lettres"));
        OrthoEVA.fen.serie6 = new XYSeries((Comparable)((Object)"6 lettres"));
        OrthoEVA.fen.xySeriesCollectionOK.removeAllSeries();
        OrthoEVA.fen.xySeriesCollectionBAD.removeAllSeries();
        double[] lettres = new double[7];
        boolean[] lettre = new boolean[7];
        Score score = new Score();
        double mean_bon = 0.0;
        ListIterator it = UserInfo.resultatsRG.listIterator();
        int i = 0;
        while (it.hasNext()) {
            mean_bon = 0.0;
            double mean_bad = 0.0;
            int nbPaires = 0;
            for (int ll = 2; ll < 7; ++ll) {
                lettres[ll] = 0.0;
                lettre[ll] = false;
            }
            Session s = (Session)it.next();
            LinkedList<Score> l = s.results;
            ListIterator lit = l.listIterator();
            int ss = 0;
            while (lit.hasNext()) {
                score = (Score)lit.next();
                mean_bon += (double)score.bien / (double)score.n;
                mean_bad += (double)score.mal;
                nbPaires = nbPaires + score.n - 1;
                lettres[score.n] = lettres[score.n] + (double)score.bien / (double)score.n;
                lettre[score.n] = true;
                ++ss;
            }
            mean_bon = mean_bon / (double)ss * 100.0;
            mean_bad = mean_bad / (double)nbPaires * 100.0;
            for (int ll = 2; ll < 7; ++ll) {
                lettres[ll] = lettres[ll] / (double)ss * 100.0;
            }
            OrthoEVA.fen.serieOK.add((double)(i + 1), mean_bon);
            OrthoEVA.fen.serieBAD.add((double)(i + 1), mean_bad);
            if (lettre[2]) {
                OrthoEVA.fen.serie2.add((double)(i + 1), lettres[2]);
            } else {
                OrthoEVA.fen.serie2.add((double)(i + 1), (Number)null);
            }
            if (lettre[3]) {
                OrthoEVA.fen.serie3.add((double)(i + 1), lettres[3]);
            } else {
                OrthoEVA.fen.serie3.add((double)(i + 1), (Number)null);
            }
            if (lettre[4]) {
                OrthoEVA.fen.serie4.add((double)(i + 1), lettres[4]);
            } else {
                OrthoEVA.fen.serie4.add((double)(i + 1), (Number)null);
            }
            if (lettre[5]) {
                OrthoEVA.fen.serie5.add((double)(i + 1), lettres[5]);
            } else {
                OrthoEVA.fen.serie5.add((double)(i + 1), (Number)null);
            }
            if (lettre[6]) {
                OrthoEVA.fen.serie6.add((double)(i + 1), lettres[6]);
            } else {
                OrthoEVA.fen.serie6.add((double)(i + 1), (Number)null);
            }
            ++i;
        }
        OrthoEVA.fen.serieOK.setDescription("xx/xx/xxx");
        OrthoEVA.fen.xySeriesCollectionOK.addSeries(OrthoEVA.fen.serieOK);
        OrthoEVA.fen.xySeriesCollectionOK.addSeries(OrthoEVA.fen.serieBAD);
        OrthoEVA.fen.xySeriesCollectionBAD.addSeries(OrthoEVA.fen.serie2);
        OrthoEVA.fen.xySeriesCollectionBAD.addSeries(OrthoEVA.fen.serie3);
        OrthoEVA.fen.xySeriesCollectionBAD.addSeries(OrthoEVA.fen.serie4);
        OrthoEVA.fen.xySeriesCollectionBAD.addSeries(OrthoEVA.fen.serie5);
        OrthoEVA.fen.xySeriesCollectionBAD.addSeries(OrthoEVA.fen.serie6);
        OrthoEVA.fen.addChartPopupDelMenu(OrthoEVA.fen.chartPanelOK, UserInfo.resultatsRG);
        OrthoEVA.fen.addChartPopupDelMenu(OrthoEVA.fen.chartPanelBAD, UserInfo.resultatsRG);
        if (on) {
            if (mean_bon > 80.0) {
                snd = new SoundClips(3);
                snd.start();
            } else if (mean_bon > 70.0) {
                snd = new SoundClips(2);
                snd.start();
            }
        }
    }
}

