/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Properties;

public class MySQLClass {
    private static final String DATABASE_DRIVER = "com.mysql.jdbc.Driver";
    private static final String DATABASE_URL = "jdbc:mysql://fredericmaillet.fr/fmaillet_professionnels?autoReconnect=true";
    private static final String USERNAME = "fmaillet_fredo";
    private static final String PASSWORD = "mastercog";
    private static final String MAX_POOL = "250";
    public static Connection connection;
    private Properties properties;
    private Statement transmission;
    private ResultSet leResultat;

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.properties.setProperty("user", USERNAME);
            this.properties.setProperty("password", PASSWORD);
            this.properties.setProperty("MaxPooledStatements", MAX_POOL);
        }
        return this.properties;
    }

    public Connection connect() {
        if (connection != null) {
            try {
                if (!connection.isValid(100)) {
                    this.disconnect();
                }
                UserInfo.journal.addJournal("Connection still alive.");
            }
            catch (Exception e) {
                this.disconnect();
            }
        }
        if (connection == null) {
            try {
                Class.forName(DATABASE_DRIVER);
                DriverManager.setLoginTimeout(5);
                connection = DriverManager.getConnection(DATABASE_URL, this.getProperties());
                if (connection != null) {
                    connection.setAutoCommit(true);
                }
            }
            catch (ClassNotFoundException | SQLException exception) {
                // empty catch block
            }
            UserInfo.journal.addJournal("Connection.");
        }
        return connection;
    }

    public void disconnect() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            UserInfo.journal.addJournal("D\u00e9connection.");
        }
    }

    public static boolean getJeton(ResultSet r) {
        try {
            byte jeton = r.getByte("JETON");
            jeton = (byte)(jeton | 1);
            r.updateByte("JETON", jeton);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public void rendreJeton() {
        if (this.connect() != null) {
            try {
                this.transmission = connection.createStatement(1003, 1008);
                this.leResultat = this.transmission.executeQuery("select ADELI, JETON from Pro where ADELI = " + OrthoEVA.user.adeli);
                if (this.leResultat.next()) {
                    byte jeton = this.leResultat.getByte("JETON");
                    jeton = (byte)(jeton & 0xFE);
                    this.leResultat.updateByte("JETON", jeton);
                    this.leResultat.updateRow();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveJournal() {
        SaveJournalThrd sj = new SaveJournalThrd();
        Thread t = new Thread(sj);
        t.start();
    }

    public void saveAllDatas() {
        Runnable runnable;
        if (UserInfo.modifiedResultatsRG) {
            runnable = new SaveRGThrd();
        }
        if (UserInfo.modifiedResultatsFix) {
            runnable = new SaveFixThrd();
        }
        if (UserInfo.modifiedResultatsSaccade) {
            runnable = new SaveSaccadeThrd();
        }
        if (UserInfo.modifiedResultatsAntiSaccade) {
            runnable = new SaveAntiSaccadeThrd();
        }
        if (UserInfo.modifiedResultatsPerceptif) {
            runnable = new SavePerceptifThrd();
        }
    }

    public void loadAllPatientDatas() {
        long debut = System.currentTimeMillis();
        if (this.connect() != null) {
            try {
                String updateSQL = "SELECT RES_RG, RES_FIX, RES_SAC, RES_ASC, RES_PTF from Patients WHERE ID = " + UserInfo.currentPatient;
                PreparedStatement pstmt = connection.prepareStatement(updateSQL);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ObjectInputStream in;
                    InputStream input;
                    try {
                        input = rs.getBinaryStream("RES_RG");
                        if (input.available() > 0) {
                            in = new ObjectInputStream(input);
                            UserInfo.resultatsRG = (LinkedList)in.readObject();
                        }
                    }
                    catch (Exception e) {
                        UserInfo.journal.addJournal("loading RG: " + e.toString());
                    }
                    try {
                        input = rs.getBinaryStream("RES_FIX");
                        if (input.available() > 0) {
                            in = new ObjectInputStream(input);
                            UserInfo.resultatsFix = (LinkedList)in.readObject();
                        }
                    }
                    catch (Exception e) {
                        UserInfo.journal.addJournal("loading Fix: " + e.toString());
                    }
                    try {
                        input = rs.getBinaryStream("RES_SAC");
                        if (input.available() > 0) {
                            in = new ObjectInputStream(input);
                            UserInfo.resultatsSaccade = (LinkedList)in.readObject();
                        }
                    }
                    catch (Exception e) {
                        UserInfo.journal.addJournal("loading Sacc: " + e.toString());
                    }
                    try {
                        input = rs.getBinaryStream("RES_ASC");
                        if (input.available() > 0) {
                            in = new ObjectInputStream(input);
                            UserInfo.resultatsAntiSaccade = (LinkedList)in.readObject();
                        }
                    }
                    catch (Exception e) {
                        UserInfo.journal.addJournal("loading AntiSacc: " + e.toString());
                    }
                    try {
                        input = rs.getBinaryStream("RES_PTF");
                        if (input.available() > 0) {
                            in = new ObjectInputStream(input);
                            UserInfo.resultatsPerceptif = (LinkedList)in.readObject();
                        }
                    }
                    catch (Exception e) {
                        UserInfo.journal.addJournal("loading Perceptif: " + e.toString());
                    }
                }
                pstmt.close();
            }
            catch (Exception e) {
                UserInfo.journal.addJournal("loading: " + e.toString());
            }
        }
        if (UserInfo.resultatsRG == null) {
            UserInfo.resultatsRG = new LinkedList();
        }
        if (UserInfo.resultatsFix == null) {
            UserInfo.resultatsFix = new LinkedList();
        }
        if (UserInfo.resultatsSaccade == null) {
            UserInfo.resultatsSaccade = new LinkedList();
        }
        if (UserInfo.resultatsAntiSaccade == null) {
            UserInfo.resultatsAntiSaccade = new LinkedList();
        }
        if (UserInfo.resultatsPerceptif == null) {
            UserInfo.resultatsPerceptif = new LinkedList();
        }
        UserInfo.modifiedResultatsRG = false;
        UserInfo.modifiedResultatsFix = false;
        UserInfo.modifiedResultatsSaccade = false;
        UserInfo.modifiedResultatsAntiSaccade = false;
        UserInfo.modifiedResultatsPerceptif = false;
        UserInfo.journal.addJournal("Loading previous results (" + String.valueOf(System.currentTimeMillis() - debut) + " ms)");
    }

    public void loadPatientsList() {
        long debut = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        OrthoEVA.user.clearListePatients();
        if (this.connect() != null) {
            try {
                this.transmission = connection.createStatement(1003, 1008);
                this.leResultat = this.transmission.executeQuery("select ID, NOM, PRENOM, DN, SEX, ACTIF from Patients where ADELI = " + OrthoEVA.user.adeli);
                while (this.leResultat.next()) {
                    int pID = this.leResultat.getInt("ID");
                    String pNom = this.leResultat.getString("NOM");
                    String pPrenom = this.leResultat.getString("PRENOM");
                    String dn = this.leResultat.getString("DN");
                    Boolean actif = this.leResultat.getBoolean("ACTIF");
                    int sex = this.leResultat.getInt("SEX");
                    if (dn == null) {
                        dn = "1980-01-01";
                    }
                    java.util.Date d = sdf.parse(dn);
                    OrthoEVA.user.addPatients(pID, pNom, pPrenom, d, sex, actif);
                }
            }
            catch (SQLException | ParseException e) {
                UserInfo.journal.addJournal(e.toString());
            }
            UserInfo.journal.addJournal("Base Patients charg\u00e9e (" + String.valueOf(System.currentTimeMillis() - debut) + " ms)");
        } else {
            UserInfo.journal.addJournal("Base Patients pas charg\u00e9e !");
        }
    }

    public int addNewPatient(String pNom, String pPrenom, int sex, java.util.Date pDN) {
        int resultID = 0;
        if (this.connect() != null) {
            try {
                String query = "insert into Patients (ADELI, NOM, PRENOM, DN, SEX, ACTIF) values (?, ?, ?, ?, ?, ?)";
                PreparedStatement pStmt = connection.prepareStatement(query, 1);
                pStmt.setInt(1, Integer.parseUnsignedInt(OrthoEVA.user.adeli));
                pStmt.setString(2, pNom);
                pStmt.setString(3, pPrenom);
                if (pDN != null) {
                    pStmt.setDate(4, new Date(pDN.getTime()));
                } else {
                    pStmt.setDate(4, null);
                }
                pStmt.setInt(5, sex);
                pStmt.setBoolean(6, true);
                pStmt.execute();
                ResultSet rs = pStmt.getGeneratedKeys();
                if (rs.next()) {
                    resultID = rs.getInt(1);
                }
                pStmt.close();
            }
            catch (Exception e) {
                UserInfo.journal.addJournal(e.toString());
                return 0;
            }
        }
        UserInfo.currentPatient = resultID;
        UserInfo.disposeAllResultats();
        SaveRGThrd rg = new SaveRGThrd();
        SaveFixThrd fx = new SaveFixThrd();
        SaveSaccadeThrd sc = new SaveSaccadeThrd();
        SaveAntiSaccadeThrd as = new SaveAntiSaccadeThrd();
        SavePerceptifThrd pc = new SavePerceptifThrd();
        return resultID;
    }

    public void deletePatient(int selectedID) {
        if (this.connect() != null) {
            try {
                String query = "delete from Patients where ID = ?";
                PreparedStatement pStmt = connection.prepareStatement(query);
                pStmt.setInt(1, selectedID);
                pStmt.execute();
                pStmt.close();
            }
            catch (Exception e) {
                UserInfo.journal.addJournal(e.toString());
            }
        }
    }

    public void updatePatient(int selectedID, String newNom, String newPrenom, int newSex, java.util.Date newDN) {
        if (this.connect() != null) {
            try {
                String query = "update Patients set NOM = ?, PRENOM = ?, SEX = ?, DN = ? where ID = ?";
                PreparedStatement pStmt = connection.prepareStatement(query);
                pStmt.setString(1, newNom);
                pStmt.setString(2, newPrenom);
                pStmt.setInt(3, newSex);
                if (newDN != null) {
                    pStmt.setDate(4, new Date(newDN.getTime()));
                } else {
                    pStmt.setDate(4, null);
                }
                pStmt.setInt(5, selectedID);
                pStmt.executeUpdate();
                pStmt.close();
                UserInfo.journal.addJournal("Patient " + selectedID + " updated");
            }
            catch (Exception e) {
                UserInfo.journal.addJournal(e.toString());
            }
        }
    }
}

