/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.Random;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public class QLearning {
    int newState;
    int oldState;
    int action;
    double reward;
    double[][] qMatrice = new double[3][3];
    double gamma = 0.5;
    static Random rand;

    QLearning() {
        this.initqMatrice();
        this.action = 0;
        this.oldState = 0;
        rand = new Random();
    }

    public void initqMatrice() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.qMatrice[i][j] = 0.0;
            }
        }
    }

    public int calcState(LinkedList<Score> r) {
        double[][] datas = new double[2][3];
        SimpleRegression regression = new SimpleRegression();
        this.oldState = this.newState;
        if (r.size() < 3) {
            this.newState = 0;
        } else {
            Score s3 = r.get(r.size() - 3);
            regression.addData(0.0, s3.bien);
            Score s2 = r.get(r.size() - 2);
            regression.addData(1.0, s2.bien);
            Score s1 = r.get(r.size() - 1);
            regression.addData(2.0, s1.bien);
            double slope = regression.getSlope();
            System.out.println("slope = " + slope);
            this.newState = slope > -0.25 && slope < 0.25 ? 0 : (slope > 0.0 ? 1 : 2);
        }
        regression.clear();
        return this.newState;
    }

    public double calcReward(LinkedList<Score> r) {
        Score s = r.getLast();
        Score ss = r.get(r.size() - 2);
        this.reward = (double)s.bien * 200.0 / (double)s.speed;
        if (s.bien - ss.bien < 0) {
            this.reward = -this.reward;
        }
        return this.reward;
    }

    public void updateQMatrice() {
        this.qMatrice[this.oldState][this.action] = this.reward + this.gamma * this.findMax(this.qMatrice[this.newState]);
    }

    public int selectAction() {
        this.action = rand.nextInt(3) == 0 ? rand.nextInt(3) : this.findMaxArg(this.qMatrice[this.newState]);
        return this.action;
    }

    double findMax(double[] d) {
        double max = d[0];
        for (int i = 1; i < d.length; ++i) {
            if (!(d[i] > max)) continue;
            max = d[i];
        }
        return max;
    }

    int findMaxArg(double[] d) {
        int max = 0;
        for (int i = 1; i < d.length; ++i) {
            if (!(d[i] > d[max])) continue;
            max = i;
        }
        return max;
    }
}

