/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class Synthese
extends Thread {
    int nbSession = 0;
    int nbSeances = 0;
    double[][] meansOfRGSessions;
    double[][] meansOfRGSeances;
    public static ArrayList datesOfSeances;
    HTMLEditorKit kit;
    HTMLDocument doc;
    SimpleRegression regression;

    public Synthese() {
        this.setName("Synthese");
        datesOfSeances = new ArrayList();
        this.kit = new HTMLEditorKit();
        this.doc = new HTMLDocument();
        PanelSynthese.jTextRG.setEditorKit(this.kit);
        PanelSynthese.jTextMOC.setEditorKit(this.kit);
        PanelSynthese.jTextCS.setEditorKit(this.kit);
        PanelSynthese.jTextRG.setDocument(this.doc);
    }

    @Override
    public void run() {
        StringBuilder text = new StringBuilder();
        OrthoEVA.fen.serieBAD = new XYSeries((Comparable)((Object)"% report"));
        OrthoEVA.fen.xySeriesCollectionBAD.removeAllSeries();
        OrthoEVA.fen.jPatient.setEnabled(false);
        OrthoEVA.fen.setCursor(Cursor.getPredefinedCursor(3));
        this.nbSeances = 0;
        this.nbSession = 0;
        this.computeRG();
        if (this.nbSession == 0) {
            text.append("Aucune donn\u00e9es \u00e0 traiter...");
        } else {
            text.append("Cette activit\u00e9 a \u00e9t\u00e9 lanc\u00e9e " + this.nbSession + " fois sur " + this.nbSeances + " s\u00e9ances de travail, soit ");
            int m = this.nbSession / this.nbSeances;
            if (this.nbSession % this.nbSeances != 0) {
                text.append("environ ");
            }
            text.append(m + " fois par s\u00e9ance, ce qui est plut\u00f4t ");
            if (m < 3) {
                text.append("en dessous de ");
            } else if (m > 5) {
                text.append("au dessus de ");
            } else {
                text.append("dans ");
            }
            text.append("la moyenne pour cette tranche d'\u00e2ge.<br>");
            if (this.nbSeances == 1) {
                text.append("Il n'y a qu'une seule s\u00e9ance dont le r\u00e9sultat moyen est de " + String.format("%.1f", this.meansOfRGSeances[0][1]) + "% de r\u00e9ussite.");
            } else if (this.nbSeances > 1) {
                text.append("La performance progresse ");
                if (this.regression.getR() > 0.0) {
                    text.append(" ");
                } else if (this.regression.getR() < 0.8) {
                    text.append("mal ");
                } else {
                    text.append("peu ");
                }
                text.append("avec l'entra\u00eenement (r=" + String.format("%.2f", this.regression.getR()) + "). ");
                if (this.regression.getR() > 0.0) {
                    text.append("Cet entra\u00eenement participe \u00e0 hauteur de " + String.format("%.0f", this.regression.getRSquare() * 100.0) + "% de l'\u00e9volution. ");
                }
                text.append("La derni\u00e8re s\u00e9ance affiche un r\u00e9sultat moyen de " + String.format("%.1f", this.meansOfRGSeances[this.meansOfRGSeances.length - 1][1]) + "% de r\u00e9ussite, ");
                text.append("contre " + String.format("%.1f", this.meansOfRGSeances[0][1]) + "% pour la premi\u00e8re. ");
                if (this.meansOfRGSeances[this.meansOfRGSeances[0].length - 1][1] < this.meansOfRGSeances[0][1]) {
                    text.append("Cette diminution ");
                    if (this.regression.getSlope() > 0.0) {
                        text.append("cache toutefois une ");
                        if (this.regression.getSlope() < 10.0) {
                            text.append("discr\u00e8te ");
                        }
                        text.append("tendance globale \u00e0 la hausse ");
                    } else {
                        text.append("est confirm\u00e9e par une ");
                        if (this.regression.getSlope() > 10.0) {
                            text.append("nette ");
                        }
                        text.append("tendance globale \u00e0 la baisse ");
                    }
                    text.append("de quelques " + String.format("%.0f", this.regression.getSlope()) + " points en moyenne par s\u00e9ance.");
                } else if (this.meansOfRGSeances[this.meansOfRGSeances[0].length - 1][1] > this.meansOfRGSeances[0][1]) {
                    text.append("Cette augmentation ");
                    if (this.regression.getSlope() > 0.0) {
                        text.append("se confirme par une ");
                        if (this.regression.getSlope() > 15.0) {
                            text.append("nette ");
                        }
                        text.append("tendance globale \u00e0 la hausse ");
                    } else {
                        text.append("cache toutefois une ");
                        if (this.regression.getSlope() < 15.0) {
                            text.append("nette ");
                        }
                        text.append("tendance globale \u00e0 la baisse ");
                    }
                    text.append("de quelques " + String.format("%.0f", this.regression.getSlope()) + " points en moyenne par s\u00e9ance.");
                }
            }
        }
        this.addText(text.toString());
        PanelSynthese.jTextMOC.setText("<i>Synth\u00e8se non disponible pour l'instant</i>");
        PanelSynthese.jTextCS.setText("<i>Synth\u00e8se non disponible pour l'instant</i>");
        OrthoEVA.fen.jPatient.setEnabled(true);
        OrthoEVA.fen.setCursor(Cursor.getDefaultCursor());
    }

    void addText(String s) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength() - 14, s, 0, 0, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void computeRG() {
        int i;
        int i2;
        Date newDate = null;
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy");
        this.nbSession = 0;
        this.meansOfRGSessions = new double[UserInfo.resultatsRG.size()][2];
        this.nbSeances = 0;
        double[][] MeansByLetter = new double[UserInfo.resultatsRG.size()][6];
        if (MainFenetre.dataRG != null) {
            MainFenetre.dataRG.clear();
        } else {
            MainFenetre.dataRG = new DefaultCategoryDataset();
        }
        ListIterator it = UserInfo.resultatsRG.listIterator();
        while (it.hasNext()) {
            Session s = (Session)it.next();
            if (newDate == null) {
                newDate = OrthoEVA.setDateZeroTime(s.date);
                this.nbSeances = 1;
                datesOfSeances.add(df.format(s.date));
            } else if (newDate.compareTo(OrthoEVA.setDateZeroTime(s.date)) != 0) {
                newDate = OrthoEVA.setDateZeroTime(s.date);
                datesOfSeances.add(df.format(s.date));
                ++this.nbSeances;
            }
            this.meansOfRGSessions[this.nbSession][0] = this.nbSeances;
            this.meansOfRGSessions[this.nbSession][1] = this.meanSessionRG(s) * 100.0;
            MeansByLetter[this.nbSession] = this.meanLetterScoresRG(s);
            ++this.nbSession;
        }
        if (this.nbSession == 0) {
            return;
        }
        this.meansOfRGSeances = new double[this.nbSeances][2];
        this.meansOfRGSeances[0][0] = 1.0;
        this.meansOfRGSeances[0][1] = this.meansOfRGSessions[0][1];
        int seanceEnCours = 1;
        int ponderation = 1;
        double[][] meansOfRGparLettres = new double[6][2];
        for (i2 = 0; i2 < this.nbSeances; ++i2) {
            for (int j = 0; j < 2; ++j) {
                meansOfRGparLettres[i2][j] = 0.0;
            }
        }
        for (i2 = 1; i2 < this.nbSession; ++i2) {
            if (this.meansOfRGSessions[i2][0] == (double)seanceEnCours) {
                this.meansOfRGSeances[seanceEnCours - 1][1] = (this.meansOfRGSeances[seanceEnCours - 1][1] * (double)ponderation + this.meansOfRGSessions[i2][1]) / ((double)ponderation + 1.0);
                ++ponderation;
                continue;
            }
            OrthoEVA.fen.serieBAD.add((double)seanceEnCours, this.meansOfRGSeances[seanceEnCours - 1][1]);
            this.meansOfRGSeances[seanceEnCours][0] = seanceEnCours + 1;
            this.meansOfRGSeances[seanceEnCours][1] = this.meansOfRGSessions[i2][1];
            ++seanceEnCours;
            ponderation = 1;
        }
        OrthoEVA.fen.serieBAD.add((double)seanceEnCours, this.meansOfRGSeances[seanceEnCours - 1][1]);
        OrthoEVA.fen.serieBAD.setDescription("datesOfSeances");
        OrthoEVA.fen.xySeriesCollectionBAD.addSeries(OrthoEVA.fen.serieBAD);
        double maxRange = 0.0;
        for (i = 0; i < this.nbSession; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (!(MeansByLetter[i][j] > -1.0)) continue;
                double[] dArray = meansOfRGparLettres[j];
                dArray[0] = dArray[0] + MeansByLetter[i][j];
                double[] dArray2 = meansOfRGparLettres[j];
                dArray2[1] = dArray2[1] + 1.0;
            }
        }
        for (i = 0; i < 6; ++i) {
            if (meansOfRGparLettres[i][1] > 0.0) {
                meansOfRGparLettres[i][0] = meansOfRGparLettres[i][0] / meansOfRGparLettres[i][1];
            }
            if (!(meansOfRGparLettres[i][0] > maxRange)) continue;
            maxRange = meansOfRGparLettres[i][0];
        }
        if (meansOfRGparLettres[0][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[0][0], (Comparable)((Object)"Moy. totale"), (Comparable)((Object)"2 lettres"));
        }
        if (meansOfRGparLettres[1][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[1][0], (Comparable)((Object)"Moy. totale"), (Comparable)((Object)"3 lettres"));
        }
        if (meansOfRGparLettres[2][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[2][0], (Comparable)((Object)"Moy. totale"), (Comparable)((Object)"4 lettres"));
        }
        if (meansOfRGparLettres[3][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[3][0], (Comparable)((Object)"Moy. totale"), (Comparable)((Object)"5 lettres"));
        }
        if (meansOfRGparLettres[4][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[4][0], (Comparable)((Object)"Moy. totale"), (Comparable)((Object)"6 lettres"));
        }
        if (meansOfRGparLettres[0][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[0][0] / 2.0, (Comparable)((Object)"Moy. 3 derniers"), (Comparable)((Object)"2 lettres"));
        }
        if (meansOfRGparLettres[1][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[1][0] / 2.0, (Comparable)((Object)"Moy. 3 derniers"), (Comparable)((Object)"3 lettres"));
        }
        if (meansOfRGparLettres[2][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[2][0] / 2.0, (Comparable)((Object)"Moy. 3 derniers"), (Comparable)((Object)"4 lettres"));
        }
        if (meansOfRGparLettres[3][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[3][0] / 2.0, (Comparable)((Object)"Moy. 3 derniers"), (Comparable)((Object)"5 lettres"));
        }
        if (meansOfRGparLettres[4][1] > 0.0) {
            MainFenetre.dataRG.setValue(meansOfRGparLettres[4][0] / 2.0, (Comparable)((Object)"Moy. 3 derniers"), (Comparable)((Object)"6 lettres"));
        }
        CategoryPlot p = OrthoEVA.fen.chartPanelOK.getChart().getCategoryPlot();
        NumberAxis r = (NumberAxis)p.getRangeAxis();
        maxRange = (Math.ceil(maxRange / 10.0) + 1.0) * 10.0;
        r.setUpperBound(maxRange);
        OrthoEVA.fen.chartPanelOK.setVisible(true);
        this.regression = new SimpleRegression();
        this.regression.addData(this.meansOfRGSeances);
        LineFunction2D linefunction2d = new LineFunction2D(this.regression.getIntercept(), this.regression.getSlope());
        XYDataset dataset = DatasetUtilities.sampleFunction2D(linefunction2d, 0.5, (double)seanceEnCours + 0.5, 20, (Comparable)((Object)"Fitted Regression Line"));
        try {
            Synthese.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        XYPlot xyplot = OrthoEVA.fen.chartPanelBAD.getChart().getXYPlot();
        XYLineAndShapeRenderer xylineandshaperenderer = new XYLineAndShapeRenderer(true, false);
        xylineandshaperenderer.setSeriesPaint(0, Color.YELLOW);
        xyplot.setRenderer(1, xylineandshaperenderer);
        xyplot.setDataset(1, dataset);
    }

    double meanSessionRG(Session s) {
        LinkedList<Score> l = s.results;
        ListIterator lit = l.listIterator();
        double mean_bon = 0.0;
        int nb = 0;
        while (lit.hasNext()) {
            Score score = (Score)lit.next();
            mean_bon += (double)score.bien / (double)score.n;
            ++nb;
        }
        return mean_bon /= (double)nb;
    }

    double[] meanLetterScoresRG(Session s) {
        double[] byLetter = new double[6];
        for (int i = 0; i < 6; ++i) {
            byLetter[i] = -1.0;
        }
        LinkedList<Score> l = s.results;
        ListIterator lit = l.listIterator();
        int nb = 0;
        while (lit.hasNext()) {
            Score score = (Score)lit.next();
            if (byLetter[score.n - 2] == -1.0) {
                byLetter[score.n - 2] = 0.0;
            }
            byLetter[score.n - 2] = byLetter[score.n - 2] + (double)score.bien / (double)score.n;
            ++nb;
        }
        for (int i = 0; i < 6; ++i) {
            if (!(byLetter[i] > -1.0)) continue;
            byLetter[i] = byLetter[i] / (double)nb * 100.0;
        }
        return byLetter;
    }
}

