/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;

public class UserInfo {
    String nom;
    String prenom;
    String titre;
    String message;
    String activite;
    String adeli;
    String code;
    String mail;
    String adr1;
    String adr2;
    String cp;
    String ville;
    String tel1;
    String tel2;
    public static LinkedList resultatsRG;
    public static boolean modifiedResultatsRG;
    public static LinkedList resultatsFix;
    public static boolean modifiedResultatsFix;
    public static LinkedList resultatsSaccade;
    public static boolean modifiedResultatsSaccade;
    public static LinkedList resultatsAntiSaccade;
    public static boolean modifiedResultatsAntiSaccade;
    public static LinkedList resultatsPerceptif;
    public static boolean modifiedResultatsPerceptif;
    public static LinkedList listePatients;
    public static int currentPatient;
    public static String macaddress;
    static final int softVersion = 26;
    public static DialogJournal journal;

    public UserInfo() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date date = new Date();
        journal = new DialogJournal((Frame)OrthoEVA.fen, true);
        journal.addJournal("===========================");
        journal.addJournal("D\u00e9marrage : " + dateFormat.format(date));
        this.nom = null;
        currentPatient = 0;
        resultatsRG = new LinkedList();
        resultatsFix = new LinkedList();
        resultatsSaccade = new LinkedList();
        resultatsAntiSaccade = new LinkedList();
        resultatsPerceptif = new LinkedList();
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            macaddress = sb.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSoftVersion() {
        return "v.2.6.2 du 03/12/2022";
    }

    public static void disposeAllResultats() {
        resultatsRG.clear();
        modifiedResultatsRG = false;
        resultatsFix.clear();
        modifiedResultatsFix = false;
        resultatsSaccade.clear();
        modifiedResultatsSaccade = false;
        resultatsAntiSaccade.clear();
        modifiedResultatsAntiSaccade = false;
        resultatsPerceptif.clear();
        modifiedResultatsPerceptif = false;
    }

    public static boolean areThereModifiedResults() {
        return modifiedResultatsRG || modifiedResultatsFix || modifiedResultatsSaccade || modifiedResultatsAntiSaccade || modifiedResultatsPerceptif;
    }

    public void clearListePatients() {
        if (listePatients != null) {
            listePatients.clear();
        }
        listePatients = new LinkedList();
    }

    public void addPatients(int id, String n, String nn, Date d, int sex, Boolean a) {
        Patient p = new Patient();
        p.id = id;
        p.nom = n;
        p.prenom = nn;
        p.dn = d;
        p.sex = sex;
        p.actif = a;
        listePatients.add(p);
    }

    public void activatePatient(int id) {
        journal.addJournal("Patient actif : " + id);
        currentPatient = id;
        ListIterator lit = listePatients.listIterator();
        while (lit.hasNext()) {
            Patient pP = (Patient)lit.next();
            if (pP.id != id) continue;
            OrthoEVA.fen.jPatient.setText(pP.nom + " " + pP.prenom);
            break;
        }
        UserInfo.disposeAllResultats();
        if (OrthoEVA.fen.reportGlobalMenu.isSelected()) {
            LaunchRG.computeChartsRG(false);
        } else if (OrthoEVA.fen.fixationMenu.isSelected()) {
            LaunchFixation.computeChartsFixation(false);
        } else if (OrthoEVA.fen.saccadeMenu.isSelected()) {
            LaunchSaccade.computeChartsSaccade(false);
        } else if (OrthoEVA.fen.antisaccadeMenu.isSelected()) {
            LaunchSaccade.computeChartsAntiSaccade(false);
        } else if (OrthoEVA.fen.empanMenu.isSelected()) {
            LaunchPerceptif.computeChartsPerceptif(false);
        } else if (OrthoEVA.fen.syntheseMenu.isSelected()) {
            Synthese s = new Synthese();
            s.start();
        }
    }

    static {
        modifiedResultatsRG = false;
        modifiedResultatsFix = false;
        modifiedResultatsSaccade = false;
        modifiedResultatsAntiSaccade = false;
        modifiedResultatsPerceptif = false;
        macaddress = null;
    }
}

