/*
 * Decompiled with CFR 0.152.
 */
package ch.aplu.jaw;

import ch.aplu.jaw.TrayIcon;
import ch.aplu.jaw.TrayIconListener;

public class NativeHandler {
    protected long ref = 0L;
    private Object exposedObj = null;
    private int select;
    private String title;
    private int xPos;
    private int yPos;
    private int width;
    private int height;
    private long windowStyle;
    private String iconPath = null;
    private String tooltip = "";
    private String balloon_tooltip_title = "";
    private String balloon_tooltip = "";
    private int iconEventMask;
    private final int defaultBufSize = 1000;
    private boolean isEnabled = false;
    private TrayIconListener trayIconListener;
    private TrayIcon trayIcon = new TrayIcon();
    private final int iconEventBufSize = 100;
    private int[] iconEventBuf = new int[100];
    private boolean isTrayIconVisible = false;
    private volatile boolean isThreadRunning = false;
    private IconEventThread iconEventThread;
    public static final long WS_OVERLAPPED = 0L;
    public static final long WS_SYSMENU = 524288L;
    public static final long WS_BORDER = 0x800000L;
    public static final long WS_POPUP = 0x80000000L;
    public static final long WS_MINIMIZEBOX = 131072L;
    public static final long WS_MAXIMIZEBOX = 65536L;
    public static final long WS_THICKFRAME = 262144L;
    public static final long WS_CAPTION = 0xC00000L;
    public static final long WS_VISIBLE = 0x10000000L;
    public static final long WS_EX_TRANSPARENT = 32L;
    public static final long WS_MINIMIZE = 0x20000000L;
    public static final long WS_MAXIMIZE = 0x1000000L;
    public static final long WS_DLGFRAME = 0x400000L;
    public static final long WS_VSCROLL = 0x200000L;
    public static final long WS_HSCROLL = 0x100000L;
    public static final long WS_DEFAULT = 282001408L;
    public static final long WS_OVERLAPPEDWINDOW = 0xCF0000L;
    public static final long WS_POPUPWINDOW = 0x80880000L;
    private int aryLength;

    private synchronized native void nativeEnable(int var1);

    private synchronized native void nativeDestroy(long var1);

    private synchronized native void nativeSetWindowPosition(long var1, int var3, int var4);

    private synchronized native void nativeSetWindowSize(long var1, int var3, int var4);

    private synchronized native void nativeShowWindow(long var1, boolean var3, int var4, int var5, int var6, int var7, boolean var8);

    private synchronized native int nativeInvoke(long var1, int var3);

    private synchronized native void nativeCreateBuf(long var1, boolean[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, char[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, byte[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, short[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, int[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, long[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, float[] var3, int var4);

    private synchronized native void nativeCreateBuf(long var1, double[] var3, int var4);

    private synchronized native int nativeReadBuf(long var1, int var3);

    private synchronized native void nativeFlushBuf(long var1);

    private synchronized native int nativeCountBuf(long var1);

    private synchronized native boolean nativeIsOverflow(long var1, boolean var3);

    private synchronized native void nativeStartThread(long var1);

    private synchronized native void nativeStopThread(long var1);

    private synchronized native void nativeExpose(long var1, Object var3);

    private synchronized native void nativeCreateTrayIcon(long var1);

    private synchronized native void nativeModifyTrayIcon(long var1);

    private synchronized native void nativeDeleteTrayIcon(long var1);

    private synchronized native void nativeCreateIconEventBuf(long var1, int[] var3, int var4);

    private synchronized native int nativeReadIconEventBuf(long var1, int[] var3, int var4);

    private synchronized native void nativeShowBalloonTooltip(long var1, int var3, int var4);

    public NativeHandler(String dllPath, Object exposedObj, int select, String title, int ulx, int uly, int width, int height, long windowStyle) {
        this.exposedObj = exposedObj;
        this.loadLib(dllPath);
        this.init(select, title, ulx, uly, width, height, windowStyle);
    }

    public NativeHandler(String dllPath, Object exposedObj, String title, int ulx, int uly, int width, int height, long windowStyle) {
        this.exposedObj = exposedObj;
        this.loadLib(dllPath);
        this.init(0, title, ulx, uly, width, height, windowStyle);
    }

    public NativeHandler(String dllPath, String title, int ulx, int uly, int width, int height, long windowStyle) {
        this.loadLib(dllPath);
        this.init(0, title, ulx, uly, width, height, windowStyle);
    }

    public NativeHandler(String dllPath, Object exposedObj, int select) {
        this.exposedObj = exposedObj;
        this.loadLib(dllPath);
        this.init(select, "", 0, 0, 0, 0, 0L);
    }

    public NativeHandler(String dllPath, Object exposedObj) {
        this.exposedObj = exposedObj;
        this.loadLib(dllPath);
        this.init(0, "", 0, 0, 0, 0, 0L);
    }

    public NativeHandler(String dllPath, int select) {
        this.loadLib(dllPath);
        this.init(select, "", 0, 0, 0, 0, 0L);
    }

    public NativeHandler(String dllPath) {
        this.loadLib(dllPath);
        this.init(0, "", 0, 0, 0, 0, 0L);
    }

    public void expose(Object exposedObj) {
        if (this.isEnabled) {
            this.nativeExpose(this.ref, exposedObj);
        }
    }

    public void showWindow() {
        if (this.isEnabled) {
            this.nativeShowWindow(this.ref, true, 100, 255, 255, 255, false);
        }
    }

    public void showWindow(int percent) {
        if (this.isEnabled) {
            this.nativeShowWindow(this.ref, true, percent, 255, 255, 255, false);
        }
    }

    public void showWindow(int percent, int red, int green, int blue) {
        if (this.isEnabled) {
            this.nativeShowWindow(this.ref, true, percent, red, green, blue, false);
        }
    }

    public void hideWindow() {
        if (this.isEnabled) {
            this.nativeShowWindow(this.ref, false, 100, 255, 255, 255, false);
        }
    }

    public void setWindowPosition(int ulx, int uly) {
        if (this.isEnabled) {
            this.nativeSetWindowPosition(this.ref, ulx, uly);
        }
    }

    public void setWindowSize(int width, int height) {
        if (this.isEnabled) {
            this.nativeSetWindowSize(this.ref, width, height);
        }
    }

    public void destroy() {
        if (this.isEnabled) {
            this.isEnabled = false;
            if (this.isThreadRunning) {
                this.isThreadRunning = false;
                try {
                    this.iconEventThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.nativeDestroy(this.ref);
        }
    }

    public int invoke(int val) {
        if (this.isEnabled) {
            return this.nativeInvoke(this.ref, val);
        }
        return 0;
    }

    public int invoke() {
        return this.invoke(0);
    }

    public void createBuf(boolean[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(boolean[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(char[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(char[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(byte[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(byte[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(short[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(short[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(int[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(int[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(long[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(long[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(float[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(float[] ary) {
        this.createBuf(ary, 1000);
    }

    public void createBuf(double[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.aryLength = ary.length;
            this.nativeCreateBuf(this.ref, ary, bufSize);
        }
    }

    public void createBuf(double[] ary) {
        this.createBuf(ary, 1000);
    }

    public int readBuf(int count) {
        if (this.isEnabled) {
            if (count == 0) {
                return 0;
            }
            if (count < 0 || count > this.aryLength) {
                return -1;
            }
            int rc = this.nativeReadBuf(this.ref, count);
            return rc;
        }
        return -1;
    }

    public void flushBuf() {
        if (this.isEnabled) {
            this.nativeFlushBuf(this.ref);
        }
    }

    public int countBuf() {
        if (this.isEnabled) {
            return this.nativeCountBuf(this.ref);
        }
        return -1;
    }

    public boolean isBufOverflow(boolean reset) {
        if (this.isEnabled) {
            return this.nativeIsOverflow(this.ref, reset);
        }
        return false;
    }

    public void startThread() {
        if (this.isEnabled) {
            this.nativeStartThread(this.ref);
        }
    }

    public void stopThread() {
        if (this.isEnabled) {
            this.nativeStopThread(this.ref);
        }
    }

    public void addTrayIconListener(TrayIconListener listener, int iconEventMask) {
        if (!this.isEnabled) {
            return;
        }
        this.trayIconListener = listener;
        this.iconEventMask = iconEventMask;
        this.createIconEventBuf(this.iconEventBuf, 100);
        if (!this.isThreadRunning) {
            this.isThreadRunning = true;
            this.iconEventThread = new IconEventThread();
            this.iconEventThread.start();
        }
    }

    public void showIcon(String iconPath, String tooltip) {
        if (this.isEnabled) {
            this.iconPath = iconPath;
            this.tooltip = tooltip;
            if (this.isTrayIconVisible) {
                this.nativeModifyTrayIcon(this.ref);
            } else {
                this.isTrayIconVisible = true;
                this.nativeCreateTrayIcon(this.ref);
            }
        }
    }

    public void showIcon(String iconPath) {
        this.showIcon(iconPath, "");
    }

    public void hideIcon() {
        if (this.isEnabled && this.isTrayIconVisible) {
            this.isTrayIconVisible = false;
            this.nativeDeleteTrayIcon(this.ref);
        }
    }

    public void showBalloonTooltip(String title, String text, int flag, int timeout) {
        if (this.isEnabled && this.isTrayIconVisible) {
            this.balloon_tooltip_title = title;
            this.balloon_tooltip = text;
            this.nativeShowBalloonTooltip(this.ref, timeout, flag);
        }
    }

    private void loadLib(String dllPath) {
        try {
            System.loadLibrary(dllPath);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                System.load(dllPath);
            }
            catch (UnsatisfiedLinkError ex) {
                throw new RuntimeException("Can't load DLL " + dllPath);
            }
        }
    }

    private void init(int select, String title, int xPos, int yPos, int width, int height, long windowStyle) {
        this.title = title;
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
        this.windowStyle = windowStyle;
        this.nativeEnable(select);
        this.isEnabled = true;
    }

    private void createIconEventBuf(int[] ary, int bufSize) {
        if (this.isEnabled && bufSize > 0) {
            this.nativeCreateIconEventBuf(this.ref, ary, bufSize);
        }
    }

    private int readIconEventBuf(int[] ary, int count) {
        if (this.isEnabled) {
            if (count == 0) {
                return 0;
            }
            if (count < 0 || count > ary.length) {
                return -1;
            }
            return this.nativeReadIconEventBuf(this.ref, ary, count);
        }
        return -1;
    }

    protected void showWindow(int percent, int red, int green, int blue, boolean wait) {
        if (this.isEnabled) {
            this.nativeShowWindow(this.ref, true, percent, red, green, blue, wait);
        }
    }

    class IconEventThread
    extends Thread {
        IconEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (NativeHandler.this.isThreadRunning) {
                TrayIconListener trayIconListener = NativeHandler.this.trayIconListener;
                synchronized (trayIconListener) {
                    if (NativeHandler.this.readIconEventBuf(NativeHandler.this.iconEventBuf, 1) == 1) {
                        NativeHandler.this.trayIcon.setEvent(NativeHandler.this.iconEventBuf[0]);
                        NativeHandler.this.trayIconListener.iconEvent(NativeHandler.this.trayIcon);
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

