/*
 * Decompiled with CFR 0.152.
 */
package ch.aplu.xboxcontroller;

import ch.aplu.jaw.NativeHandler;
import ch.aplu.xboxcontroller.ControllerState;
import ch.aplu.xboxcontroller.DigitalCallback;
import ch.aplu.xboxcontroller.XboxControllerListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class XboxController {
    private static final String version = "1.06";
    private boolean is64bit;
    private NativeHandler nh;
    private Timer pollTimer = null;
    private boolean isDisconnected = true;
    private short[] values = new short[9];
    private int queuePollPeriod;
    private boolean debug = false;
    private int controllerPollPeriod;
    private XboxControllerListener listener;
    private long buttonState = 0L;
    private int dpadState = -1;
    private int dpadDirection;
    private int controllerNum;
    private int leftVal;
    private int rightVal;
    private double oldLeftTriggerValue = -1.0;
    private double oldRightTriggerValue = -1.0;
    private double oldLeftMagnitude = -1.0;
    private double oldRightMagnitude = -1.0;
    private double oldLeftDir = -1.0;
    private double oldRightDir = -1.0;
    private short leftTriggerDeadZone = 0;
    private short rightTriggerDeadZone = 0;
    private short leftThumbDeadZone = 0;
    private short rightThumbDeadZone = 0;

    public XboxController() {
        if (this.is64bit()) {
            this.init("xboxcontroller64", 1, 50, 50);
        } else {
            this.init("xboxcontroller", 1, 50, 50);
        }
    }

    public XboxController(int controllerPollPeriod, int queuePollPeriod) {
        if (this.is64bit()) {
            this.init("xboxcontroller64", 1, controllerPollPeriod, queuePollPeriod);
        } else {
            this.init("xboxcontroller", 1, controllerPollPeriod, queuePollPeriod);
        }
    }

    public XboxController(int playerNb) {
        if (this.is64bit()) {
            this.init("xboxcontroller64", playerNb, 50, 50);
        } else {
            this.init("xboxcontroller", playerNb, 50, 50);
        }
    }

    public XboxController(String dll, int playerNb, int controllerPollPeriod, int queuePollPeriod) {
        this.init(dll, playerNb, controllerPollPeriod, queuePollPeriod);
    }

    private void init(String dll, int playerNb, int controllerPollPeriod, int queuePollPeriod) {
        System.out.println("XboxController V1.06 (www.aplu.ch)");
        System.out.println("Current JVM: " + System.getProperty("sun.arch.data.model") + " bit");
        this.controllerPollPeriod = controllerPollPeriod;
        this.queuePollPeriod = queuePollPeriod;
        if (playerNb < 1 || playerNb > 4) {
            JOptionPane.showMessageDialog(null, "Xboxcontroller number must be 1..4", "Fatal error while creating Xboxcontroller", 0);
            System.exit(1);
        }
        this.controllerNum = playerNb - 1;
        this.nh = new NativeHandler(dll, this);
        this.nh.createBuf(this.values);
        this.nh.startThread();
        while (this.nh.invoke(0) == 0) {
            this.delay(50);
        }
        if (this.nh.invoke(1) == 1) {
            this.isDisconnected = false;
        }
    }

    public void release() {
        this.isDisconnected = true;
        if (this.pollTimer != null) {
            this.pollTimer.stop();
        }
        this.nh.destroy();
    }

    public void setLeftTriggerDeadZone(double zone) {
        if (zone >= 0.0 && zone <= 1.0) {
            this.leftTriggerDeadZone = (short)Math.round(255.0 * zone);
        }
    }

    public void setRightTriggerDeadZone(double zone) {
        if (zone >= 0.0 && zone <= 1.0) {
            this.rightTriggerDeadZone = (short)Math.round(255.0 * zone);
        }
    }

    public void setLeftThumbDeadZone(double zone) {
        if (zone >= 0.0 && zone <= 1.0) {
            this.leftThumbDeadZone = (short)Math.round(32767.0 * zone);
        }
    }

    public void setRightThumbDeadZone(double zone) {
        if (zone >= 0.0 && zone <= 1.0) {
            this.rightThumbDeadZone = (short)Math.round(32767.0 * zone);
        }
    }

    public void vibrate(int leftVal, int rightVal) {
        this.vibrate(leftVal, rightVal, 0);
    }

    public synchronized void vibrate(int leftVal, int rightVal, int duration) {
        if (this.isDisconnected) {
            return;
        }
        if (leftVal < 0 || leftVal > 65535) {
            JOptionPane.showMessageDialog(null, "left value must be 0..65535", "Fatal error while calling XboxController.vibrate", 0);
            System.exit(1);
        }
        if (rightVal < 0 || rightVal > 65535) {
            JOptionPane.showMessageDialog(null, "right value must be 0..65535", "Fatal error while calling XboxController.vibrate", 0);
            System.exit(1);
        }
        this.leftVal = leftVal;
        this.rightVal = rightVal;
        this.nh.invoke(2);
        if (duration > 0) {
            this.delay(duration);
            this.leftVal = 0;
            this.rightVal = 0;
            this.nh.invoke(2);
        }
    }

    public synchronized boolean isConnected() {
        if (this.isDisconnected) {
            return false;
        }
        return this.nh.invoke(1) == 1;
    }

    private int countBuf() {
        return this.nh.countBuf() / 9;
    }

    private synchronized ControllerState readData() {
        if (this.countBuf() <= 0) {
            return null;
        }
        this.nh.readBuf(9);
        ControllerState cs = new ControllerState();
        cs.buttons = this.values[0];
        cs.leftTrigger = this.values[1];
        cs.rightTrigger = this.values[2];
        cs.thumbLX = this.values[3];
        cs.thumbLY = this.values[4];
        cs.thumbRX = this.values[5];
        cs.thumbRY = this.values[6];
        cs.success = this.values[7];
        cs.source = this.values[8];
        if (this.debug) {
            System.out.println("Got at " + this.nh.invoke(4) + ": " + this.values[0] + ", " + this.values[1] + ", " + this.values[2] + ", " + this.values[3] + ", " + this.values[4] + ", " + this.values[5] + ", " + this.values[6] + ", " + this.values[7] + ", " + this.values[8]);
        }
        return cs;
    }

    public void addXboxControllerListener(XboxControllerListener xboxControllerListener) {
        if (this.pollTimer != null) {
            this.pollTimer.stop();
        }
        if (xboxControllerListener == null) {
            return;
        }
        this.listener = xboxControllerListener;
        final DigitalCallback[] dfunc = new DigitalCallback[]{new DigitalCallback.F0(this.listener), new DigitalCallback.F1(this.listener), new DigitalCallback.F2(this.listener), new DigitalCallback.F3(this.listener), new DigitalCallback.F4(this.listener), new DigitalCallback.F5(this.listener), new DigitalCallback.F6(this.listener), new DigitalCallback.F7(this.listener), new DigitalCallback.F8(this.listener), new DigitalCallback.F9(this.listener)};
        ActionListener pollPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControllerState cs = XboxController.this.readData();
                if (cs != null) {
                    if ((cs.source & 1) != 0) {
                        int buttons = cs.buttons & 0xFFFF;
                        int id = buttons & 0xF;
                        if (id != 0) {
                            if (id != XboxController.this.dpadState) {
                                if (XboxController.this.dpadState != -1) {
                                    XboxController.this.listener.dpad(XboxController.this.dpadDirection, false);
                                }
                                for (int i = 0; i < 8; ++i) {
                                    if (id != ControllerState.digitalId[i]) continue;
                                    XboxController.this.listener.dpad(i, true);
                                    XboxController.this.dpadDirection = i;
                                    XboxController.this.dpadState = id;
                                }
                            }
                        } else if (XboxController.this.dpadState != -1) {
                            XboxController.this.listener.dpad(XboxController.this.dpadDirection, false);
                            XboxController.this.dpadState = -1;
                        }
                        int bitValue = 1;
                        for (int i = 8; i < 18; ++i) {
                            if ((buttons & ControllerState.digitalId[i]) != 0) {
                                if ((XboxController.this.buttonState & (long)bitValue) == 0L) {
                                    dfunc[i - 8].invoke(true);
                                    XboxController.this.buttonState += bitValue;
                                }
                            } else if ((XboxController.this.buttonState & (long)bitValue) != 0L) {
                                dfunc[i - 8].invoke(false);
                                XboxController.this.buttonState -= bitValue;
                            }
                            bitValue *= 2;
                        }
                    }
                    if ((cs.source & 0x80) != 0) {
                        XboxController.this.nh.flushBuf();
                        XboxController.this.listener.isConnected(cs.success == 1);
                    } else {
                        short value;
                        if ((cs.source & 2) != 0) {
                            value = cs.leftTrigger;
                            if (value > XboxController.this.leftTriggerDeadZone) {
                                if ((double)(value = (short)(value - XboxController.this.leftTriggerDeadZone)) != XboxController.this.oldLeftTriggerValue) {
                                    XboxController.this.listener.leftTrigger((double)value / (255.0 - (double)XboxController.this.leftTriggerDeadZone));
                                    XboxController.this.oldLeftTriggerValue = value;
                                }
                            } else {
                                value = 0;
                                if ((double)value != XboxController.this.oldLeftTriggerValue) {
                                    XboxController.this.listener.leftTrigger(value);
                                    XboxController.this.oldLeftTriggerValue = 0.0;
                                }
                            }
                        }
                        if ((cs.source & 4) != 0) {
                            value = cs.rightTrigger;
                            if (value > XboxController.this.rightTriggerDeadZone) {
                                if ((double)(value = (short)(value - XboxController.this.rightTriggerDeadZone)) != XboxController.this.oldRightTriggerValue) {
                                    XboxController.this.listener.rightTrigger((double)value / (255.0 - (double)XboxController.this.rightTriggerDeadZone));
                                    XboxController.this.oldRightTriggerValue = value;
                                }
                            } else {
                                value = 0;
                                if ((double)value != XboxController.this.oldRightTriggerValue) {
                                    XboxController.this.listener.rightTrigger(value);
                                    XboxController.this.oldRightTriggerValue = 0.0;
                                }
                            }
                        }
                        if ((cs.source & 8) != 0 || (cs.source & 0x10) != 0) {
                            double magnitude = Math.sqrt(cs.thumbLX * cs.thumbLX + cs.thumbLY * cs.thumbLY);
                            double dir = Math.atan2(cs.thumbLX, cs.thumbLY) / Math.PI * 180.0;
                            if (dir < 0.0) {
                                dir = 360.0 + dir;
                            }
                            if (magnitude > 32767.0) {
                                magnitude = 32767.0;
                            }
                            if (magnitude > (double)XboxController.this.leftThumbDeadZone) {
                                if ((magnitude -= (double)XboxController.this.leftThumbDeadZone) != XboxController.this.oldLeftMagnitude) {
                                    XboxController.this.listener.leftThumbMagnitude(magnitude / (32767.0 - (double)XboxController.this.leftThumbDeadZone));
                                    XboxController.this.oldLeftMagnitude = magnitude;
                                }
                                if (dir != XboxController.this.oldLeftDir) {
                                    XboxController.this.listener.leftThumbDirection(dir);
                                    XboxController.this.oldLeftDir = dir;
                                }
                            } else {
                                magnitude = 0.0;
                                if (magnitude != XboxController.this.oldLeftMagnitude) {
                                    XboxController.this.listener.leftThumbMagnitude(magnitude);
                                    XboxController.this.oldLeftMagnitude = 0.0;
                                }
                            }
                        }
                        if ((cs.source & 0x20) != 0 || (cs.source & 0x40) != 0) {
                            double magnitude = Math.sqrt(cs.thumbRX * cs.thumbRX + cs.thumbRY * cs.thumbRY);
                            double dir = Math.atan2(cs.thumbRX, cs.thumbRY) / Math.PI * 180.0;
                            if (dir < 0.0) {
                                dir = 360.0 + dir;
                            }
                            if (magnitude > 32767.0) {
                                magnitude = 32767.0;
                            }
                            if (magnitude > (double)XboxController.this.rightThumbDeadZone) {
                                if ((magnitude -= (double)XboxController.this.rightThumbDeadZone) != XboxController.this.oldRightMagnitude) {
                                    XboxController.this.listener.rightThumbMagnitude(magnitude / (32767.0 - (double)XboxController.this.rightThumbDeadZone));
                                    XboxController.this.oldRightMagnitude = magnitude;
                                }
                                if (dir != XboxController.this.oldRightDir) {
                                    XboxController.this.listener.rightThumbDirection(dir);
                                    XboxController.this.oldRightDir = dir;
                                }
                            } else {
                                magnitude = 0.0;
                                if (magnitude != XboxController.this.oldRightMagnitude) {
                                    XboxController.this.listener.rightThumbMagnitude(magnitude);
                                    XboxController.this.oldRightMagnitude = 0.0;
                                }
                            }
                        }
                    }
                }
            }
        };
        this.nh.flushBuf();
        this.pollTimer = new Timer(this.queuePollPeriod, pollPerformer);
        this.pollTimer.start();
    }

    public static String getVersion() {
        return version;
    }

    public void setDebug(boolean on) {
        if (on) {
            System.out.println("\nDebug on. Format:\nnpcc, buttons, leftTrigger, rightTrigger, thumbLX, thumbLY, thumbRX, thumbRY, success, source\nnpcc: native poll clock count");
        } else {
            System.out.println("\nDebug off");
        }
        this.debug = on;
        this.nh.invoke(3);
    }

    private void delay(int duration) {
        try {
            Thread.currentThread();
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean is64bit() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }
}

